/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.encoder;

import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.CharacterSetECI;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonEncoder;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.Mode;
import com.google.zxing.qrcode.decoder.Version;
import com.google.zxing.qrcode.encoder.BlockPair;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.MaskUtil;
import com.google.zxing.qrcode.encoder.MatrixUtil;
import com.google.zxing.qrcode.encoder.QRCode;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;

public final class Encoder {
    private static final int[] ALPHANUMERIC_TABLE = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 36, -1, -1, -1, 37, 38, -1, -1, -1, -1, 39, 40, -1, 41, 42, 43, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 44, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, -1, -1, -1, -1, -1};
    static final String DEFAULT_BYTE_MODE_ENCODING = "ISO-8859-1";

    private Encoder() {
    }

    private static int calculateMaskPenalty(ByteMatrix byteMatrix) {
        return MaskUtil.applyMaskPenaltyRule1(byteMatrix) + MaskUtil.applyMaskPenaltyRule2(byteMatrix) + MaskUtil.applyMaskPenaltyRule3(byteMatrix) + MaskUtil.applyMaskPenaltyRule4(byteMatrix);
    }

    public static QRCode encode(String string2, ErrorCorrectionLevel errorCorrectionLevel) throws WriterException {
        return Encoder.encode(string2, errorCorrectionLevel, null);
    }

    public static QRCode encode(String string2, ErrorCorrectionLevel errorCorrectionLevel, Map<EncodeHintType, ?> map) throws WriterException {
        Object object;
        String string3;
        String string4 = string3 = map == null ? null : (String)map.get((Object)EncodeHintType.CHARACTER_SET);
        if (string3 == null) {
            string3 = DEFAULT_BYTE_MODE_ENCODING;
        }
        Mode mode = Encoder.chooseMode(string2, string3);
        BitArray bitArray = new BitArray();
        if (mode == Mode.BYTE && !DEFAULT_BYTE_MODE_ENCODING.equals(string3) && (object = CharacterSetECI.getCharacterSetECIByName(string3)) != null) {
            Encoder.appendECI((CharacterSetECI)((Object)object), bitArray);
        }
        Encoder.appendModeInfo(mode, bitArray);
        object = new BitArray();
        Encoder.appendBytes(string2, mode, (BitArray)object, string3);
        int n2 = bitArray.getSize() + mode.getCharacterCountBits(Version.getVersionForNumber(1)) + ((BitArray)object).getSize();
        Version version = Encoder.chooseVersion(n2, errorCorrectionLevel);
        int n3 = bitArray.getSize() + mode.getCharacterCountBits(version) + ((BitArray)object).getSize();
        Version version2 = Encoder.chooseVersion(n3, errorCorrectionLevel);
        BitArray bitArray2 = new BitArray();
        bitArray2.appendBitArray(bitArray);
        int n4 = mode == Mode.BYTE ? ((BitArray)object).getSizeInBytes() : string2.length();
        Encoder.appendLengthInfo(n4, version2, mode, bitArray2);
        bitArray2.appendBitArray((BitArray)object);
        Version.ECBlocks eCBlocks = version2.getECBlocksForLevel(errorCorrectionLevel);
        int n5 = version2.getTotalCodewords() - eCBlocks.getTotalECCodewords();
        Encoder.terminateBits(n5, bitArray2);
        BitArray bitArray3 = Encoder.interleaveWithECBytes(bitArray2, version2.getTotalCodewords(), n5, eCBlocks.getNumBlocks());
        QRCode qRCode = new QRCode();
        qRCode.setECLevel(errorCorrectionLevel);
        qRCode.setMode(mode);
        qRCode.setVersion(version2);
        int n6 = version2.getDimensionForVersion();
        ByteMatrix byteMatrix = new ByteMatrix(n6, n6);
        int n7 = Encoder.chooseMaskPattern(bitArray3, errorCorrectionLevel, version2, byteMatrix);
        qRCode.setMaskPattern(n7);
        MatrixUtil.buildMatrix(bitArray3, errorCorrectionLevel, version2, n7, byteMatrix);
        qRCode.setMatrix(byteMatrix);
        return qRCode;
    }

    static int getAlphanumericCode(int n2) {
        if (n2 < ALPHANUMERIC_TABLE.length) {
            return ALPHANUMERIC_TABLE[n2];
        }
        return -1;
    }

    public static Mode chooseMode(String string2) {
        return Encoder.chooseMode(string2, null);
    }

    private static Mode chooseMode(String string2, String string3) {
        if ("Shift_JIS".equals(string3)) {
            return Encoder.isOnlyDoubleByteKanji(string2) ? Mode.KANJI : Mode.BYTE;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            char c2 = string2.charAt(i2);
            if (c2 >= '0' && c2 <= '9') {
                bl2 = true;
                continue;
            }
            if (Encoder.getAlphanumericCode(c2) != -1) {
                bl3 = true;
                continue;
            }
            return Mode.BYTE;
        }
        if (bl3) {
            return Mode.ALPHANUMERIC;
        }
        if (bl2) {
            return Mode.NUMERIC;
        }
        return Mode.BYTE;
    }

    private static boolean isOnlyDoubleByteKanji(String string2) {
        byte[] byArray;
        try {
            byArray = string2.getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
        int n2 = byArray.length;
        if (n2 % 2 != 0) {
            return false;
        }
        for (int i2 = 0; i2 < n2; i2 += 2) {
            int n3 = byArray[i2] & 0xFF;
            if (n3 >= 129 && n3 <= 159 || n3 >= 224 && n3 <= 235) continue;
            return false;
        }
        return true;
    }

    private static int chooseMaskPattern(BitArray bitArray, ErrorCorrectionLevel errorCorrectionLevel, Version version, ByteMatrix byteMatrix) throws WriterException {
        int n2 = Integer.MAX_VALUE;
        int n3 = -1;
        for (int i2 = 0; i2 < 8; ++i2) {
            MatrixUtil.buildMatrix(bitArray, errorCorrectionLevel, version, i2, byteMatrix);
            int n4 = Encoder.calculateMaskPenalty(byteMatrix);
            if (n4 >= n2) continue;
            n2 = n4;
            n3 = i2;
        }
        return n3;
    }

    private static Version chooseVersion(int n2, ErrorCorrectionLevel errorCorrectionLevel) throws WriterException {
        for (int i2 = 1; i2 <= 40; ++i2) {
            int n3;
            Version.ECBlocks eCBlocks;
            int n4;
            Version version = Version.getVersionForNumber(i2);
            int n5 = version.getTotalCodewords();
            int n6 = n5 - (n4 = (eCBlocks = version.getECBlocksForLevel(errorCorrectionLevel)).getTotalECCodewords());
            if (n6 < (n3 = (n2 + 7) / 8)) continue;
            return version;
        }
        throw new WriterException("Data too big");
    }

    static void terminateBits(int n2, BitArray bitArray) throws WriterException {
        int n3;
        int n4;
        int n5 = n2 * 8;
        if (bitArray.getSize() > n5) {
            throw new WriterException("data bits cannot fit in the QR Code" + bitArray.getSize() + " > " + n5);
        }
        for (n4 = 0; n4 < 4 && bitArray.getSize() < n5; ++n4) {
            bitArray.appendBit(false);
        }
        n4 = bitArray.getSize() & 7;
        if (n4 > 0) {
            for (n3 = n4; n3 < 8; ++n3) {
                bitArray.appendBit(false);
            }
        }
        n3 = n2 - bitArray.getSizeInBytes();
        for (int i2 = 0; i2 < n3; ++i2) {
            bitArray.appendBits((i2 & 1) == 0 ? 236 : 17, 8);
        }
        if (bitArray.getSize() != n5) {
            throw new WriterException("Bits size does not equal capacity");
        }
    }

    static void getNumDataBytesAndNumECBytesForBlockID(int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2) throws WriterException {
        if (n5 >= n4) {
            throw new WriterException("Block ID too large");
        }
        int n6 = n2 % n4;
        int n7 = n4 - n6;
        int n8 = n2 / n4;
        int n9 = n3 / n4;
        int n10 = n8 - n9;
        int n11 = n8 + 1;
        int n12 = n9 + 1;
        int n13 = n11 - n12;
        if (n10 != n13) {
            throw new WriterException("EC bytes mismatch");
        }
        if (n4 != n7 + n6) {
            throw new WriterException("RS blocks mismatch");
        }
        if (n2 != (n9 + n10) * n7 + (n12 + n13) * n6) {
            throw new WriterException("Total bytes mismatch");
        }
        if (n5 < n7) {
            nArray[0] = n9;
            nArray2[0] = n10;
        } else {
            nArray[0] = n12;
            nArray2[0] = n13;
        }
    }

    static BitArray interleaveWithECBytes(BitArray bitArray, int n2, int n3, int n4) throws WriterException {
        int n5;
        byte[] byArray;
        Object object;
        if (bitArray.getSizeInBytes() != n3) {
            throw new WriterException("Number of bits and data bytes does not match");
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        ArrayList<BlockPair> arrayList = new ArrayList<BlockPair>(n4);
        for (int i2 = 0; i2 < n4; ++i2) {
            int[] nArray = new int[1];
            object = new int[1];
            Encoder.getNumDataBytesAndNumECBytesForBlockID(n2, n3, n4, i2, nArray, (int[])object);
            int n9 = nArray[0];
            byArray = new byte[n9];
            bitArray.toBytes(8 * n6, byArray, 0, n9);
            byte[] byArray2 = Encoder.generateECBytes(byArray, (int)object[0]);
            arrayList.add(new BlockPair(byArray, byArray2));
            n7 = Math.max(n7, n9);
            n8 = Math.max(n8, byArray2.length);
            n6 += nArray[0];
        }
        if (n3 != n6) {
            throw new WriterException("Data bytes does not match offset");
        }
        BitArray bitArray2 = new BitArray();
        for (n5 = 0; n5 < n7; ++n5) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                BlockPair blockPair = (BlockPair)object.next();
                byArray = blockPair.getDataBytes();
                if (n5 >= byArray.length) continue;
                bitArray2.appendBits(byArray[n5], 8);
            }
        }
        for (n5 = 0; n5 < n8; ++n5) {
            for (BlockPair blockPair : arrayList) {
                byArray = blockPair.getErrorCorrectionBytes();
                if (n5 >= byArray.length) continue;
                bitArray2.appendBits(byArray[n5], 8);
            }
        }
        if (n2 != bitArray2.getSizeInBytes()) {
            throw new WriterException("Interleaving error: " + n2 + " and " + bitArray2.getSizeInBytes() + " differ.");
        }
        return bitArray2;
    }

    static byte[] generateECBytes(byte[] byArray, int n2) {
        int n3 = byArray.length;
        int[] nArray = new int[n3 + n2];
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[i2] = byArray[i2] & 0xFF;
        }
        new ReedSolomonEncoder(GenericGF.QR_CODE_FIELD_256).encode(nArray, n2);
        byte[] byArray2 = new byte[n2];
        for (int i3 = 0; i3 < n2; ++i3) {
            byArray2[i3] = (byte)nArray[n3 + i3];
        }
        return byArray2;
    }

    static void appendModeInfo(Mode mode, BitArray bitArray) {
        bitArray.appendBits(mode.getBits(), 4);
    }

    static void appendLengthInfo(int n2, Version version, Mode mode, BitArray bitArray) throws WriterException {
        int n3 = mode.getCharacterCountBits(version);
        if (n2 >= 1 << n3) {
            throw new WriterException(n2 + " is bigger than " + ((1 << n3) - 1));
        }
        bitArray.appendBits(n2, n3);
    }

    static void appendBytes(String string2, Mode mode, BitArray bitArray, String string3) throws WriterException {
        switch (mode) {
            case NUMERIC: {
                Encoder.appendNumericBytes(string2, bitArray);
                break;
            }
            case ALPHANUMERIC: {
                Encoder.appendAlphanumericBytes(string2, bitArray);
                break;
            }
            case BYTE: {
                Encoder.append8BitBytes(string2, bitArray, string3);
                break;
            }
            case KANJI: {
                Encoder.appendKanjiBytes(string2, bitArray);
                break;
            }
            default: {
                throw new WriterException("Invalid mode: " + (Object)((Object)mode));
            }
        }
    }

    static void appendNumericBytes(CharSequence charSequence, BitArray bitArray) {
        int n2 = charSequence.length();
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5 = charSequence.charAt(n3) - 48;
            if (n3 + 2 < n2) {
                n4 = charSequence.charAt(n3 + 1) - 48;
                int n6 = charSequence.charAt(n3 + 2) - 48;
                bitArray.appendBits(n5 * 100 + n4 * 10 + n6, 10);
                n3 += 3;
                continue;
            }
            if (n3 + 1 < n2) {
                n4 = charSequence.charAt(n3 + 1) - 48;
                bitArray.appendBits(n5 * 10 + n4, 7);
                n3 += 2;
                continue;
            }
            bitArray.appendBits(n5, 4);
            ++n3;
        }
    }

    static void appendAlphanumericBytes(CharSequence charSequence, BitArray bitArray) throws WriterException {
        int n2 = charSequence.length();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = Encoder.getAlphanumericCode(charSequence.charAt(n3));
            if (n4 == -1) {
                throw new WriterException();
            }
            if (n3 + 1 < n2) {
                int n5 = Encoder.getAlphanumericCode(charSequence.charAt(n3 + 1));
                if (n5 == -1) {
                    throw new WriterException();
                }
                bitArray.appendBits(n4 * 45 + n5, 11);
                n3 += 2;
                continue;
            }
            bitArray.appendBits(n4, 6);
            ++n3;
        }
    }

    static void append8BitBytes(String string2, BitArray bitArray, String string3) throws WriterException {
        byte[] byArray;
        try {
            byArray = string2.getBytes(string3);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new WriterException(unsupportedEncodingException);
        }
        for (byte by2 : byArray) {
            bitArray.appendBits(by2, 8);
        }
    }

    static void appendKanjiBytes(String string2, BitArray bitArray) throws WriterException {
        byte[] byArray;
        try {
            byArray = string2.getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new WriterException(unsupportedEncodingException);
        }
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; i2 += 2) {
            int n3 = byArray[i2] & 0xFF;
            int n4 = byArray[i2 + 1] & 0xFF;
            int n5 = n3 << 8 | n4;
            int n6 = -1;
            if (n5 >= 33088 && n5 <= 40956) {
                n6 = n5 - 33088;
            } else if (n5 >= 57408 && n5 <= 60351) {
                n6 = n5 - 49472;
            }
            if (n6 == -1) {
                throw new WriterException("Invalid byte sequence");
            }
            int n7 = (n6 >> 8) * 192 + (n6 & 0xFF);
            bitArray.appendBits(n7, 13);
        }
    }

    private static void appendECI(CharacterSetECI characterSetECI, BitArray bitArray) {
        bitArray.appendBits(Mode.ECI.getBits(), 4);
        bitArray.appendBits(characterSetECI.getValue(), 8);
    }
}

