/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.encoder;

import com.google.zxing.qrcode.encoder.ByteMatrix;

final class MaskUtil {
    private static final int N1 = 3;
    private static final int N2 = 3;
    private static final int N3 = 40;
    private static final int N4 = 10;

    private MaskUtil() {
    }

    static int applyMaskPenaltyRule1(ByteMatrix byteMatrix) {
        return MaskUtil.applyMaskPenaltyRule1Internal(byteMatrix, true) + MaskUtil.applyMaskPenaltyRule1Internal(byteMatrix, false);
    }

    static int applyMaskPenaltyRule2(ByteMatrix byteMatrix) {
        int n2 = 0;
        byte[][] byArray = byteMatrix.getArray();
        int n3 = byteMatrix.getWidth();
        int n4 = byteMatrix.getHeight();
        for (int i2 = 0; i2 < n4 - 1; ++i2) {
            for (int i3 = 0; i3 < n3 - 1; ++i3) {
                byte by2 = byArray[i2][i3];
                if (by2 != byArray[i2][i3 + 1] || by2 != byArray[i2 + 1][i3] || by2 != byArray[i2 + 1][i3 + 1]) continue;
                ++n2;
            }
        }
        return 3 * n2;
    }

    static int applyMaskPenaltyRule3(ByteMatrix byteMatrix) {
        int n2 = 0;
        byte[][] byArray = byteMatrix.getArray();
        int n3 = byteMatrix.getWidth();
        int n4 = byteMatrix.getHeight();
        for (int i2 = 0; i2 < n4; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                byte[] byArray2 = byArray[i2];
                if (i3 + 6 < n3 && byArray2[i3] == 1 && byArray2[i3 + 1] == 0 && byArray2[i3 + 2] == 1 && byArray2[i3 + 3] == 1 && byArray2[i3 + 4] == 1 && byArray2[i3 + 5] == 0 && byArray2[i3 + 6] == 1 && (MaskUtil.isWhiteHorizontal(byArray2, i3 - 4, i3) || MaskUtil.isWhiteHorizontal(byArray2, i3 + 7, i3 + 11))) {
                    ++n2;
                }
                if (i2 + 6 >= n4 || byArray[i2][i3] != 1 || byArray[i2 + 1][i3] != 0 || byArray[i2 + 2][i3] != 1 || byArray[i2 + 3][i3] != 1 || byArray[i2 + 4][i3] != 1 || byArray[i2 + 5][i3] != 0 || byArray[i2 + 6][i3] != 1 || !MaskUtil.isWhiteVertical(byArray, i3, i2 - 4, i2) && !MaskUtil.isWhiteVertical(byArray, i3, i2 + 7, i2 + 11)) continue;
                ++n2;
            }
        }
        return n2 * 40;
    }

    private static boolean isWhiteHorizontal(byte[] byArray, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            if (i2 < 0 || i2 >= byArray.length || byArray[i2] != 1) continue;
            return false;
        }
        return true;
    }

    private static boolean isWhiteVertical(byte[][] byArray, int n2, int n3, int n4) {
        for (int i2 = n3; i2 < n4; ++i2) {
            if (i2 < 0 || i2 >= byArray.length || byArray[i2][n2] != 1) continue;
            return false;
        }
        return true;
    }

    static int applyMaskPenaltyRule4(ByteMatrix byteMatrix) {
        int n2;
        int n3 = 0;
        byte[][] byArray = byteMatrix.getArray();
        int n4 = byteMatrix.getWidth();
        int n5 = byteMatrix.getHeight();
        for (n2 = 0; n2 < n5; ++n2) {
            byte[] byArray2 = byArray[n2];
            for (int i2 = 0; i2 < n4; ++i2) {
                if (byArray2[i2] != 1) continue;
                ++n3;
            }
        }
        n2 = byteMatrix.getHeight() * byteMatrix.getWidth();
        int n6 = Math.abs(n3 * 2 - n2) * 10 / n2;
        return n6 * 10;
    }

    static boolean getDataMaskBit(int n2, int n3, int n4) {
        int n5;
        switch (n2) {
            case 0: {
                n5 = n4 + n3 & 1;
                break;
            }
            case 1: {
                n5 = n4 & 1;
                break;
            }
            case 2: {
                n5 = n3 % 3;
                break;
            }
            case 3: {
                n5 = (n4 + n3) % 3;
                break;
            }
            case 4: {
                n5 = n4 / 2 + n3 / 3 & 1;
                break;
            }
            case 5: {
                int n6 = n4 * n3;
                n5 = (n6 & 1) + n6 % 3;
                break;
            }
            case 6: {
                int n7 = n4 * n3;
                n5 = (n7 & 1) + n7 % 3 & 1;
                break;
            }
            case 7: {
                int n8 = n4 * n3;
                n5 = n8 % 3 + (n4 + n3 & 1) & 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid mask pattern: " + n2);
            }
        }
        return n5 == 0;
    }

    private static int applyMaskPenaltyRule1Internal(ByteMatrix byteMatrix, boolean bl2) {
        int n2 = 0;
        int n3 = bl2 ? byteMatrix.getHeight() : byteMatrix.getWidth();
        int n4 = bl2 ? byteMatrix.getWidth() : byteMatrix.getHeight();
        byte[][] byArray = byteMatrix.getArray();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5 = 0;
            byte by2 = -1;
            for (int i3 = 0; i3 < n4; ++i3) {
                byte by3;
                byte by4 = by3 = bl2 ? byArray[i2][i3] : byArray[i3][i2];
                if (by3 == by2) {
                    ++n5;
                    continue;
                }
                if (n5 >= 5) {
                    n2 += 3 + (n5 - 5);
                }
                n5 = 1;
                by2 = by3;
            }
            if (n5 < 5) continue;
            n2 += 3 + (n5 - 5);
        }
        return n2;
    }
}

