/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.encoder;

import com.google.zxing.WriterException;
import com.google.zxing.common.BitArray;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.Version;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.MaskUtil;
import com.google.zxing.qrcode.encoder.QRCode;

final class MatrixUtil {
    private static final int[][] POSITION_DETECTION_PATTERN = new int[][]{{1, 1, 1, 1, 1, 1, 1}, {1, 0, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 1, 0, 1}, {1, 0, 1, 1, 1, 0, 1}, {1, 0, 1, 1, 1, 0, 1}, {1, 0, 0, 0, 0, 0, 1}, {1, 1, 1, 1, 1, 1, 1}};
    private static final int[][] POSITION_ADJUSTMENT_PATTERN = new int[][]{{1, 1, 1, 1, 1}, {1, 0, 0, 0, 1}, {1, 0, 1, 0, 1}, {1, 0, 0, 0, 1}, {1, 1, 1, 1, 1}};
    private static final int[][] POSITION_ADJUSTMENT_PATTERN_COORDINATE_TABLE = new int[][]{{-1, -1, -1, -1, -1, -1, -1}, {6, 18, -1, -1, -1, -1, -1}, {6, 22, -1, -1, -1, -1, -1}, {6, 26, -1, -1, -1, -1, -1}, {6, 30, -1, -1, -1, -1, -1}, {6, 34, -1, -1, -1, -1, -1}, {6, 22, 38, -1, -1, -1, -1}, {6, 24, 42, -1, -1, -1, -1}, {6, 26, 46, -1, -1, -1, -1}, {6, 28, 50, -1, -1, -1, -1}, {6, 30, 54, -1, -1, -1, -1}, {6, 32, 58, -1, -1, -1, -1}, {6, 34, 62, -1, -1, -1, -1}, {6, 26, 46, 66, -1, -1, -1}, {6, 26, 48, 70, -1, -1, -1}, {6, 26, 50, 74, -1, -1, -1}, {6, 30, 54, 78, -1, -1, -1}, {6, 30, 56, 82, -1, -1, -1}, {6, 30, 58, 86, -1, -1, -1}, {6, 34, 62, 90, -1, -1, -1}, {6, 28, 50, 72, 94, -1, -1}, {6, 26, 50, 74, 98, -1, -1}, {6, 30, 54, 78, 102, -1, -1}, {6, 28, 54, 80, 106, -1, -1}, {6, 32, 58, 84, 110, -1, -1}, {6, 30, 58, 86, 114, -1, -1}, {6, 34, 62, 90, 118, -1, -1}, {6, 26, 50, 74, 98, 122, -1}, {6, 30, 54, 78, 102, 126, -1}, {6, 26, 52, 78, 104, 130, -1}, {6, 30, 56, 82, 108, 134, -1}, {6, 34, 60, 86, 112, 138, -1}, {6, 30, 58, 86, 114, 142, -1}, {6, 34, 62, 90, 118, 146, -1}, {6, 30, 54, 78, 102, 126, 150}, {6, 24, 50, 76, 102, 128, 154}, {6, 28, 54, 80, 106, 132, 158}, {6, 32, 58, 84, 110, 136, 162}, {6, 26, 54, 82, 110, 138, 166}, {6, 30, 58, 86, 114, 142, 170}};
    private static final int[][] TYPE_INFO_COORDINATES = new int[][]{{8, 0}, {8, 1}, {8, 2}, {8, 3}, {8, 4}, {8, 5}, {8, 7}, {8, 8}, {7, 8}, {5, 8}, {4, 8}, {3, 8}, {2, 8}, {1, 8}, {0, 8}};
    private static final int VERSION_INFO_POLY = 7973;
    private static final int TYPE_INFO_POLY = 1335;
    private static final int TYPE_INFO_MASK_PATTERN = 21522;

    private MatrixUtil() {
    }

    static void clearMatrix(ByteMatrix byteMatrix) {
        byteMatrix.clear((byte)-1);
    }

    static void buildMatrix(BitArray bitArray, ErrorCorrectionLevel errorCorrectionLevel, Version version, int n2, ByteMatrix byteMatrix) throws WriterException {
        MatrixUtil.clearMatrix(byteMatrix);
        MatrixUtil.embedBasicPatterns(version, byteMatrix);
        MatrixUtil.embedTypeInfo(errorCorrectionLevel, n2, byteMatrix);
        MatrixUtil.maybeEmbedVersionInfo(version, byteMatrix);
        MatrixUtil.embedDataBits(bitArray, n2, byteMatrix);
    }

    static void embedBasicPatterns(Version version, ByteMatrix byteMatrix) throws WriterException {
        MatrixUtil.embedPositionDetectionPatternsAndSeparators(byteMatrix);
        MatrixUtil.embedDarkDotAtLeftBottomCorner(byteMatrix);
        MatrixUtil.maybeEmbedPositionAdjustmentPatterns(version, byteMatrix);
        MatrixUtil.embedTimingPatterns(byteMatrix);
    }

    static void embedTypeInfo(ErrorCorrectionLevel errorCorrectionLevel, int n2, ByteMatrix byteMatrix) throws WriterException {
        BitArray bitArray = new BitArray();
        MatrixUtil.makeTypeInfoBits(errorCorrectionLevel, n2, bitArray);
        for (int i2 = 0; i2 < bitArray.getSize(); ++i2) {
            int n3;
            int n4;
            boolean bl2 = bitArray.get(bitArray.getSize() - 1 - i2);
            int n5 = TYPE_INFO_COORDINATES[i2][0];
            int n6 = TYPE_INFO_COORDINATES[i2][1];
            byteMatrix.set(n5, n6, bl2);
            if (i2 < 8) {
                n4 = byteMatrix.getWidth() - i2 - 1;
                n3 = 8;
                byteMatrix.set(n4, n3, bl2);
                continue;
            }
            n4 = 8;
            n3 = byteMatrix.getHeight() - 7 + (i2 - 8);
            byteMatrix.set(n4, n3, bl2);
        }
    }

    static void maybeEmbedVersionInfo(Version version, ByteMatrix byteMatrix) throws WriterException {
        if (version.getVersionNumber() < 7) {
            return;
        }
        BitArray bitArray = new BitArray();
        MatrixUtil.makeVersionInfoBits(version, bitArray);
        int n2 = 17;
        for (int i2 = 0; i2 < 6; ++i2) {
            for (int i3 = 0; i3 < 3; ++i3) {
                boolean bl2 = bitArray.get(n2);
                --n2;
                byteMatrix.set(i2, byteMatrix.getHeight() - 11 + i3, bl2);
                byteMatrix.set(byteMatrix.getHeight() - 11 + i3, i2, bl2);
            }
        }
    }

    static void embedDataBits(BitArray bitArray, int n2, ByteMatrix byteMatrix) throws WriterException {
        int n3 = 0;
        int n4 = -1;
        int n5 = byteMatrix.getHeight() - 1;
        for (int i2 = byteMatrix.getWidth() - 1; i2 > 0; i2 -= 2) {
            if (i2 == 6) {
                --i2;
            }
            while (n5 >= 0 && n5 < byteMatrix.getHeight()) {
                for (int i3 = 0; i3 < 2; ++i3) {
                    boolean bl2;
                    int n6 = i2 - i3;
                    if (!MatrixUtil.isEmpty(byteMatrix.get(n6, n5))) continue;
                    if (n3 < bitArray.getSize()) {
                        bl2 = bitArray.get(n3);
                        ++n3;
                    } else {
                        bl2 = false;
                    }
                    if (n2 != -1 && MaskUtil.getDataMaskBit(n2, n6, n5)) {
                        bl2 = !bl2;
                    }
                    byteMatrix.set(n6, n5, bl2);
                }
                n5 += n4;
            }
            n4 = -n4;
            n5 += n4;
        }
        if (n3 != bitArray.getSize()) {
            throw new WriterException("Not all bits consumed: " + n3 + '/' + bitArray.getSize());
        }
    }

    static int findMSBSet(int n2) {
        int n3 = 0;
        while (n2 != 0) {
            n2 >>>= 1;
            ++n3;
        }
        return n3;
    }

    static int calculateBCHCode(int n2, int n3) {
        if (n3 == 0) {
            throw new IllegalArgumentException("0 polynomial");
        }
        int n4 = MatrixUtil.findMSBSet(n3);
        n2 <<= n4 - 1;
        while (MatrixUtil.findMSBSet(n2) >= n4) {
            n2 ^= n3 << MatrixUtil.findMSBSet(n2) - n4;
        }
        return n2;
    }

    static void makeTypeInfoBits(ErrorCorrectionLevel errorCorrectionLevel, int n2, BitArray bitArray) throws WriterException {
        if (!QRCode.isValidMaskPattern(n2)) {
            throw new WriterException("Invalid mask pattern");
        }
        int n3 = errorCorrectionLevel.getBits() << 3 | n2;
        bitArray.appendBits(n3, 5);
        int n4 = MatrixUtil.calculateBCHCode(n3, 1335);
        bitArray.appendBits(n4, 10);
        BitArray bitArray2 = new BitArray();
        bitArray2.appendBits(21522, 15);
        bitArray.xor(bitArray2);
        if (bitArray.getSize() != 15) {
            throw new WriterException("should not happen but we got: " + bitArray.getSize());
        }
    }

    static void makeVersionInfoBits(Version version, BitArray bitArray) throws WriterException {
        bitArray.appendBits(version.getVersionNumber(), 6);
        int n2 = MatrixUtil.calculateBCHCode(version.getVersionNumber(), 7973);
        bitArray.appendBits(n2, 12);
        if (bitArray.getSize() != 18) {
            throw new WriterException("should not happen but we got: " + bitArray.getSize());
        }
    }

    private static boolean isEmpty(int n2) {
        return n2 == -1;
    }

    private static void embedTimingPatterns(ByteMatrix byteMatrix) {
        for (int i2 = 8; i2 < byteMatrix.getWidth() - 8; ++i2) {
            int n2 = (i2 + 1) % 2;
            if (MatrixUtil.isEmpty(byteMatrix.get(i2, 6))) {
                byteMatrix.set(i2, 6, n2);
            }
            if (!MatrixUtil.isEmpty(byteMatrix.get(6, i2))) continue;
            byteMatrix.set(6, i2, n2);
        }
    }

    private static void embedDarkDotAtLeftBottomCorner(ByteMatrix byteMatrix) throws WriterException {
        if (byteMatrix.get(8, byteMatrix.getHeight() - 8) == 0) {
            throw new WriterException();
        }
        byteMatrix.set(8, byteMatrix.getHeight() - 8, 1);
    }

    private static void embedHorizontalSeparationPattern(int n2, int n3, ByteMatrix byteMatrix) throws WriterException {
        for (int i2 = 0; i2 < 8; ++i2) {
            if (!MatrixUtil.isEmpty(byteMatrix.get(n2 + i2, n3))) {
                throw new WriterException();
            }
            byteMatrix.set(n2 + i2, n3, 0);
        }
    }

    private static void embedVerticalSeparationPattern(int n2, int n3, ByteMatrix byteMatrix) throws WriterException {
        for (int i2 = 0; i2 < 7; ++i2) {
            if (!MatrixUtil.isEmpty(byteMatrix.get(n2, n3 + i2))) {
                throw new WriterException();
            }
            byteMatrix.set(n2, n3 + i2, 0);
        }
    }

    private static void embedPositionAdjustmentPattern(int n2, int n3, ByteMatrix byteMatrix) {
        for (int i2 = 0; i2 < 5; ++i2) {
            for (int i3 = 0; i3 < 5; ++i3) {
                byteMatrix.set(n2 + i3, n3 + i2, POSITION_ADJUSTMENT_PATTERN[i2][i3]);
            }
        }
    }

    private static void embedPositionDetectionPattern(int n2, int n3, ByteMatrix byteMatrix) {
        for (int i2 = 0; i2 < 7; ++i2) {
            for (int i3 = 0; i3 < 7; ++i3) {
                byteMatrix.set(n2 + i3, n3 + i2, POSITION_DETECTION_PATTERN[i2][i3]);
            }
        }
    }

    private static void embedPositionDetectionPatternsAndSeparators(ByteMatrix byteMatrix) throws WriterException {
        int n2 = POSITION_DETECTION_PATTERN[0].length;
        MatrixUtil.embedPositionDetectionPattern(0, 0, byteMatrix);
        MatrixUtil.embedPositionDetectionPattern(byteMatrix.getWidth() - n2, 0, byteMatrix);
        MatrixUtil.embedPositionDetectionPattern(0, byteMatrix.getWidth() - n2, byteMatrix);
        int n3 = 8;
        MatrixUtil.embedHorizontalSeparationPattern(0, n3 - 1, byteMatrix);
        MatrixUtil.embedHorizontalSeparationPattern(byteMatrix.getWidth() - n3, n3 - 1, byteMatrix);
        MatrixUtil.embedHorizontalSeparationPattern(0, byteMatrix.getWidth() - n3, byteMatrix);
        int n4 = 7;
        MatrixUtil.embedVerticalSeparationPattern(n4, 0, byteMatrix);
        MatrixUtil.embedVerticalSeparationPattern(byteMatrix.getHeight() - n4 - 1, 0, byteMatrix);
        MatrixUtil.embedVerticalSeparationPattern(n4, byteMatrix.getHeight() - n4, byteMatrix);
    }

    private static void maybeEmbedPositionAdjustmentPatterns(Version version, ByteMatrix byteMatrix) {
        if (version.getVersionNumber() < 2) {
            return;
        }
        int n2 = version.getVersionNumber() - 1;
        int[] nArray = POSITION_ADJUSTMENT_PATTERN_COORDINATE_TABLE[n2];
        int n3 = POSITION_ADJUSTMENT_PATTERN_COORDINATE_TABLE[n2].length;
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                int n4 = nArray[i2];
                int n5 = nArray[i3];
                if (n5 == -1 || n4 == -1 || !MatrixUtil.isEmpty(byteMatrix.get(n5, n4))) continue;
                MatrixUtil.embedPositionAdjustmentPattern(n5 - 2, n4 - 2, byteMatrix);
            }
        }
    }
}

