/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.account;

import android.text.TextUtils;
import com.mi.milink.sdk.account.IAccount;
import com.mi.milink.sdk.account.manager.RSAPublicKey;
import com.mi.milink.sdk.debug.MiLinkLog;
import java.util.Random;

public class AnonymousAccount
extends IAccount {
    private static AnonymousAccount INSTANCE;

    public AnonymousAccount() {
    }

    public AnonymousAccount(int n2) {
        super(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AnonymousAccount getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<AnonymousAccount> clazz = AnonymousAccount.class;
        synchronized (AnonymousAccount.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new AnonymousAccount();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @Override
    protected String getPrefFileName() {
        return "milink_anonymous_account";
    }

    @Override
    protected String getTag() {
        return "AnonymousAccount";
    }

    protected String generatePrivacyKey() {
        StringBuilder stringBuilder = new StringBuilder(16);
        Random random = new Random();
        for (int i2 = 0; i2 < 16; ++i2) {
            int n2 = random.nextInt(25) + 97;
            stringBuilder.append((char)n2);
        }
        return stringBuilder.toString();
    }

    @Override
    protected int getAccountType() {
        return 1;
    }

    @Override
    public String getPrivacyKey() {
        if (TextUtils.isEmpty((CharSequence)this.mPrivacyKey)) {
            this.mPrivacyKey = this.generatePrivacyKey();
        }
        MiLinkLog.v(this.getTag(), "mPrivacyKey=" + this.mPrivacyKey);
        return this.mPrivacyKey;
    }

    @Override
    public String getServiceToken() {
        MiLinkLog.v(this.getTag(), "mServiceToken=" + this.mServiceToken);
        return this.mServiceToken;
    }

    @Override
    public void generateServiceTokenAndSSecurity() {
        if ("0".equals(this.mServiceToken) || TextUtils.isEmpty((CharSequence)this.mSSecurity)) {
            RSAPublicKey.PublicKeyAndId publicKeyAndId = RSAPublicKey.getPublicKeyAndId();
            this.mServiceToken = publicKeyAndId.id;
            this.mSSecurity = publicKeyAndId.key;
            MiLinkLog.v(this.getTag(), "generateServiceTokenAndSSecurity mServiceToken=" + this.mServiceToken + ",mSSecurity=" + this.mSSecurity);
        }
    }

    @Override
    public String getSSecurity() {
        MiLinkLog.v(this.getTag(), "mSSecurity=" + this.mSSecurity);
        return this.mSSecurity;
    }
}

