/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.account;

import android.text.TextUtils;
import com.mi.milink.sdk.account.AnonymousAccount;
import com.mi.milink.sdk.account.manager.RSAPublicKey;
import com.mi.milink.sdk.config.ConfigManager;
import com.mi.milink.sdk.debug.MiLinkLog;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class ChannelAccount
extends AnonymousAccount {
    private static final String PREF_CHANNLE_PUB_KEY_SUB = ":";
    int keepAliveTime = 240000;

    public ChannelAccount() {
        this.initPubKey();
    }

    public ChannelAccount(int n2) {
        super(n2);
        this.initPubKey();
    }

    public void initPubKey() {
        Set<String> set = ConfigManager.getInstance().getChannelPubKeys();
        if (set == null) {
            set = new HashSet<String>();
        }
        if (set.size() > 0) {
            return;
        }
        for (RSAPublicKey.PublicKeyAndId publicKeyAndId : new RSAPublicKey().getPublicKeySet()) {
            set.add(this.buildStoreValue(publicKeyAndId));
        }
        ConfigManager.getInstance().updateChannelPubKeySet(set);
    }

    public String buildStoreValue(RSAPublicKey.PublicKeyAndId publicKeyAndId) {
        return this.buildChannelPubKey(publicKeyAndId.id, publicKeyAndId.key);
    }

    @Override
    protected String getPrefFileName() {
        return "milink_channel_account";
    }

    @Override
    protected String getTag() {
        return String.format("ChannelAccount[No:%d]", this.mNo);
    }

    @Override
    protected int getAccountType() {
        return 2;
    }

    private String buildChannelPubKey(String string2, String string3) {
        string2 = String.valueOf(string2);
        return string2 + PREF_CHANNLE_PUB_KEY_SUB + string3;
    }

    private RSAPublicKey.PublicKeyAndId getRandomPublicKeyAndId() {
        Object object;
        String string2;
        Object object2;
        Object object3 = ConfigManager.getInstance().getChannelPubKeys();
        if (object3 == null) {
            MiLinkLog.v(this.getTag(), "getRandomPublicKeyAndId is null");
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        object3 = object3.iterator();
        while (object3.hasNext()) {
            object2 = ((String)object3.next()).split(PREF_CHANNLE_PUB_KEY_SUB);
            if (((String[])object2).length != 2) continue;
            hashMap = new HashMap();
            string2 = object2[0];
            object = object2[1];
            hashMap.put(string2, object);
        }
        if (hashMap.size() == 0) {
            MiLinkLog.v(this.getTag(), "getRandomPublicKeyAndId parseChannelPubKey map is null || size=0");
            return null;
        }
        object3 = hashMap.keySet().toArray(new String[0]);
        object2 = new Random();
        object2 = object3[((Random)object2).nextInt(hashMap.size())];
        string2 = (String)hashMap.get(object2);
        object = new RSAPublicKey.PublicKeyAndId((String)object2, string2);
        MiLinkLog.d(this.getTag(), "getRandomPublicKeyAndId find PublicKeyAndId id=" + (String)object2 + ", key=" + string2);
        return object;
    }

    private void generateServiceToken() {
        RSAPublicKey.PublicKeyAndId publicKeyAndId = this.getRandomPublicKeyAndId();
        if (publicKeyAndId == null) {
            publicKeyAndId = RSAPublicKey.getPublicKeyAndId();
        }
        this.mServiceToken = publicKeyAndId.id;
        this.mSSecurity = publicKeyAndId.key;
        MiLinkLog.v(this.getTag(), "generateServiceTokenAndSSecurity mServiceToken=" + this.mServiceToken + ",mSSecurity=" + this.mSSecurity);
    }

    @Override
    public void generateServiceTokenAndSSecurity() {
        if ("0".equals(this.mServiceToken) || TextUtils.isEmpty((CharSequence)this.mSSecurity)) {
            this.generateServiceToken();
        }
    }

    @Override
    public void setChannelPubKey(Map<Integer, String> map) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Integer n2 : map.keySet()) {
            String string2 = map.get(n2);
            String string3 = this.buildChannelPubKey(String.valueOf(n2), string2);
            hashSet.add(string3);
            MiLinkLog.v(this.getTag(), "setChannelPubKey keyId:" + n2 + " ,pubKey:" + string2.toString());
        }
        ConfigManager.getInstance().updateChannelPubKeySet(hashSet);
        this.generateServiceToken();
    }

    @Override
    public void DelChannelPubKey() {
        String string2 = this.buildChannelPubKey(this.mServiceToken, this.mSSecurity);
        ConfigManager.getInstance().deleteChannelPubKey(string2);
        this.generateServiceToken();
    }

    @Override
    public void setKeepAliveTime(int n2) {
        this.keepAliveTime = n2 * 1000;
    }

    @Override
    public int getKeepAliveTime() {
        MiLinkLog.v(this.getTag(), "get keepAliveTime:" + this.keepAliveTime);
        return this.keepAliveTime;
    }
}

