/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.account;

import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Base64;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.session.common.ThreadHelper;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public abstract class IAccount {
    protected static final String PREF_USER_ID = "userId";
    protected static final String PREF_SERVICE_TOKEN = "serviceToken";
    protected static final String PREF_S_SECURITY = "sSecurity";
    protected static final String PREF_B2_TOKEN = "b2Token";
    protected static final String PREF_B2_SECURITY = "b2Security";
    private static final String PREF_FAST_LOGIN_EXTRA_DATA = "fastLoginExtraData";
    private static final String PREF_PRIVACY_KEY = "privacyKey";
    protected volatile String mUserId;
    protected volatile String mServiceToken;
    protected volatile String mSSecurity;
    protected volatile String mB2Token;
    protected volatile String mB2Security;
    protected volatile String mOldB2Token;
    protected volatile String mOldB2Security;
    private byte[] mFastLoginExtra;
    protected long mMiLinkLoginTime = 0L;
    private int appId;
    public static int NO = 1;
    protected int mNo;
    protected String mPrivacyKey;

    protected abstract String getPrefFileName();

    protected abstract int getAccountType();

    public int getAppId() {
        return this.appId;
    }

    protected synchronized void loadAccount() {
        MiLinkLog.v(this.getTag(), "loadAccount");
        SharedPreferences sharedPreferences = Global.getContext().getSharedPreferences(this.getPrefFileName(), 0);
        this.mUserId = sharedPreferences.getString(PREF_USER_ID + this.appId, "");
        this.mServiceToken = sharedPreferences.getString(PREF_SERVICE_TOKEN + this.appId, "");
        this.mSSecurity = sharedPreferences.getString(PREF_S_SECURITY + this.appId, "");
        this.mB2Token = sharedPreferences.getString(PREF_B2_TOKEN + this.appId, "");
        this.mB2Security = sharedPreferences.getString(PREF_B2_SECURITY + this.appId, "");
        String string2 = sharedPreferences.getString(PREF_FAST_LOGIN_EXTRA_DATA + this.appId, "");
        this.mFastLoginExtra = (byte[])(!TextUtils.isEmpty((CharSequence)string2) ? Base64.decode((byte[])string2.getBytes(), (int)0) : null);
        this.mPrivacyKey = sharedPreferences.getString(PREF_PRIVACY_KEY + this.appId, "");
    }

    protected synchronized void saveAccount() {
        ThreadHelper.NETWORK.submit(new Runnable(){

            @Override
            public void run() {
                MiLinkLog.i(IAccount.this.getTag(), "thread-pool: saveAccount start");
                MiLinkLog.v(IAccount.this.getTag(), "saveAccount");
                SharedPreferences.Editor editor = Global.getContext().getSharedPreferences(IAccount.this.getPrefFileName(), 0).edit();
                editor.putString(IAccount.PREF_USER_ID + IAccount.this.appId, IAccount.this.mUserId == null ? "" : IAccount.this.mUserId);
                editor.putString(IAccount.PREF_SERVICE_TOKEN + IAccount.this.appId, IAccount.this.mServiceToken == null ? "" : IAccount.this.mServiceToken);
                editor.putString(IAccount.PREF_S_SECURITY + IAccount.this.appId, IAccount.this.mSSecurity == null ? "" : IAccount.this.mSSecurity);
                editor.putString(IAccount.PREF_B2_TOKEN + IAccount.this.appId, IAccount.this.mB2Token == null ? "" : IAccount.this.mB2Token);
                editor.putString(IAccount.PREF_B2_SECURITY + IAccount.this.appId, IAccount.this.mB2Security == null ? "" : IAccount.this.mB2Security);
                if (IAccount.this.mFastLoginExtra != null) {
                    editor.putString(IAccount.PREF_FAST_LOGIN_EXTRA_DATA + IAccount.this.appId, new String(Base64.encode((byte[])IAccount.this.mFastLoginExtra, (int)0)));
                } else {
                    editor.putString(IAccount.PREF_FAST_LOGIN_EXTRA_DATA + IAccount.this.appId, "");
                }
                editor.putString(IAccount.PREF_PRIVACY_KEY + IAccount.this.appId, IAccount.this.mPrivacyKey == null ? "" : IAccount.this.mPrivacyKey);
                editor.commit();
                MiLinkLog.i(IAccount.this.getTag(), "thread-pool: saveAccount end");
            }
        });
    }

    public void logoff() {
        MiLinkLog.v(this.getTag(), "logoff");
        this.mUserId = "";
        this.mServiceToken = "";
        this.mSSecurity = "";
        this.mB2Token = "";
        this.mB2Security = "";
        this.mOldB2Token = "";
        this.mOldB2Security = "";
        this.mMiLinkLoginTime = 0L;
        this.mFastLoginExtra = null;
        this.saveAccount();
    }

    public void logoffMiLink() {
        MiLinkLog.v(this.getTag(), "logoffMiLink");
        this.mB2Token = "";
        this.mB2Security = "";
        this.mOldB2Token = "";
        this.mOldB2Security = "";
        this.mMiLinkLoginTime = 0L;
        this.saveAccount();
    }

    protected IAccount() {
        this.appId = Global.getClientAppInfo().getAppId();
        this.mNo = NO++;
        MiLinkLog.v(this.getTag(), "IAccount()");
        this.loadAccount();
    }

    protected IAccount(int n2) {
        this.appId = n2;
        this.mNo = NO++;
        MiLinkLog.v(this.getTag(), "IAccount()");
        this.loadAccount();
    }

    public String getUserId() {
        return this.mUserId;
    }

    public void setUserId(String string2) {
        this.mUserId = string2;
    }

    public String getServiceToken() {
        return this.mServiceToken;
    }

    public void setServiceToken(String string2) {
        this.mServiceToken = string2;
    }

    public String getSSecurity() {
        return this.mSSecurity;
    }

    public void setSSecurity(String string2) {
        this.mSSecurity = string2;
    }

    public String getB2Token() {
        MiLinkLog.v(this.getTag(), "getB2Token=" + this.mB2Token);
        return this.mB2Token;
    }

    public void setB2Token(String string2) {
        MiLinkLog.v(this.getTag(), "setB2Token=".concat(String.valueOf(string2)));
        this.mB2Token = string2;
    }

    public String getB2Security() {
        MiLinkLog.v(this.getTag(), "getB2Security=" + this.mB2Security);
        return this.mB2Security;
    }

    public void setB2Security(String string2) {
        MiLinkLog.v(this.getTag(), "setB2Security=".concat(String.valueOf(string2)));
        this.mB2Security = string2;
    }

    public String getOldB2Token() {
        return this.mOldB2Token;
    }

    public void setOldB2Token(String string2) {
        this.mOldB2Token = string2;
    }

    public String getOldB2Security() {
        return this.mOldB2Security;
    }

    public void setOldB2Security(String string2) {
        this.mOldB2Security = string2;
    }

    public byte[] getFastLoginExtra() {
        return this.mFastLoginExtra;
    }

    public void setFastLoginExtra(byte[] byArray) {
        this.mFastLoginExtra = byArray;
    }

    public long getMiLinkLoginTime() {
        return this.mMiLinkLoginTime;
    }

    public void setMiLinkLoginTime(long l2) {
        this.mMiLinkLoginTime = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loginMiLink(byte[] object, byte[] object2) {
        if (object != null && ((byte[])object).length > 0 && object2 != null && ((byte[])object2).length > 0) {
            Object object3 = String.format("loginMiLink,b2Token.length=%d,b2Security.length=%d", ((byte[])object).length, ((byte[])object2).length);
            MiLinkLog.v(this.getTag(), (String)object3);
            this.mOldB2Security = this.mB2Security;
            this.mOldB2Token = this.mB2Token;
            try {
                object3 = this;
                synchronized (object3) {
                    object = new String((byte[])object, "UTF-8");
                    object2 = new String((byte[])object2, "UTF-8");
                    this.mB2Token = object;
                    this.mB2Security = object2;
                    MiLinkLog.v(this.getTag(), "mB2Token:" + this.mB2Token);
                    MiLinkLog.v(this.getTag(), "mB2Security:" + this.mB2Security);
                }
                this.mMiLinkLoginTime = System.currentTimeMillis();
                this.saveAccount();
                return;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                MiLinkLog.v(this.getTag(), "UnsupportedEncodingException:", unsupportedEncodingException);
                return;
            }
        }
        MiLinkLog.e(this.getTag(), "loginMiLink,but some argu is wrong!");
    }

    protected abstract String getTag();

    public void dataChange() {
        this.saveAccount();
    }

    public abstract String getPrivacyKey();

    public abstract void generateServiceTokenAndSSecurity();

    public void setKeepAliveTime(int n2) {
    }

    public int getKeepAliveTime() {
        return 0;
    }

    public void setChannelPubKey(Map<Integer, String> map) {
    }

    public void DelChannelPubKey() {
    }
}

