/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.account.manager;

import android.text.TextUtils;
import com.mi.milink.sdk.account.AnonymousAccount;
import com.mi.milink.sdk.account.IAccount;
import com.mi.milink.sdk.account.MiAccount;
import com.mi.milink.sdk.base.os.timer.AlarmClockService;
import com.mi.milink.sdk.config.HeartBeatManager;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.event.MiLinkEvent;
import org.greenrobot.eventbus.EventBus;

public class MiAccountManager {
    private static final String TAG = MiAccountManager.class.getSimpleName();
    public static final int ACCOUNT_TYPE_STANDARD = 0;
    public static final int ACCOUNT_TYPE_ANONYMOUS = 1;
    public static final int ACCOUNT_TYPE_CHANNEL = 2;
    private int mCurrentAccountType = 0;
    private boolean mAllowAnonymousMode = false;
    private boolean mIsLogining = false;
    private IAccount mCurrentAccount = MiAccount.getInstance();
    private static MiAccountManager INSTANCE;
    private volatile String mMiPush_RegId = null;
    private boolean mIsUploadRegIdToServer = false;
    private boolean mPassportInit = false;

    private MiAccountManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MiAccountManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<MiAccountManager> clazz = MiAccountManager.class;
        synchronized (MiAccountManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new MiAccountManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void setAnonymousModeSwitch(boolean bl2) {
        this.mAllowAnonymousMode = bl2;
    }

    public boolean isAllowAnonymousMode() {
        return this.mAllowAnonymousMode;
    }

    public String getUserId() {
        return this.mCurrentAccount.getUserId();
    }

    public void logoff() {
        this.mIsLogining = false;
        this.mCurrentAccount.logoff();
        HeartBeatManager.getInstance().saveConfig();
        if (this.mAllowAnonymousMode) {
            int n2 = this.mCurrentAccountType;
            this.switchAccountTypeMode(1);
            if (n2 == 0) {
                EventBus.getDefault().post(new MiLinkEvent.ClientActionEvent(MiLinkEvent.ClientActionEvent.EventType.ClientRequestLogin));
            }
        }
    }

    public void userLogoff() {
        AlarmClockService.stop();
        EventBus.getDefault().post(new MiLinkEvent.ClientActionEvent(MiLinkEvent.ClientActionEvent.EventType.ClientRequestLogoff));
    }

    private void switchAccountTypeMode(int n2) {
        MiLinkLog.d(TAG, "switchAccountTypeMode turn to ".concat(String.valueOf(n2)));
        switch (n2) {
            case 0: {
                this.mCurrentAccountType = 0;
                this.mCurrentAccount = MiAccount.getInstance();
                return;
            }
            case 1: {
                this.mCurrentAccountType = 1;
                this.mCurrentAccount = AnonymousAccount.getInstance();
                return;
            }
            case 2: {
                this.mCurrentAccountType = 2;
                this.mCurrentAccount = AnonymousAccount.getInstance();
            }
        }
    }

    public void logoffMiLink() {
        this.mIsLogining = false;
        this.mCurrentAccount.logoffMiLink();
    }

    public boolean appHasLogined() {
        return !TextUtils.isEmpty((CharSequence)this.mCurrentAccount.getServiceToken());
    }

    public boolean milinkHasLogined() {
        return !TextUtils.isEmpty((CharSequence)this.mCurrentAccount.getB2Token());
    }

    public synchronized boolean isLogining() {
        return this.mIsLogining;
    }

    public synchronized void setIsLogining(boolean bl2) {
        this.mIsLogining = bl2;
    }

    public void setUserId(String string2) {
        MiLinkLog.e(TAG, "MiAccountManager \u8bbe\u7f6eUID:".concat(String.valueOf(string2)));
        this.mCurrentAccount.setUserId(string2);
    }

    public boolean hasUploadRegIdToServer() {
        return this.mIsUploadRegIdToServer;
    }

    public void setHasUploadRegIdToServer(boolean bl2) {
        this.mIsUploadRegIdToServer = bl2;
    }

    public synchronized void setMipushRegId(String string2) {
        MiLinkLog.v(TAG, "setMiPushRegId:".concat(String.valueOf(string2)));
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(this.mMiPush_RegId)) {
            this.mMiPush_RegId = string2;
            this.mIsUploadRegIdToServer = false;
        }
    }

    public String getMiPushRegId() {
        return this.mMiPush_RegId;
    }

    public synchronized void login(String string2, String string3, String string4, byte[] byArray, boolean bl2) {
        String string5 = String.format("login start,st=%s,sSecurity=%s,fastLoginExtra.length=%d", string3, string4, byArray != null ? byArray.length : -1);
        MiLinkLog.w(TAG, string5 + " passportInit:" + bl2);
        this.switchAccountTypeMode(0);
        if (TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string3) || TextUtils.isEmpty((CharSequence)string4)) {
            MiLinkLog.v(TAG, "login but argu is wrong,cancel!!!");
            return;
        }
        string5 = this.mCurrentAccount.getUserId();
        if (!TextUtils.isEmpty((CharSequence)string5) && !string5.equals(string2)) {
            EventBus.getDefault().post(new MiLinkEvent.ClientActionEvent(MiLinkEvent.ClientActionEvent.EventType.ClientNotSameUserLogin));
        }
        String string6 = this.mCurrentAccount.getServiceToken();
        String string7 = this.mCurrentAccount.getSSecurity();
        String string8 = this.mCurrentAccount.getB2Token();
        MiLinkLog.d(TAG, "b2Token=".concat(String.valueOf(string8)));
        if (!TextUtils.isEmpty((CharSequence)string5) && string5.equals(string2) && string6.equals(string3) && string7.equals(string4) && !TextUtils.isEmpty((CharSequence)string8)) {
            MiLinkLog.d(TAG, "login but mB2Token is not empty");
            this.mCurrentAccount.setFastLoginExtra(byArray);
            this.mCurrentAccount.dataChange();
            EventBus.getDefault().post(new MiLinkEvent.ClientActionEvent(MiLinkEvent.ClientActionEvent.EventType.ClientRequestCheckConnection));
            return;
        }
        this.mCurrentAccount.setUserId(string2);
        this.mCurrentAccount.setServiceToken(string3);
        this.mCurrentAccount.setSSecurity(string4);
        this.mCurrentAccount.setFastLoginExtra(byArray);
        if (!this.mPassportInit) {
            this.mPassportInit = bl2;
        }
        this.mCurrentAccount.dataChange();
        EventBus.getDefault().post(new MiLinkEvent.ClientActionEvent(MiLinkEvent.ClientActionEvent.EventType.ClientRequestLogin));
    }

    public void initUserChannelMode() {
        MiLinkLog.v(TAG, "initUseChannelMode");
        this.mAllowAnonymousMode = false;
        this.switchAccountTypeMode(2);
        this.mCurrentAccount.generateServiceTokenAndSSecurity();
        String string2 = this.mCurrentAccount.getUserId();
        String string3 = this.mCurrentAccount.getB2Token();
        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3)) {
            EventBus.getDefault().post(new MiLinkEvent.ClientActionEvent(MiLinkEvent.ClientActionEvent.EventType.ClientRequestCheckConnection));
            return;
        }
        EventBus.getDefault().post(new MiLinkEvent.ClientActionEvent(MiLinkEvent.ClientActionEvent.EventType.ClientRequestLogin));
    }

    public void initUseAnonymousMode() {
        MiLinkLog.v(TAG, "initUseAnonymousMode");
        this.mAllowAnonymousMode = true;
        this.switchAccountTypeMode(1);
        this.mCurrentAccount.generateServiceTokenAndSSecurity();
        String string2 = this.mCurrentAccount.getUserId();
        String string3 = this.mCurrentAccount.getB2Token();
        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3)) {
            EventBus.getDefault().post(new MiLinkEvent.ClientActionEvent(MiLinkEvent.ClientActionEvent.EventType.ClientRequestCheckConnection));
            return;
        }
        EventBus.getDefault().post(new MiLinkEvent.ClientActionEvent(MiLinkEvent.ClientActionEvent.EventType.ClientRequestLogin));
    }

    public byte getBusinessEncByMode() {
        switch (this.mCurrentAccountType) {
            case 1: {
                return 8;
            }
            case 0: {
                return 2;
            }
            case 2: {
                return 10;
            }
        }
        return 0;
    }

    public void setPassportInit(boolean bl2) {
        MiLinkLog.w(TAG, "setPassportInit b=".concat(String.valueOf(bl2)));
        this.mPassportInit = bl2;
    }

    public boolean getPassportInit() {
        MiLinkLog.w(TAG, "getPassportInit mPassportInit=" + this.mPassportInit);
        return this.mPassportInit;
    }

    public boolean isAnonymousModeCurrent() {
        return this.mCurrentAccountType == 1;
    }

    public boolean isChannelModCurrent() {
        return this.mCurrentAccountType == 2;
    }

    public int getCurrentAccountType() {
        return this.mCurrentAccountType;
    }

    public IAccount getCurrentAccount() {
        return this.mCurrentAccount;
    }
}

