/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.account.manager;

import android.text.TextUtils;
import com.mi.milink.sdk.account.ChannelAccount;
import com.mi.milink.sdk.account.IAccount;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.event.MiLinkEventForSimpleChannel;
import org.greenrobot.eventbus.EventBus;

public class MiChannelAccountManager {
    public static boolean hasInit = false;
    private String TAG = MiChannelAccountManager.class.getSimpleName();
    private boolean mIsLogining = false;
    private IAccount mCurrentAccount;
    private int mCurrentAccountType = 2;
    private EventBus channelEventBus;
    private int appId;

    public MiChannelAccountManager(EventBus eventBus, int n2) {
        MiLinkLog.v(this.TAG, "new MiChannelAccountManager()");
        this.channelEventBus = eventBus;
        this.mCurrentAccount = new ChannelAccount(n2);
        hasInit = true;
    }

    public String getUserId() {
        return this.mCurrentAccount.getUserId();
    }

    public void logoff() {
        this.mIsLogining = false;
        this.mCurrentAccount.logoffMiLink();
    }

    public void userLogoff() {
        this.channelEventBus.post(new MiLinkEventForSimpleChannel.ClientActionEvent(MiLinkEventForSimpleChannel.ClientActionEvent.EventType.ClientRequestLogoff));
    }

    public boolean milinkHasLogined() {
        return !TextUtils.isEmpty((CharSequence)this.mCurrentAccount.getB2Token());
    }

    public synchronized boolean isLogining() {
        return this.mIsLogining;
    }

    public synchronized void setIsLogining(boolean bl2) {
        this.mIsLogining = bl2;
    }

    public void setUserId(String string2) {
        this.mCurrentAccount.setUserId(string2);
    }

    public void initUserChannelMode() {
        MiLinkLog.v(this.TAG, "initUseChannelMode");
        this.mCurrentAccount.generateServiceTokenAndSSecurity();
        String string2 = this.mCurrentAccount.getUserId();
        String string3 = this.mCurrentAccount.getB2Token();
        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3)) {
            this.channelEventBus.post(new MiLinkEventForSimpleChannel.ClientActionEvent(MiLinkEventForSimpleChannel.ClientActionEvent.EventType.ClientRequestCheckConnection));
            return;
        }
        this.channelEventBus.post(new MiLinkEventForSimpleChannel.ClientActionEvent(MiLinkEventForSimpleChannel.ClientActionEvent.EventType.ClientRequestLogin));
    }

    public byte getBusinessEncByMode() {
        switch (this.mCurrentAccountType) {
            case 2: {
                return 10;
            }
        }
        return 0;
    }

    public void logoffMiLink() {
        this.mIsLogining = false;
        this.mCurrentAccount.logoffMiLink();
    }

    public boolean isChannelModCurrent() {
        return this.mCurrentAccountType == 2;
    }

    public int getCurrentAccountType() {
        return this.mCurrentAccountType;
    }

    public IAccount getCurrentAccount() {
        return this.mCurrentAccount;
    }

    public void setKeepAliveTime(int n2) {
        this.mCurrentAccount.setKeepAliveTime(n2);
    }

    public int getKeepAliveTime() {
        return this.mCurrentAccount.getKeepAliveTime();
    }
}

