/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.aidl;

import android.os.Parcel;
import android.os.Parcelable;
import com.mi.milink.sdk.util.DataUtils;

public class PacketData
implements Parcelable {
    private int mSeqNo;
    private int mResponseSize;
    protected byte[] mData;
    protected String mCommand;
    protected int mMnsCode;
    protected int mBusiCode;
    protected String mMnsErrorMsg;
    protected boolean mIsPushPacket = false;
    protected boolean mNeedResponse = true;
    protected boolean mNeedCached = true;
    protected int mValidTime = 60000;
    protected boolean mNeedClientInfo = true;
    protected boolean mHasClientInfo = false;
    protected boolean mNeedRetry = true;
    public static final Parcelable.Creator<PacketData> CREATOR = new Parcelable.Creator<PacketData>(){

        public final PacketData createFromParcel(Parcel parcel) {
            return new PacketData(parcel);
        }

        public final PacketData[] newArray(int n2) {
            return new PacketData[n2];
        }
    };

    public boolean needRetry() {
        return this.mNeedRetry;
    }

    public void setNeedNeedRetry(boolean bl2) {
        this.mNeedRetry = bl2;
    }

    public boolean needCached() {
        return this.mNeedCached;
    }

    public void setNeedCached(boolean bl2) {
        this.mNeedCached = bl2;
    }

    public void setValidTime(int n2) {
        this.mValidTime = n2;
    }

    public int getValidTime() {
        return this.mValidTime;
    }

    public boolean needResponse() {
        return this.mNeedResponse;
    }

    public void setNeedResponse(boolean bl2) {
        this.mNeedResponse = bl2;
    }

    public boolean needClientInfo() {
        return this.mNeedClientInfo;
    }

    public void setNeedClientInfo(boolean bl2) {
        this.mNeedClientInfo = bl2;
    }

    public boolean hasClientInfo() {
        return this.mHasClientInfo;
    }

    public void setHasClientInfo(boolean bl2) {
        this.mHasClientInfo = bl2;
    }

    public boolean isPushPacket() {
        return this.mIsPushPacket;
    }

    public void setIsPushPacket(boolean bl2) {
        this.mIsPushPacket = bl2;
    }

    public String getMnsErrorMsg() {
        return this.mMnsErrorMsg;
    }

    public void setMnsErrorMsg(String string2) {
        this.mMnsErrorMsg = string2;
    }

    public byte[] getData() {
        return this.mData;
    }

    public void setData(byte[] byArray) {
        this.mData = byArray;
    }

    public String getCommand() {
        return this.mCommand;
    }

    public void setCommand(String string2) {
        this.mCommand = string2;
    }

    public int getMnsCode() {
        return this.mMnsCode;
    }

    public void setMnsCode(int n2) {
        this.mMnsCode = n2;
    }

    public int getBusiCode() {
        return this.mBusiCode;
    }

    public void setBusiCode(int n2) {
        this.mBusiCode = n2;
    }

    public void setResponseSize(int n2) {
        this.mResponseSize = n2;
    }

    public int getResponseSize() {
        return this.mResponseSize;
    }

    private PacketData(Parcel parcel) {
        this.readFromParcel(parcel);
    }

    public void readFromParcel(Parcel parcel) {
        this.mData = DataUtils.readParcelBytes(parcel);
        this.mSeqNo = parcel.readInt();
        this.mCommand = parcel.readString();
        this.mMnsCode = parcel.readInt();
        this.mBusiCode = parcel.readInt();
        this.mMnsErrorMsg = parcel.readString();
        this.mIsPushPacket = parcel.readByte() == 1;
        this.mNeedResponse = parcel.readByte() == 1;
        this.mNeedCached = parcel.readByte() == 1;
        this.mValidTime = parcel.readInt();
    }

    public PacketData() {
    }

    public int getSeqNo() {
        return this.mSeqNo;
    }

    public void setSeqNo(int n2) {
        this.mSeqNo = n2;
    }

    public boolean isPingPacket() {
        return "milink.ping".equals(this.mCommand);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        DataUtils.writeParcelBytes(parcel, this.mData);
        parcel.writeInt(this.mSeqNo);
        parcel.writeString(this.mCommand);
        parcel.writeInt(this.mMnsCode);
        parcel.writeInt(this.mBusiCode);
        parcel.writeString(this.mMnsErrorMsg);
        parcel.writeByte((byte)(this.mIsPushPacket ? 1 : 0));
        parcel.writeByte((byte)(this.mNeedResponse ? 1 : 0));
        parcel.writeByte((byte)(this.mNeedCached ? 1 : 0));
        parcel.writeInt(this.mValidTime);
    }
}

