/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.base;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;

public abstract class CustomHandlerThread {
    protected HandlerThread mHandlerThread;
    protected Handler mHandler;

    public CustomHandlerThread(String string2) {
        this(string2, 0);
    }

    public CustomHandlerThread(String string2, int n2) {
        this.mHandlerThread = new HandlerThread(string2, n2);
        this.mHandlerThread.start();
        CustomHandlerThread customHandlerThread = this;
        this.mHandler = new Handler(customHandlerThread.mHandlerThread.getLooper()){

            public void handleMessage(Message message) {
                try {
                    CustomHandlerThread.this.processMessage(message);
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            }
        };
    }

    public synchronized Message obtainMessage() {
        return this.mHandler.obtainMessage();
    }

    public synchronized void sendMessage(Message message) {
        this.mHandler.sendMessage(message);
    }

    public synchronized void sendMessageDelayed(Message message, long l2) {
        this.mHandler.sendMessageDelayed(message, l2);
    }

    public synchronized void removeMessage(int n2) {
        this.mHandler.removeMessages(n2);
    }

    public synchronized void removeMessage(int n2, Object object) {
        this.mHandler.removeMessages(n2, object);
    }

    public final synchronized boolean post(Runnable runnable) {
        return this.mHandler.post(runnable);
    }

    public final synchronized boolean postDelayed(Runnable runnable, long l2) {
        return this.mHandler.postDelayed(runnable, l2);
    }

    protected abstract void processMessage(Message var1);

    public void destroy() {
        this.mHandlerThread.quit();
    }

    public Looper getLooper() {
        return this.mHandlerThread.getLooper();
    }

    public void setHandler(Handler handler) {
        if (handler != null) {
            if (handler.getLooper() != this.getLooper()) {
                throw new IllegalArgumentException("Looper\u5bf9\u8c61\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4f7f\u7528CustomHandlerThread.getLooper()\u6784\u9020Handler\u5bf9\u8c61");
            }
            this.mHandler = handler;
        }
    }

    public synchronized Handler getHandler() {
        return this.mHandler;
    }

    public HandlerThread getHandlerThread() {
        return this.mHandlerThread;
    }
}

