/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.base;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.os.SystemClock;
import android.util.Log;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.mi.milink.sdk.base.BaseLibException;
import com.mi.milink.sdk.data.ClientAppInfo;
import com.mi.milink.sdk.data.Option;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.session.common.ThreadHelper;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class Global {
    private static final String TAG = "MiLinkServiceBinder";
    private static final byte PROTOCOL_VERSION = 3;
    private static final int VERSION = 344;
    private static final int SUB_VERSION = 14;
    private static boolean isInit = false;
    private static Context context;
    private static boolean isDebug;
    private static ClientAppInfo clientAppInfo;
    private static String clientIp;
    private static String clientIsp;
    private static int pid;
    private static HashMap<Integer, ClientAppInfo> clinetInfoMap;
    public static long STARTUP_TIME;
    public static long LAST_PACKET_SEND_TIME;
    public static String gaid;
    private static AtomicInteger uniqueSeqNO;

    public static final long startupTimespan() {
        return SystemClock.elapsedRealtime() - STARTUP_TIME;
    }

    public static final void init(Context context, ClientAppInfo clientAppInfo) {
        isInit = true;
        pid = Process.myPid();
        Global.setContext(context);
        Global.setClientAppInfo(clientAppInfo);
        if (clientAppInfo.getReleaseChannel().equals("oversea")) {
            new AsyncTask<Void, Void, String>(){

                protected final String doInBackground(Void ... object) {
                    object = null;
                    try {
                        object = AdvertisingIdClient.getAdvertisingIdInfo(Global.getApplicationContext());
                    }
                    catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                        googlePlayServicesNotAvailableException.printStackTrace();
                    }
                    catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
                        googlePlayServicesRepairableException.printStackTrace();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    String string2 = null;
                    try {
                        string2 = ((AdvertisingIdClient.Info)object).getId();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    return string2;
                }

                protected final void onPostExecute(String string2) {
                    gaid = string2;
                }
            }.execute((Object[])new Void[0]);
        }
    }

    public static final void init(Context context) {
        isInit = true;
        pid = Process.myPid();
        Global.setContext(context);
    }

    public static Handler getMainHandler() {
        return new Handler(Global.getMainLooper());
    }

    public static int getPid() {
        return pid;
    }

    public static void setClientIp(String string2) {
        clientIp = string2;
    }

    public static String getClientIp() {
        return clientIp;
    }

    public static void setClientIsp(String string2) {
        clientIsp = string2;
    }

    public static String getClientIsp() {
        if (clientIsp != null) {
            return clientIsp;
        }
        return "";
    }

    public static boolean isInit() {
        return isInit;
    }

    public static final Context getContext() {
        if (context == null) {
            throw new BaseLibException("Global's Context is NULL, have your Application in manifest subclasses BaseApplication or Call 'Global.init(this)' in your own Application ? ");
        }
        return context;
    }

    public static final void setContext(Context context) {
        Global.context = context;
        try {
            isDebug = (context.getApplicationInfo().flags & 2) != 0;
            if (isDebug) {
                Log.w((String)"Mns.Global.Runtime", (String)"DEBUG is ON");
            }
            return;
        }
        catch (Exception exception) {
            isDebug = false;
            return;
        }
    }

    public static boolean isSuicideEnable() {
        return Global.getClientAppInfo().getAppId() == 10014 || Global.getClientAppInfo().getAppId() == 20002 || Global.getClientAppInfo().getAppId() == 20005;
    }

    public static final ClientAppInfo getClientAppInfo(int n2) {
        ClientAppInfo clientAppInfo = clinetInfoMap.get(n2);
        if (clientAppInfo == null) {
            throw new BaseLibException("Global's clientAppInfo is NULL, have your Application in manifest subclasses BaseApplication or Call 'Global.init(this)' in your own Application ".concat(String.valueOf(n2)));
        }
        return clientAppInfo;
    }

    public static final ClientAppInfo getClientAppInfo() {
        if (clientAppInfo == null) {
            Global.recoveryClient();
            if (clientAppInfo == null) {
                throw new BaseLibException("Global's clientAppInfo is NULL, have your Application in manifest subclasses BaseApplication or Call 'Global.init(this)' in your own Application ? ");
            }
        }
        return clientAppInfo;
    }

    public static final void setClientAppInfo(ClientAppInfo clientAppInfo) {
        Global.clientAppInfo = clientAppInfo;
        clinetInfoMap.put(clientAppInfo.getAppId(), clientAppInfo);
        Global.protectClient();
    }

    public static final void addClientAppInfo(ClientAppInfo clientAppInfo) {
        if (Global.clientAppInfo == null) {
            Global.clientAppInfo = clientAppInfo;
        }
        clinetInfoMap.put(clientAppInfo.getAppId(), clientAppInfo);
    }

    private static final void protectClient() {
        ThreadHelper.NETWORK.submit(new Runnable(){

            @Override
            public final void run() {
                MiLinkLog.i(Global.TAG, "thread-pool: protectClient start");
                Option.putString("protect.client", Global.getClientAppInfo().toString()).apply();
                MiLinkLog.i(Global.TAG, "thread-pool: protectClient end");
            }
        });
    }

    private static final void recoveryClient() {
        String string2 = Option.getString("protect.client", null);
        if (string2 == null || string2.length() <= 0) {
            return;
        }
        try {
            Global.setClientAppInfo(new ClientAppInfo(string2));
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static final void cancelProtection() {
        Option.remove("protect.client");
        MiLinkLog.e(TAG, "Client Protection Cleared : " + Global.getClientAppInfo());
    }

    public static final boolean isMainProcess() {
        String string2 = Global.currentProcessName();
        return string2 != null && string2.indexOf(58) <= 0;
    }

    public static final boolean isDebug() {
        return isDebug;
    }

    public static final String currentProcessName() {
        Object object = (ActivityManager)Global.getSystemService("activity");
        if (object == null) {
            return null;
        }
        if ((object = object.getRunningAppProcesses()) == null) {
            return null;
        }
        int n2 = Process.myPid();
        object = object.iterator();
        while (object.hasNext()) {
            ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object.next();
            if (n2 != runningAppProcessInfo.pid) continue;
            return runningAppProcessInfo.processName;
        }
        return null;
    }

    public static final AssetManager getAssets() {
        return Global.getContext().getAssets();
    }

    public static final PackageManager getPackageManager() {
        return Global.getContext().getPackageManager();
    }

    public static final Looper getMainLooper() {
        return Global.getContext().getMainLooper();
    }

    public static final Context getApplicationContext() {
        return Global.getContext().getApplicationContext();
    }

    public static final String getPackageName() {
        return Global.getContext().getPackageName();
    }

    public static final ApplicationInfo getApplicationInfo() {
        return Global.getContext().getApplicationInfo();
    }

    public static final SharedPreferences getSharedPreferences(String string2, int n2) {
        return Global.getContext().getSharedPreferences(string2, n2);
    }

    public static final File getFilesDir() {
        return Global.getContext().getFilesDir();
    }

    public static final File getCacheDir() {
        return Global.getContext().getCacheDir();
    }

    public static final void sendBroadcast(Intent intent) {
        Global.getContext().sendBroadcast(intent);
    }

    public static final void sendBroadcast(Intent intent, String string2) {
        Global.getContext().sendBroadcast(intent, string2);
    }

    public static final void sendOrderedBroadcast(Intent intent, String string2) {
        Global.getContext().sendOrderedBroadcast(intent, string2);
    }

    public static final void sendOrderedBroadcast(Intent intent, String string2, BroadcastReceiver broadcastReceiver, Handler handler, int n2, String string3, Bundle bundle) {
        Global.getContext().sendOrderedBroadcast(intent, string2, broadcastReceiver, handler, n2, string3, bundle);
    }

    public static final void sendStickyBroadcast(Intent intent) {
        Global.getContext().sendStickyBroadcast(intent);
    }

    public static final void sendStickyOrderedBroadcast(Intent intent, BroadcastReceiver broadcastReceiver, Handler handler, int n2, String string2, Bundle bundle) {
        Global.getContext().sendStickyOrderedBroadcast(intent, broadcastReceiver, handler, n2, string2, bundle);
    }

    public static final void removeStickyBroadcast(Intent intent) {
        Global.getContext().removeStickyBroadcast(intent);
    }

    public static final Intent registerReceiver(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter) {
        return Global.getContext().registerReceiver(broadcastReceiver, intentFilter);
    }

    public static final Intent registerReceiver(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter, String string2, Handler handler) {
        return Global.getContext().registerReceiver(broadcastReceiver, intentFilter, string2, handler);
    }

    public static final void unregisterReceiver(BroadcastReceiver broadcastReceiver) {
        try {
            Global.getContext().unregisterReceiver(broadcastReceiver);
            return;
        }
        catch (Exception exception) {
            MiLinkLog.d(TAG, "global unregisterReceiver error: " + exception.getMessage());
            return;
        }
    }

    public static final Object getSystemService(String string2) {
        try {
            return Global.getContext().getSystemService(string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final int getSequence() {
        return uniqueSeqNO.getAndIncrement();
    }

    public static final int getMiLinkVersion() {
        return 344;
    }

    public static final int getMiLinkSubVersion() {
        return 14;
    }

    public static final byte getMiLinkProtocolVersion() {
        return 3;
    }

    public static final int getMaxLog() {
        return clientAppInfo.getMaxLog();
    }

    static {
        isDebug = false;
        clientAppInfo = null;
        clinetInfoMap = new HashMap();
        STARTUP_TIME = SystemClock.elapsedRealtime();
        LAST_PACKET_SEND_TIME = System.currentTimeMillis();
        gaid = "";
        uniqueSeqNO = new AtomicInteger(1);
    }
}

