/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.base;

import android.os.Looper;
import com.mi.milink.sdk.aidl.PacketData;
import com.mi.milink.sdk.base.Global;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class MessageTask
extends FutureTask<PacketData> {
    public MessageTask() {
        super(new Callable<PacketData>(){

            @Override
            public PacketData call() throws Exception {
                throw new IllegalStateException("this should never be called");
            }
        });
    }

    public final MessageTask start() {
        this.doSendWork();
        return this;
    }

    public abstract void doSendWork();

    private void ensureNotOnMainThread() {
        Object object = Looper.myLooper();
        if (object != null && object == Global.getMainLooper()) {
            object = new IllegalStateException("calling this from your main thread can lead to deadlock");
            if (Global.getApplicationInfo().targetSdkVersion >= 8) {
                throw object;
            }
        }
    }

    private PacketData getTaskResult(Long object, TimeUnit timeUnit) throws InterruptedException, ExecutionException, CancellationException, TimeoutException {
        try {
            if (object == null) {
                object = (PacketData)this.get();
                return object;
            }
            object = (PacketData)this.get((Long)object, timeUnit);
            return object;
        }
        catch (CancellationException cancellationException) {
            throw cancellationException;
        }
        catch (TimeoutException timeoutException) {
            throw timeoutException;
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
        catch (ExecutionException executionException) {
            throw executionException;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            this.cancel(true);
        }
    }

    private PacketData internalGetResult(Long l2, TimeUnit timeUnit) throws InterruptedException, ExecutionException, CancellationException, TimeoutException {
        if (!this.isDone()) {
            this.ensureNotOnMainThread();
        }
        return this.getTaskResult(l2, timeUnit);
    }

    public PacketData getResult(long l2, TimeUnit timeUnit) throws InterruptedException, ExecutionException, CancellationException, TimeoutException {
        return this.internalGetResult(l2, timeUnit);
    }

    public PacketData getChannelResult(long l2, TimeUnit timeUnit) throws InterruptedException, ExecutionException, CancellationException, TimeoutException {
        return this.getTaskResult(l2, timeUnit);
    }
}

