/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.base.data;

import java.io.ByteArrayInputStream;
import java.io.IOException;

public class Convert {
    public static final char[] NUMBERIC_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static final long makeLong(int n2, int n3) {
        return (long)n2 << 32 | (long)n3 & 0xFFFFFFFFL;
    }

    public static final int low(long l2) {
        return (int)l2;
    }

    public static final int high(long l2) {
        return (int)(l2 >>> 32);
    }

    public static final int strToInt(String string2, int n2) {
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }

    public static final byte strToByte(String string2, byte by2) {
        try {
            return Byte.parseByte(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return by2;
        }
    }

    public static String bytesToHexStr(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray2 = byArray;
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = byArray2[i2];
            int n4 = (n3 + 256) % 256 / 16;
            n3 = (n3 + 256) % 256 % 16;
            stringBuilder.append(NUMBERIC_CHAR[n4]).append(NUMBERIC_CHAR[n3]);
        }
        return stringBuilder.toString();
    }

    public static String bytesToHexStr(byte[] byArray, int n2) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return "";
        }
        n2 = byArray.length > n2 ? n2 : byArray.length;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = byArray[i2];
            int n4 = (n3 + 256) % 256 / 16;
            n3 = (n3 + 256) % 256 % 16;
            stringBuilder.append(NUMBERIC_CHAR[n4]).append(NUMBERIC_CHAR[n3]).append(' ');
        }
        return stringBuilder.toString();
    }

    public static byte[] hexStrToBytes(String string2) {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            return new byte[0];
        }
        int n2 = string2.length();
        int n3 = (n2 + 1) / 2;
        byte[] byArray = new byte[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = string2.charAt(i2 * 2);
            int n5 = 48;
            if (i2 * 2 + 1 < n2) {
                n5 = string2.charAt(i2 * 2 + 1);
            }
            n4 = Convert.hexCharToInt((char)n4);
            n5 = Convert.hexCharToInt((char)n5);
            if (n4 < 0 || n5 < 0) {
                return null;
            }
            byArray[i2] = (byte)(n4 * 16 + n5);
        }
        return byArray;
    }

    public static int hexCharToInt(char c2) {
        if (c2 <= '9' && c2 >= '0') {
            return c2 - 48;
        }
        if (c2 <= 'F' && c2 >= 'A') {
            return c2 - 65 + 10;
        }
        if (c2 <= 'f' && c2 >= 'a') {
            return c2 - 97 + 10;
        }
        return -1;
    }

    public static String IPv4ToStr(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (i2 != 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append((byArray[i2] + 256) % 256);
        }
        return stringBuilder.toString();
    }

    public static byte[] strToIPv4(String stringArray) {
        if (stringArray == null) {
            return null;
        }
        if ((stringArray = stringArray.split("\\.")) == null) {
            return null;
        }
        byte[] byArray = new byte[stringArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = (byte)Integer.parseInt(stringArray[i2]);
        }
        return byArray;
    }

    public static String intToIPv4(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n2 & 0xFF).append(".");
        stringBuffer.append(n2 >> 8 & 0xFF).append(".");
        stringBuffer.append(n2 >> 16 & 0xFF).append(".");
        stringBuffer.append(n2 >> 24 & 0xFF);
        return stringBuffer.toString();
    }

    public static String intToIPv4_Reverse(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n2 >> 24 & 0xFF).append(".");
        stringBuffer.append(n2 >> 16 & 0xFF).append(".");
        stringBuffer.append(n2 >> 8 & 0xFF).append(".");
        stringBuffer.append(n2 & 0xFF);
        return stringBuffer.toString();
    }

    public static byte[] longToBytes(long l2) {
        byte[] byArray = new byte[8];
        byte[] byArray2 = byArray;
        byArray[7] = (byte)(l2 & 0xFFL);
        byArray2[6] = (byte)(l2 >> 8 & 0xFFL);
        byArray2[5] = (byte)(l2 >> 16 & 0xFFL);
        byArray2[4] = (byte)(l2 >> 24 & 0xFFL);
        byArray2[3] = (byte)(l2 >> 32 & 0xFFL);
        byArray2[2] = (byte)(l2 >> 40 & 0xFFL);
        byArray2[1] = (byte)(l2 >> 48 & 0xFFL);
        byArray2[0] = (byte)(l2 >> 56 & 0xFFL);
        return byArray2;
    }

    public static void longToBytes(long l2, byte[] byArray, int n2) {
        byArray[7 + n2] = (byte)(l2 & 0xFFL);
        byArray[6 + n2] = (byte)(l2 >> 8 & 0xFFL);
        byArray[5 + n2] = (byte)(l2 >> 16 & 0xFFL);
        byArray[4 + n2] = (byte)(l2 >> 24 & 0xFFL);
        byArray[3 + n2] = (byte)(l2 >> 32 & 0xFFL);
        byArray[2 + n2] = (byte)(l2 >> 40 & 0xFFL);
        byArray[1 + n2] = (byte)(l2 >> 48 & 0xFFL);
        byArray[0 + n2] = (byte)(l2 >> 56 & 0xFFL);
    }

    public static long bytesToLong(byte[] byArray) {
        return ((long)byArray[0] & 0xFFL) << 56 | ((long)byArray[1] & 0xFFL) << 48 | ((long)byArray[2] & 0xFFL) << 40 | ((long)byArray[3] & 0xFFL) << 32 | ((long)byArray[4] & 0xFFL) << 24 | ((long)byArray[5] & 0xFFL) << 16 | ((long)byArray[6] & 0xFFL) << 8 | ((long)byArray[7] & 0xFFL) << 0;
    }

    public static long bytesToLong(byte[] byArray, int n2) {
        return ((long)byArray[n2 + 0] & 0xFFL) << 56 | ((long)byArray[n2 + 1] & 0xFFL) << 48 | ((long)byArray[n2 + 2] & 0xFFL) << 40 | ((long)byArray[n2 + 3] & 0xFFL) << 32 | ((long)byArray[n2 + 4] & 0xFFL) << 24 | ((long)byArray[n2 + 5] & 0xFFL) << 16 | ((long)byArray[n2 + 6] & 0xFFL) << 8 | ((long)byArray[n2 + 7] & 0xFFL) << 0;
    }

    public static byte[] intToBytes(int n2) {
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        byArray[3] = (byte)(n2 & 0xFF);
        byArray2[2] = (byte)(n2 >> 8 & 0xFF);
        byArray2[1] = (byte)(n2 >> 16 & 0xFF);
        byArray2[0] = (byte)(n2 >> 24 & 0xFF);
        return byArray2;
    }

    public static void intToBytes(int n2, byte[] byArray, int n3) {
        byArray[3 + n3] = (byte)(n2 & 0xFF);
        byArray[2 + n3] = (byte)(n2 >> 8 & 0xFF);
        byArray[1 + n3] = (byte)(n2 >> 16 & 0xFF);
        byArray[n3] = (byte)(n2 >> 24 & 0xFF);
    }

    public static int bytesToInt(byte[] byArray) {
        return byArray[3] & 0xFF | (byArray[2] & 0xFF) << 8 | (byArray[1] & 0xFF) << 16 | (byArray[0] & 0xFF) << 24;
    }

    public static int bytesToInt(byte[] byArray, int n2) {
        return byArray[n2 + 3] & 0xFF | (byArray[n2 + 2] & 0xFF) << 8 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2] & 0xFF) << 24;
    }

    public static byte[] uintToBytes(long l2) {
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        byArray[3] = (byte)(l2 & 0xFFL);
        byArray2[2] = (byte)(l2 >> 8 & 0xFFL);
        byArray2[1] = (byte)(l2 >> 16 & 0xFFL);
        byArray2[0] = (byte)(l2 >> 24 & 0xFFL);
        return byArray2;
    }

    public static void uintToBytes(long l2, byte[] byArray, int n2) {
        byArray[3 + n2] = (byte)l2;
        byArray[2 + n2] = (byte)(l2 >> 8 & 0xFFL);
        byArray[1 + n2] = (byte)(l2 >> 16 & 0xFFL);
        byArray[n2] = (byte)(l2 >> 24 & 0xFFL);
    }

    public static long bytesToUint(byte[] byArray) {
        return (long)(byArray[3] & 0xFF) | (long)(byArray[2] & 0xFF) << 8 | (long)(byArray[1] & 0xFF) << 16 | (long)(byArray[0] & 0xFF) << 24;
    }

    public static long bytesToUint(byte[] byArray, int n2) {
        return (long)(byArray[n2 + 3] & 0xFF) | (long)(byArray[n2 + 2] & 0xFF) << 8 | (long)(byArray[n2 + 1] & 0xFF) << 16 | (long)(byArray[n2] & 0xFF) << 24;
    }

    public static byte[] shortToBytes(short s2) {
        byte[] byArray = new byte[2];
        byte[] byArray2 = byArray;
        byArray[1] = (byte)(s2 & 0xFF);
        byArray2[0] = (byte)(s2 >> 8 & 0xFF);
        return byArray2;
    }

    public static void shortToBytes(short s2, byte[] byArray, int n2) {
        byArray[n2 + 1] = (byte)(s2 & 0xFF);
        byArray[n2] = (byte)(s2 >> 8 & 0xFF);
    }

    public static short bytesToShort(byte[] byArray) {
        return (short)(byArray[1] & 0xFF | (byArray[0] & 0xFF) << 8);
    }

    public static short bytesToShort(byte[] byArray, int n2) {
        return (short)(byArray[n2 + 1] & 0xFF | (byArray[n2] & 0xFF) << 8);
    }

    public static byte[] ushortToBytes(int n2) {
        byte[] byArray = new byte[2];
        byte[] byArray2 = byArray;
        byArray[1] = (byte)(n2 & 0xFF);
        byArray2[0] = (byte)(n2 >> 8 & 0xFF);
        return byArray2;
    }

    public static void ushortToBytes(int n2, byte[] byArray, int n3) {
        byArray[n3 + 1] = (byte)(n2 & 0xFF);
        byArray[n3] = (byte)(n2 >> 8 & 0xFF);
    }

    public static int bytesToUshort(byte[] byArray) {
        return byArray[1] & 0xFF | (byArray[0] & 0xFF) << 8;
    }

    public static int bytesToUshort(byte[] byArray, int n2) {
        return byArray[n2 + 1] & 0xFF | (byArray[n2] & 0xFF) << 8;
    }

    public static byte[] ubyteToBytes(int n2) {
        byte[] byArray = new byte[1];
        byte[] byArray2 = byArray;
        byArray[0] = (byte)(n2 & 0xFF);
        return byArray2;
    }

    public static void ubyteToBytes(int n2, byte[] byArray, int n3) {
        byArray[0] = (byte)(n2 & 0xFF);
    }

    public static int bytesToUbyte(byte[] byArray) {
        return byArray[0] & 0xFF;
    }

    public static int bytesToUbyte(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF;
    }

    public static String bytesToASCIIString(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        return Convert.bytesToASCIIString(byArray, byArray.length);
    }

    public static String bytesToASCIIString(byte[] byArray, int n2) {
        if (byArray == null) {
            return "";
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append((char)((byArray[i2] + 256) % 256));
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String bytesToStr(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return new String(byArray);
    }

    public static byte[] readByte(ByteArrayInputStream byteArrayInputStream, int n2) throws IOException {
        byte[] byArray = new byte[n2];
        byteArrayInputStream.read(byArray, 0, n2);
        return byArray;
    }

    public static void readBytes(ByteArrayInputStream byteArrayInputStream, byte[] byArray, int n2, int n3) throws IOException {
        byteArrayInputStream.read(byArray, n2, n3);
    }

    public static boolean compare(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < byArray2.length; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }
}

