/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.base.debug;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.mi.milink.sdk.base.data.SafeStringQueue;
import com.mi.milink.sdk.base.debug.FileTracerConfig;
import com.mi.milink.sdk.base.debug.TraceFormat;
import com.mi.milink.sdk.base.debug.Tracer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class FileTracer
extends Tracer
implements Handler.Callback {
    private static final int MSG_FLUSH = 1024;
    private static final String TAG = FileTracer.class.getSimpleName();
    private FileTracerConfig mConfig;
    private OutputStreamWriter mFileWriter;
    private FileChannel mFc;
    private File mCurrTraceFile;
    private char[] mCharBuffer;
    private volatile SafeStringQueue mBufferA;
    private volatile SafeStringQueue mBufferB;
    private volatile SafeStringQueue mWriteBuffer;
    private volatile SafeStringQueue mReadBuffer;
    private volatile boolean mIsFlushing = false;
    private HandlerThread mHandlerThread;
    private Handler mHandler;

    public FileTracer(FileTracerConfig fileTracerConfig) {
        this(63, true, TraceFormat.DEFAULT, fileTracerConfig);
    }

    public FileTracer(int n2, boolean bl2, TraceFormat traceFormat, FileTracerConfig fileTracerConfig) {
        super(n2, bl2, traceFormat);
        try {
            this.setConfig(fileTracerConfig);
            this.mBufferA = new SafeStringQueue();
            this.mBufferB = new SafeStringQueue();
            this.mWriteBuffer = this.mBufferA;
            this.mReadBuffer = this.mBufferB;
            this.mCharBuffer = new char[fileTracerConfig.getMaxBufferSize()];
            this.obtainFileWriter();
            this.mHandlerThread = new HandlerThread(fileTracerConfig.getThreadName(), fileTracerConfig.getThreadPriority());
            if (this.mHandlerThread != null) {
                this.mHandlerThread.start();
            }
            if (this.mHandlerThread.isAlive()) {
                this.mHandler = new Handler(this.mHandlerThread.getLooper(), (Handler.Callback)this);
            }
            this.prepareNextFlush();
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    FileTracer.this.getConfig().cleanWorkFolders();
                }
            }, 15000L);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void flush() {
        if (this.mHandler.hasMessages(1024)) {
            this.mHandler.removeMessages(1024);
        }
        this.mHandler.sendEmptyMessage(1024);
    }

    public void quit() {
        this.setEnabled(false);
        this.closeFileWriter();
        this.mHandlerThread.quit();
    }

    @Override
    protected void doTrace(int n2, Thread thread, long l2, String string2, String string3, Throwable throwable) {
        String string4 = this.getTraceFormat().formatTrace(n2, thread, l2, string2, string3, throwable);
        this.doTrace(string4);
    }

    @Override
    protected void doTrace(String string2) {
        this.mWriteBuffer.addToBuffer(string2);
        if (this.mWriteBuffer.getBufferSize() >= this.getConfig().getMaxBufferSize()) {
            this.flush();
        }
    }

    public boolean handleMessage(Message message) {
        switch (message.what) {
            case 1024: {
                this.flushBuffer();
                this.prepareNextFlush();
            }
        }
        return true;
    }

    private void prepareNextFlush() {
        this.mHandler.sendEmptyMessageDelayed(1024, this.getConfig().getFlushInterval());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void flushBuffer() {
        block15: {
            block14: {
                if (Thread.currentThread() != this.mHandlerThread) {
                    return;
                }
                if (this.mIsFlushing) {
                    return;
                }
                this.mIsFlushing = true;
                FileLock fileLock = null;
                this.swapBuffers();
                try {
                    Writer writer = this.obtainFileWriter();
                    if (writer != null) {
                        fileLock = this.mFc != null ? this.mFc.lock() : null;
                        this.mReadBuffer.writeAndFlush(writer, this.mCharBuffer);
                    }
                    if (fileLock == null) break block14;
                }
                catch (Exception exception) {
                    if (fileLock != null) {
                        try {
                            fileLock.release();
                        }
                        catch (Exception exception2) {}
                    }
                    this.mReadBuffer.clear();
                    break block15;
                }
                catch (Throwable throwable) {
                    if (fileLock != null) {
                        try {
                            fileLock.release();
                        }
                        catch (Exception exception) {}
                    }
                    this.mReadBuffer.clear();
                    throw throwable;
                }
                try {
                    fileLock.release();
                }
                catch (Exception exception) {}
            }
            this.mReadBuffer.clear();
        }
        this.mIsFlushing = false;
    }

    private Writer obtainFileWriter() {
        boolean bl2 = false;
        File file = this.getConfig().getCurrFile();
        if (!(this.mCurrTraceFile == null || this.mCurrTraceFile.exists() && this.mCurrTraceFile.canWrite())) {
            bl2 = true;
        }
        if (bl2 || file != null && !file.equals(this.mCurrTraceFile)) {
            this.mCurrTraceFile = file;
            this.closeFileWriter();
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.mCurrTraceFile, true);
                this.mFc = fileOutputStream.getChannel();
                this.mFileWriter = new OutputStreamWriter(fileOutputStream);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return this.mFileWriter;
    }

    private void closeFileWriter() {
        try {
            if (this.mFileWriter != null) {
                this.mFc = null;
                this.mFileWriter.flush();
                this.mFileWriter.close();
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swapBuffers() {
        FileTracer fileTracer = this;
        synchronized (fileTracer) {
            if (this.mWriteBuffer == this.mBufferA) {
                this.mWriteBuffer = this.mBufferB;
                this.mReadBuffer = this.mBufferA;
            } else {
                this.mWriteBuffer = this.mBufferA;
                this.mReadBuffer = this.mBufferB;
            }
            return;
        }
    }

    public FileTracerConfig getConfig() {
        return this.mConfig;
    }

    public void setConfig(FileTracerConfig fileTracerConfig) {
        this.mConfig = fileTracerConfig;
    }
}

