/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.base.debug;

import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.debug.MiLinkTracer;
import com.mi.milink.sdk.util.CommonUtils;
import com.mi.milink.sdk.util.FileUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;

public class FileTracerConfig {
    public static final int NO_LIMITED = Integer.MAX_VALUE;
    public static final long FOREVER = 172800000L;
    public static final int PRIORITY_BACKGROUND = 10;
    public static final int PRIORITY_STANDARD = 0;
    public static final int DEF_BUFFER_SIZE = 8192;
    public static final String DEF_TRACE_FILEEXT = ".log";
    public static final String DEF_FOLDER_FORMAT = "yyyy-MM-dd";
    public static final String DEF_THREAD_NAME = "Tracer.File";
    public static final long DEF_FLUSH_INTERVAL = 10000L;
    private static final FileFilter DEF_TRACE_FOLDER_FILTER = new FileFilter(){

        @Override
        public final boolean accept(File file) {
            if (!file.isDirectory()) {
                return false;
            }
            return FileTracerConfig.getTimeFromFolder(file) > 0L;
        }
    };
    private String mThreadName = "Tracer.File";
    private int mMaxBlockSize = Integer.MAX_VALUE;
    private int mMaxBlockCount = Integer.MAX_VALUE;
    private int mMaxBufferSize = 8192;
    private long mFlushInterval = 10000L;
    private File mRootFolder;
    private int mThreadPriority = 10;
    private String mFileExt = ".log";
    private long mKeepPeriod = 172800000L;
    private FileFilter mLogFileFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (!file.getName().endsWith(FileTracerConfig.this.getFileExt())) {
                return false;
            }
            return FileTracerConfig.getBlockCountFromFile(file) != -1;
        }
    };
    private Comparator<? super File> mBlockComparetor = new Comparator<File>(){

        @Override
        public int compare(File file, File file2) {
            return FileTracerConfig.getBlockCountFromFile(file) - FileTracerConfig.getBlockCountFromFile(file2);
        }
    };

    public static long getTimeFromFolder(File file) {
        try {
            return CommonUtils.createDataFormat(DEF_FOLDER_FORMAT).parse(file.getName()).getTime();
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public FileTracerConfig(File file) {
        this(file, Integer.MAX_VALUE, Integer.MAX_VALUE, 8192, DEF_THREAD_NAME, 10000L, 10, DEF_TRACE_FILEEXT, 172800000L);
    }

    public FileTracerConfig(File file, int n2, int n3, int n4, String string2, long l2, int n5, String string3, long l3) {
        this.setRootFolder(file);
        this.setMaxBlockCount(n2);
        this.setMaxBlockSize(n3);
        this.setMaxBufferSize(n4);
        this.setThreadName(string2);
        this.setFlushInterval(l2);
        this.setThreadPriority(n5);
        this.setFileExt(string3);
        this.setKeepPeriod(l3);
    }

    public synchronized File getCurrFile() {
        return this.getWorkFile(System.currentTimeMillis());
    }

    private File getWorkFile(long l2) {
        FileTracerConfig fileTracerConfig = this;
        return fileTracerConfig.ensureBlockCount(fileTracerConfig.getWorkFolder(l2));
    }

    public File getWorkFolder(long l2) {
        File file = this.getWorkFolderPath(l2);
        if (!file.exists()) {
            file.mkdirs();
        }
        file.setReadable(true, false);
        file.setWritable(true, false);
        return file;
    }

    public boolean isWorkFolderExists(long l2) {
        return this.getWorkFolderPath(l2).exists();
    }

    private File getWorkFolderPath(long l2) {
        return new File(this.getRootFolder(), CommonUtils.createDataFormat(DEF_FOLDER_FORMAT).format(l2));
    }

    private File ensureBlockCount(File file) {
        int n2;
        this.checkAllFilesSize(file);
        File[] fileArray = this.getAllBlocksInFolder(file);
        if (fileArray == null || fileArray.length == 0) {
            return new File(file, "1" + this.getFileExt());
        }
        this.sortBlocksByIndex(fileArray);
        File file2 = fileArray[fileArray.length - 1];
        int n3 = fileArray.length - this.getMaxBlockCount();
        if ((int)file2.length() > this.getMaxBlockSize()) {
            n2 = FileTracerConfig.getBlockCountFromFile(file2) + 1;
            file2 = new File(file, n2 + this.getFileExt());
            ++n3;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            fileArray[n2].delete();
        }
        file2.setReadable(true, false);
        file2.setWritable(true, false);
        return file2;
    }

    public File[] getAllBlocksInFolder(File file) {
        return file.listFiles(this.mLogFileFilter);
    }

    public void cleanWorkFolders() {
        if (this.getRootFolder() == null) {
            return;
        }
        try {
            File[] fileArray = this.getRootFolder().listFiles(DEF_TRACE_FOLDER_FILTER);
            if (fileArray == null) {
                return;
            }
            for (File file : fileArray) {
                long l2 = FileTracerConfig.getTimeFromFolder(file);
                if (System.currentTimeMillis() - l2 <= this.getKeepPeriod()) continue;
                FileUtils.deleteFile(file);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            try {
                File[] fileArray = MiLinkTracer.getLogFileFolderPath().listFiles();
                if (fileArray != null) {
                    File[] fileArray2 = fileArray;
                    int n2 = fileArray.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        FileUtils.deleteFile(fileArray2[i2]);
                    }
                }
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            catch (OutOfMemoryError outOfMemoryError2) {
                outOfMemoryError2.printStackTrace();
                return;
            }
        }
    }

    public long getSizeOfBlocks(File fileArray) {
        this.ensureBlockCount((File)fileArray);
        fileArray = this.getAllBlocksInFolder((File)fileArray);
        return this.getSizeOfBlocks(fileArray);
    }

    public long getSizeOfBlocks(File[] fileArray) {
        long l2 = 0L;
        for (File file : fileArray) {
            if (!file.exists() || !file.isFile()) continue;
            l2 += file.length();
        }
        return l2;
    }

    public File[] sortBlocksByIndex(File[] fileArray) {
        Arrays.sort(fileArray, this.mBlockComparetor);
        return fileArray;
    }

    private static int getBlockCountFromFile(File object) {
        try {
            object = ((File)object).getName();
            int n2 = ((String)object).indexOf(46);
            return Integer.parseInt(((String)object).substring(0, n2));
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public String getThreadName() {
        return this.mThreadName;
    }

    public void setThreadName(String string2) {
        this.mThreadName = string2;
    }

    public int getMaxBlockSize() {
        return this.mMaxBlockSize;
    }

    public void setMaxBlockSize(int n2) {
        this.mMaxBlockSize = n2;
    }

    public int getMaxBlockCount() {
        return this.mMaxBlockCount;
    }

    public void setMaxBlockCount(int n2) {
        this.mMaxBlockCount = n2;
    }

    public int getMaxBufferSize() {
        return this.mMaxBufferSize;
    }

    public void setMaxBufferSize(int n2) {
        this.mMaxBufferSize = n2;
    }

    public long getFlushInterval() {
        return this.mFlushInterval;
    }

    public void setFlushInterval(long l2) {
        this.mFlushInterval = l2;
    }

    public File getRootFolder() {
        return this.mRootFolder;
    }

    public void setRootFolder(File file) {
        this.mRootFolder = file;
    }

    public int getThreadPriority() {
        return this.mThreadPriority;
    }

    public void setThreadPriority(int n2) {
        this.mThreadPriority = n2;
    }

    public String getFileExt() {
        return this.mFileExt;
    }

    public void setFileExt(String string2) {
        this.mFileExt = string2;
    }

    public long getKeepPeriod() {
        return this.mKeepPeriod;
    }

    public void setKeepPeriod(long l2) {
        this.mKeepPeriod = l2;
    }

    private void checkAllFilesSize(File fileArray) {
        if (FileTracerConfig.getFileSize(this.getRootFolder()) < (long)Global.getMaxLog()) {
            return;
        }
        File[] fileArray2 = this.getRootFolder().listFiles(DEF_TRACE_FOLDER_FILTER);
        if (fileArray2.length > 1) {
            fileArray2[0].delete();
            return;
        }
        if ((fileArray = this.getAllBlocksInFolder((File)fileArray)) == null || fileArray.length == 0) {
            return;
        }
        if ((fileArray = this.sortBlocksByIndex(fileArray))[0].exists()) {
            fileArray[0].delete();
        }
        if (fileArray.length == 1) {
            try {
                fileArray[0].createNewFile();
                fileArray[0].setWritable(true, false);
                fileArray[0].setReadable(true, false);
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static long getFileSize(File object) {
        if (object == null || !((File)object).exists()) {
            return 0L;
        }
        if (!((File)object).isDirectory()) {
            return ((File)object).length();
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(object);
        long l2 = 0L;
        while (!linkedList.isEmpty()) {
            File[] fileArray;
            File file = (File)linkedList.remove(0);
            if (!file.exists() || (fileArray = file.listFiles()) == null || fileArray.length == 0) continue;
            int n2 = fileArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                File file2 = fileArray[i2];
                l2 += file2.length();
                if (!file2.isDirectory()) continue;
                linkedList.add(file2);
            }
        }
        return l2;
    }
}

