/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.base.debug;

import com.mi.milink.sdk.base.debug.FileTracer;
import com.mi.milink.sdk.base.debug.FileTracerConfig;
import com.mi.milink.sdk.util.CommonUtils;
import com.mi.milink.sdk.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileTracerReader {
    private static final int DEF_BUFFER_SIZE = 8192;
    private static final String TAG = FileTracerReader.class.getSimpleName();
    private FileTracerConfig mConfig;

    public FileTracerReader(FileTracerConfig fileTracerConfig) {
        this.setConfig(fileTracerConfig);
    }

    public FileTracerReader(FileTracer fileTracer) {
        this(fileTracer.getConfig());
    }

    public File pack(long l2, File file) {
        return this.pack(l2, file, true);
    }

    public File pack(long l2, File file, boolean bl2) {
        File file2 = this.doPack(l2, file);
        if (file2 == null) {
            return null;
        }
        if (bl2) {
            File file3 = new File(file2.getAbsolutePath() + ".zip");
            if (FileUtils.zip(file2, file3)) {
                return file3;
            }
            return null;
        }
        return file2;
    }

    private File doPack(long l2, File object) {
        File file;
        block11: {
            file = this.getConfig().getWorkFolder(l2);
            File[] fileArray = this.getConfig().getAllBlocksInFolder(file);
            if ((file = new File((File)object, file.getName() + this.getConfig().getFileExt())).exists()) {
                file.delete();
            }
            if (fileArray == null) {
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {}
                return file;
            }
            this.getConfig().sortBlocksByIndex(fileArray);
            object = null;
            BufferedOutputStream bufferedOutputStream = null;
            byte[] byArray = new byte[8192];
            try {
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file, true));
                File[] fileArray2 = fileArray;
                int n2 = fileArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n3;
                    File file2 = fileArray2[i2];
                    CommonUtils.closeDataObject(object);
                    object = new BufferedInputStream(new FileInputStream(file2));
                    while (0 < (n3 = ((BufferedInputStream)object).read(byArray, 0, 8192))) {
                        bufferedOutputStream.write(byArray, 0, n3);
                    }
                }
                bufferedOutputStream.flush();
                CommonUtils.closeDataObject(bufferedOutputStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                file = null;
                break block11;
            }
            finally {
                CommonUtils.closeDataObject(bufferedOutputStream);
                CommonUtils.closeDataObject(object);
            }
            CommonUtils.closeDataObject(object);
        }
        return file;
    }

    @Deprecated
    public boolean read(long l2, byte[] byArray, int n2, int n3, int n4, ReaderCallback readerCallback) {
        if (readerCallback == null) {
            return false;
        }
        if (byArray == null) {
            byArray = new byte[8192];
        }
        n4 = 0;
        File[] fileArray = this.getConfig().getWorkFolder(l2);
        fileArray = this.getConfig().getAllBlocksInFolder((File)fileArray);
        if (fileArray == null) {
            return false;
        }
        this.getConfig().sortBlocksByIndex(fileArray);
        BufferedInputStream bufferedInputStream = null;
        try {
            for (int i2 = n2; i2 < fileArray.length; ++i2) {
                int n5;
                File file = fileArray[i2];
                if ((long)n3 > file.length()) {
                    n3 -= (int)file.length();
                    continue;
                }
                CommonUtils.closeDataObject(bufferedInputStream);
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                if (n3 > 0) {
                    bufferedInputStream.skip(n3);
                    n3 = 0;
                }
                while (0 < (n5 = bufferedInputStream.read(byArray, 0, byArray.length))) {
                    readerCallback.onTraceRead(this, byArray, n5);
                }
                n4 = 1;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            n4 = 0;
        }
        finally {
            CommonUtils.closeDataObject(bufferedInputStream);
        }
        return n4 != 0;
    }

    public FileTracerConfig getConfig() {
        return this.mConfig;
    }

    public void setConfig(FileTracerConfig fileTracerConfig) {
        this.mConfig = fileTracerConfig;
    }

    @Deprecated
    public static interface ReaderCallback {
        public void onTraceRead(FileTracerReader var1, byte[] var2, int var3);
    }
}

