/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.base.debug;

import android.text.format.Time;
import android.util.Log;
import com.mi.milink.sdk.base.Global;

public class TraceFormat {
    public static final String STR_VERBOSE = "V";
    public static final String STR_DEBUG = "D";
    public static final String STR_INFO = "I";
    public static final String STR_WARN = "W";
    public static final String STR_ERROR = "E";
    public static final String STR_ASSERT = "A";
    public static final String STR_UNKNOWN = "-";
    public static final String TRACE_TIME_FORMAT = "%Y-%m-%d %H:%M:%S";
    public static final TraceFormat DEFAULT = new TraceFormat();

    public static final String getLevelPrefix(int n2) {
        switch (n2) {
            case 2: {
                return STR_DEBUG;
            }
            case 4: {
                return STR_INFO;
            }
            case 8: {
                return STR_WARN;
            }
            case 16: {
                return STR_ERROR;
            }
            case 1: {
                return STR_VERBOSE;
            }
            case 32: {
                return STR_ASSERT;
            }
        }
        return STR_UNKNOWN;
    }

    public String formatTrace(int n2, Thread thread, long l2, String string2, String string3, Throwable throwable) {
        try {
            long l3 = l2 % 1000L;
            Time time = new Time();
            time.set(l2);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(TraceFormat.getLevelPrefix(n2)).append('/').append(time.format(TRACE_TIME_FORMAT)).append('.');
            if (l3 < 10L) {
                stringBuilder.append("00");
            } else if (l3 < 100L) {
                stringBuilder.append('0');
            }
            stringBuilder.append(l3).append(' ').append('[').append(Global.getPid()).append(']').append('[');
            if (thread == null) {
                stringBuilder.append("N/A");
            } else {
                stringBuilder.append(thread.getName());
            }
            stringBuilder.append(']').append('[').append(string2).append(']').append(' ').append(string3).append('\n');
            if (throwable != null) {
                stringBuilder.append("*** Exception : \n").append(Log.getStackTraceString((Throwable)throwable)).append('\n');
            }
            return stringBuilder.toString();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return "";
        }
    }
}

