/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.base.debug;

import com.mi.milink.sdk.base.debug.Bit;
import com.mi.milink.sdk.base.debug.TraceFormat;

public abstract class Tracer {
    private volatile int mTraceLevel = 63;
    private volatile boolean mEnabled = true;
    private TraceFormat mTraceFormat = TraceFormat.DEFAULT;

    public Tracer() {
        this(63, true, TraceFormat.DEFAULT);
    }

    public Tracer(int n2, boolean bl2, TraceFormat traceFormat) {
        this.setTraceLevel(n2);
        this.setEnabled(bl2);
        this.setTraceFormat(traceFormat);
    }

    public void trace(int n2, Thread thread, long l2, String string2, String string3, Throwable throwable) {
        if (this.isEnabled() && Bit.has(this.mTraceLevel, n2)) {
            try {
                this.doTrace(n2, thread, l2, string2, string3, throwable);
                return;
            }
            catch (OutOfMemoryError outOfMemoryError) {}
        }
    }

    public void trace(int n2, String string2) {
        if (this.isEnabled() && Bit.has(this.mTraceLevel, n2)) {
            this.doTrace(string2);
        }
    }

    protected abstract void doTrace(int var1, Thread var2, long var3, String var5, String var6, Throwable var7);

    protected abstract void doTrace(String var1);

    public int getTraceLevel() {
        return this.mTraceLevel;
    }

    public void setTraceLevel(int n2) {
        this.mTraceLevel = n2;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void setEnabled(boolean bl2) {
        this.mEnabled = bl2;
    }

    public TraceFormat getTraceFormat() {
        return this.mTraceFormat;
    }

    public void setTraceFormat(TraceFormat traceFormat) {
        this.mTraceFormat = traceFormat;
    }
}

