/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.base.os;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class Console
extends Thread {
    private static final long CONSOLE_STREAM_READER_TIMEOUT = 1000L;

    public static String execute(String string2, long l2) {
        return Console.execute(string2, l2, 1000L);
    }

    public static String execute(String object, long l2, long l3) {
        object = new ConsoleThread((String)object, l3);
        ((Thread)object).start();
        try {
            ((Thread)object).join(l2);
        }
        catch (InterruptedException interruptedException) {}
        if (((Thread)object).isAlive()) {
            ((Thread)object).interrupt();
        }
        return ((ConsoleThread)object).getOutputData();
    }

    public static class ConsoleThread
    extends Thread {
        private Integer exitCode = 0;
        private String outputData = null;
        private String command = null;
        private long timeout = 1000L;

        public ConsoleThread(String string2, long l2) {
            this.setCommand(string2);
            this.setTimeout(l2);
        }

        @Override
        public void run() {
            try {
                Process process = Runtime.getRuntime().exec(this.getCommand());
                int n2 = process.waitFor();
                Object object = new ConsoleReader(process.getInputStream());
                ((Thread)object).start();
                try {
                    ((Thread)object).join(1000L);
                }
                catch (InterruptedException interruptedException) {}
                if (((Thread)object).isAlive()) {
                    ((Thread)object).interrupt();
                }
                object = ((ConsoleReader)object).getOutputData();
                this.setExitCode(n2);
                this.setOutputData((String)object);
                process.destroy();
                return;
            }
            catch (IOException iOException) {
                this.setExitCode(Integer.MAX_VALUE);
                return;
            }
            catch (InterruptedException interruptedException) {
                this.setExitCode(Integer.MIN_VALUE);
                return;
            }
        }

        public String getCommand() {
            return this.command;
        }

        public void setCommand(String string2) {
            this.command = string2;
        }

        public Integer getExitCode() {
            return this.exitCode;
        }

        public void setExitCode(Integer n2) {
            this.exitCode = n2;
        }

        public String getOutputData() {
            return this.outputData;
        }

        public void setOutputData(String string2) {
            this.outputData = string2;
        }

        public void setTimeout(long l2) {
            this.timeout = l2;
        }
    }

    public static class ConsoleReader
    extends Thread {
        private InputStream stream = null;
        private String outputData;

        public ConsoleReader(InputStream inputStream) {
            this.setStream(inputStream);
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            BufferedReader bufferedReader = null;
            StringBuilder stringBuilder = new StringBuilder();
            bufferedReader = new BufferedReader(new InputStreamReader(this.stream));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                stringBuilder.append(string2);
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
            this.setOutputData(stringBuilder.toString());
            try {
                bufferedReader.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
            catch (Exception exception) {
                try {
                    this.setOutputData(null);
                    if (bufferedReader == null) return;
                }
                catch (Throwable throwable) {
                    if (bufferedReader == null) throw throwable;
                    try {
                        bufferedReader.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    bufferedReader.close();
                    return;
                }
                catch (IOException iOException) {
                    return;
                }
            }
        }

        public void setStream(InputStream inputStream) {
            this.stream = inputStream;
        }

        public InputStream getStream() {
            return this.stream;
        }

        public String getOutputData() {
            return this.outputData;
        }

        public void setOutputData(String string2) {
            this.outputData = string2;
        }
    }
}

