/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.base.os;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.Messenger;

public class HandlerThreadEx
implements Handler.Callback {
    private String name;
    private int priority = 0;
    private boolean ipcable;
    private HandlerThread thread;
    private Handler handler;
    private Messenger messenger;
    private Handler.Callback callback;

    public HandlerThreadEx(String string2, Handler.Callback callback) {
        this(string2, true, callback);
    }

    public HandlerThreadEx(String string2, boolean bl2, Handler.Callback callback) {
        this(string2, bl2, 0, callback);
    }

    public HandlerThreadEx(String string2, boolean bl2, int n2, Handler.Callback callback) {
        this.setName(string2);
        this.setIpcable(bl2);
        this.setPriority(n2);
        this.setCallback(callback);
        this.start();
    }

    public boolean handleMessage(Message message) {
        if (this.callback != null) {
            return this.callback.handleMessage(message);
        }
        return false;
    }

    protected synchronized void start() {
        if (this.thread != null && this.thread.isAlive() && this.handler != null && (!this.ipcable || this.messenger != null)) {
            return;
        }
        if (this.thread == null) {
            this.thread = new HandlerThread(this.getName(), this.getPriority());
        }
        if (!this.thread.isAlive()) {
            this.thread.start();
        }
        if (this.thread.isAlive()) {
            this.handler = new Handler(this.thread.getLooper(), (Handler.Callback)this);
        }
        if (this.ipcable && this.handler != null) {
            this.messenger = new Messenger(this.handler);
        }
    }

    public synchronized void stop() {
        if (this.thread == null || !this.thread.isAlive()) {
            return;
        }
        this.thread.quit();
        this.thread = null;
    }

    public Handler getHandler() {
        this.start();
        return this.handler;
    }

    public Messenger getMessenger() {
        this.start();
        return this.messenger;
    }

    public boolean isIpcable() {
        return this.ipcable;
    }

    protected void setIpcable(boolean bl2) {
        this.ipcable = bl2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string2) {
        this.name = string2;
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.setName(string2);
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int n2) {
        this.priority = n2;
    }

    public void setCallback(Handler.Callback callback) {
        this.callback = callback;
    }
}

