/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.base.os;

import android.net.Proxy;
import com.mi.milink.sdk.base.os.info.NetworkDash;
import com.mi.milink.sdk.util.CommonUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public class Http {
    public static final int HTTP_SUCCESS = 200;
    public static final int HTTP_REDIRECT = 300;
    public static final int HTTP_CLIENT_ERROR = 400;
    public static final int HTTP_SERVER_ERROR = 500;
    public static final int HTTP_CONNECT_ERROR = 1024;
    public static final int HTTP_URL_NOT_AVALIBLE = 2048;
    public static final int HTTP_CODE_ERROR = 4096;
    public static final int DEFAULT_READ_TIMEOUT = 60000;
    public static final int DEFAULT_CONNECT_TIMEOUT = 60000;
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String GZIP = "gzip";
    public static final String PROTOCOL_PREFIX = "http://";
    public static final int PROTOCOL_PREFIX_LENGTH = 7;
    public static final char PROTOCOL_PORT_SPLITTER = ':';
    public static final char PROTOCOL_HOST_SPLITTER = '/';
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEADER_X_ONLINE_HOST = "X-Online-Host";
    public static final String HEADER_HOST = "Host";

    public static boolean isSuccess(int n2) {
        return n2 >= 200 && n2 < 299;
    }

    public static String[] splitUrl(String string2) {
        String[] stringArray = new String[2];
        if (string2 == null || string2.length() < PROTOCOL_PREFIX_LENGTH) {
            return stringArray;
        }
        int n2 = (string2 = string2.toLowerCase().startsWith(PROTOCOL_PREFIX) ? string2 : PROTOCOL_PREFIX.concat(string2)).indexOf(47, PROTOCOL_PREFIX_LENGTH);
        if (n2 <= PROTOCOL_PREFIX_LENGTH) {
            n2 = string2.length();
        }
        stringArray[0] = string2.substring(PROTOCOL_PREFIX_LENGTH, n2);
        stringArray[1] = n2 < string2.length() ? string2.substring(n2, string2.length()) : "";
        return stringArray;
    }

    public static int doRequest(String string2, String string3, String string4, boolean bl2, HttpProxy httpProxy) {
        return Http.doRequest(string2, string3, string4, bl2, httpProxy, 60000, 60000);
    }

    public static int doRequest(String string2, String string3, byte[] byArray, boolean bl2, HttpProxy httpProxy) {
        return Http.doRequest(string2, string3, byArray, bl2, httpProxy, 60000, 60000);
    }

    public static int doRequest(String string2, String string3, String object, boolean bl2, HttpProxy httpProxy, int n2, int n3) {
        object = object == null ? null : ((String)object).getBytes();
        return Http.doRequest(string2, string3, (byte[])object, bl2, httpProxy, n2, n3);
    }

    public static int doRequest(String string2, String string3, byte[] byArray, boolean bl2, HttpProxy httpProxy, int n2, int n3) {
        return Http.doRequest(string2, string3, byArray, bl2, httpProxy, n2, n3, null);
    }

    public static int doRequest(String string2, String string3, String object, boolean bl2, HttpProxy httpProxy, int n2, int n3, String string4) {
        object = object == null ? null : ((String)object).getBytes();
        return Http.doRequest(string2, string3, (byte[])object, bl2, httpProxy, n2, n3, string4);
    }

    public static int doRequest(String object, String string2, byte[] byArray, boolean bl2, HttpProxy httpProxy, int n2, int n3, String string3) {
        int n4;
        HttpURLConnection httpURLConnection = null;
        try {
            String string4 = object;
            String[] stringArray = null;
            if (httpProxy != null) {
                stringArray = Http.splitUrl((String)object);
                string4 = httpProxy.toString() + stringArray[1];
            }
            string4 = string4.toLowerCase().startsWith(PROTOCOL_PREFIX) ? string4 : PROTOCOL_PREFIX.concat(string4);
            httpURLConnection = (HttpURLConnection)new URL(string4).openConnection();
            httpURLConnection.setReadTimeout(n3);
            httpURLConnection.setConnectTimeout(n2);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestMethod(string2);
            httpURLConnection.setDoInput(true);
            if (string3 != null && string3.length() > 0) {
                httpURLConnection.setRequestProperty(HEADER_HOST, string3);
            }
            if (bl2) {
                httpURLConnection.setRequestProperty(HEADER_CONTENT_ENCODING, GZIP);
            }
            if (httpProxy != null) {
                httpURLConnection.setRequestProperty(HEADER_X_ONLINE_HOST, stringArray[0]);
            }
            if (byArray != null) {
                httpURLConnection.setDoOutput(true);
                object = httpURLConnection.getOutputStream();
                if (bl2) {
                    object = new GZIPOutputStream((OutputStream)object);
                    ((FilterOutputStream)object).write(byArray);
                    ((DeflaterOutputStream)object).flush();
                    ((DeflaterOutputStream)object).close();
                } else {
                    ((OutputStream)object).write(byArray);
                    ((OutputStream)object).flush();
                    ((OutputStream)object).close();
                }
            } else {
                httpURLConnection.setDoOutput(false);
            }
            n4 = httpURLConnection.getResponseCode();
        }
        catch (MalformedURLException malformedURLException) {
            n4 = 2048;
        }
        catch (IOException iOException) {
            n4 = 1024;
        }
        catch (Exception exception) {
            n4 = 4096;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return n4;
    }

    public static int download(String string2, File object) {
        int n2;
        HttpURLConnection httpURLConnection = null;
        BufferedOutputStream bufferedOutputStream = null;
        HttpProxy httpProxy = NetworkDash.isWap() ? HttpProxy.Default : null;
        try {
            Object object2 = string2;
            String[] stringArray = null;
            if (httpProxy != null) {
                stringArray = Http.splitUrl(string2);
                object2 = httpProxy.toString() + stringArray[1];
            }
            object2 = ((String)object2).toLowerCase().startsWith(PROTOCOL_PREFIX) ? object2 : PROTOCOL_PREFIX.concat((String)object2);
            httpURLConnection = (HttpURLConnection)new URL((String)object2).openConnection();
            httpURLConnection.setReadTimeout(30000);
            httpURLConnection.setConnectTimeout(15000);
            httpURLConnection.setRequestMethod(GET);
            httpURLConnection.setDoInput(true);
            if (httpProxy != null) {
                httpURLConnection.setRequestProperty(HEADER_X_ONLINE_HOST, stringArray[0]);
            }
            if (Http.isSuccess(n2 = httpURLConnection.getResponseCode())) {
                int n3;
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream((File)object, true));
                object = httpURLConnection.getInputStream();
                object2 = new byte[8192];
                while (-1 != (n3 = ((InputStream)object).read((byte[])object2, 0, 8192))) {
                    bufferedOutputStream.write((byte[])object2, 0, n3);
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
        }
        catch (IOException iOException) {
            n2 = 1024;
        }
        catch (Exception exception) {
            n2 = 4096;
        }
        finally {
            CommonUtils.closeDataObject(bufferedOutputStream);
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return n2;
    }

    public static abstract class HttpProxy {
        public static HttpProxy Default = new HttpProxy(){

            @Override
            public final int getPort() {
                return Proxy.getDefaultPort();
            }

            @Override
            public final String getHost() {
                return Proxy.getDefaultHost();
            }
        };

        public abstract String getHost();

        public abstract int getPort();

        public String toString() {
            return this.getHost() + ':' + this.getPort();
        }
    }

    public static enum HttpProxyMode {
        NeverTry,
        Direct,
        ViaProxy;

    }
}

