/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.base.os;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import android.os.Environment;
import android.text.TextUtils;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.base.debug.CustomLogcat;
import com.mi.milink.sdk.base.os.Http;
import com.mi.milink.sdk.base.os.info.StorageDash;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.util.CommonUtils;
import com.mi.milink.sdk.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;

public class Native {
    private static final String TAG = "LibraryLoader";
    private static final String DEFAULT_LIB_DIR_NAME = "qzlib";
    private static final String DEFAULT_ASSETS_SO_DIR_NAME = "lib/armeabi-v7a";
    private static final String PREFENCE_NAME = "guarder";
    private static final String LIB_URL = "http://data.game.xiaomi.com/lib/lib.zip";
    private static final HashMap<String, String> REAL_SO_PATH = new HashMap();
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean loadLibrary(String string2) {
        String string3 = "lib" + string2 + ".so";
        File file = new File(Native.getLibDir(), string3);
        REAL_SO_PATH.put(string2, null);
        try {
            CustomLogcat.d(TAG, "try to load library: " + string2 + " from system lib");
            System.loadLibrary(string2);
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            CustomLogcat.e(TAG, "cannot load library " + string2 + " from system lib", unsatisfiedLinkError);
        }
        catch (Exception exception) {
            CustomLogcat.e(TAG, "cannot load library " + string2 + " from system lib", exception);
        }
        catch (Error error) {
            CustomLogcat.e(TAG, "cannot load library " + string2 + " from system lib", error);
        }
        if (!file.exists() || !Native.hasCopiedInSpecifiedVersion(Native.getDefaultVersionName(), string3)) {
            if (!Native.isFileInAssetsPath(string3)) {
                if (!Native.downloadNativeLibs()) return false;
                Native.setCopiedInSpecifiedVersion(Native.getDefaultVersionName(), string3, true);
            } else {
                CustomLogcat.e(TAG, string3 + " not exist,try to forceCopy!");
                try {
                    Native.forceCopySoFile(Native.getDefaultVersionName(), string3);
                }
                catch (NativeException nativeException) {
                    CustomLogcat.e(TAG, string3 + "forceCopy failed!", nativeException);
                }
                catch (Exception exception) {
                    CustomLogcat.e(TAG, string3 + "forceCopy failed!", exception);
                }
            }
        }
        if (file.exists()) {
            try {
                String string4 = file.getAbsolutePath();
                CustomLogcat.d(TAG, "try to load library: " + string4 + " from qzlib");
                System.load(string4);
                REAL_SO_PATH.put(string2, string4);
                return true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                CustomLogcat.e(TAG, "cannot load library " + file.getAbsolutePath() + " from qzlib", unsatisfiedLinkError);
            }
            catch (Exception exception) {
                CustomLogcat.e(TAG, "cannot load library " + file.getAbsolutePath() + " from qzlib", exception);
            }
            catch (Error error) {
                CustomLogcat.e(TAG, "cannot load library " + file.getAbsolutePath() + " from qzlib", error);
            }
        }
        boolean bl2 = false;
        if (Native.isFileInAssetsPath(string3)) {
            if (!file.exists()) {
                CustomLogcat.e(TAG, "Copy Lib For NOT_EXIST");
                bl2 = true;
            } else if (!Native.isSameLength(string3)) {
                CustomLogcat.e(TAG, "Copy Lib For DIFF_LENGTHS");
                bl2 = true;
            } else if (!Native.isSameMd5(string3)) {
                CustomLogcat.e(TAG, "Copy Lib For DEBUG_AND_MD5");
                bl2 = true;
            }
        }
        if (!bl2) {
            if (!Native.downloadNativeLibs()) return false;
            Native.setCopiedInSpecifiedVersion(Native.getDefaultVersionName(), string3, true);
        }
        if (bl2) {
            CustomLogcat.e(TAG, string3 + " is something wrong,try to forceCopy again!");
            try {
                Native.forceCopySoFile(Native.getDefaultVersionName(), string3);
            }
            catch (NativeException nativeException) {
                CustomLogcat.e(TAG, string3 + "forceCopy failed again!", nativeException);
            }
            catch (Exception exception) {
                CustomLogcat.e(TAG, string3 + "forceCopy failed again!", exception);
            }
        }
        if (!file.exists()) {
            CustomLogcat.e(TAG, string3 + "forceCopy done,but the sofile is not exist!");
            return false;
        }
        try {
            String string5 = file.getAbsolutePath();
            CustomLogcat.e(TAG, "try to load library: " + string5 + " from qzlib again!");
            System.load(string5);
            REAL_SO_PATH.put(string2, string5);
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            CustomLogcat.e(TAG, "cannot load library " + file.getAbsolutePath() + " from qzlib again", unsatisfiedLinkError);
        }
        catch (Exception exception) {
            CustomLogcat.e(TAG, "cannot load library " + file.getAbsolutePath() + " from qzlib again", exception);
        }
        catch (Error error) {
            CustomLogcat.e(TAG, "cannot load library " + file.getAbsolutePath() + " from qzlib again", error);
        }
        REAL_SO_PATH.put(string2, null);
        return false;
    }

    public static String getSoPath(String string2, String string3) {
        string2 = Native.getInstallPath() + File.separator + string2;
        return string2 + File.separator + string3;
    }

    public static File getLibDir() {
        String string2 = Native.getInstallPath();
        return new File(string2 + File.separator + DEFAULT_LIB_DIR_NAME);
    }

    private static String getAssetsPath(String string2) {
        return DEFAULT_ASSETS_SO_DIR_NAME + File.separator + string2;
    }

    public static String getSORealPath(String string2) {
        if (!REAL_SO_PATH.containsKey(string2)) {
            return null;
        }
        return REAL_SO_PATH.get(string2);
    }

    private static boolean isFileInAssetsPath(String string2) {
        try {
            String[] stringArray = Global.getContext().getAssets().list(DEFAULT_ASSETS_SO_DIR_NAME);
            if (stringArray == null) {
                return false;
            }
            for (String string3 : stringArray) {
                if (!string2.equalsIgnoreCase(string3)) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            CustomLogcat.e(TAG, "isFileInAssetsPath".concat(String.valueOf(string2)), iOException);
        }
        return false;
    }

    private static boolean isSameMd5(String string2) {
        boolean bl2 = false;
        try {
            String string3 = Native.getFileMd5(Global.getAssets().open(Native.getAssetsPath(string2)));
            if (TextUtils.isEmpty((CharSequence)string3)) {
                return false;
            }
            String string4 = Native.getFileMd5(new FileInputStream(new File(Native.getLibDir(), string2)));
            bl2 = string3.equals(string4);
            String string5 = Native.getLibDir() + File.separator + string2;
            CustomLogcat.e(TAG, Native.getAssetsPath(string2) + " md5 = " + string3 + "," + string5 + " md5 = " + string4);
        }
        catch (FileNotFoundException fileNotFoundException) {
            MiLinkLog.e(TAG, fileNotFoundException);
        }
        catch (IOException iOException) {
            MiLinkLog.e(TAG, iOException);
        }
        return bl2;
    }

    private static boolean isSameLength(String string2) {
        boolean bl2;
        block12: {
            Object object = new File(Native.getLibDir(), string2).getAbsolutePath();
            object = new File((String)object);
            AssetManager assetManager = Global.getAssets();
            string2 = Native.getAssetsPath(string2);
            boolean bl3 = false;
            bl2 = false;
            try {
                Object object2;
                try {
                    object2 = assetManager.openFd(string2);
                    if (object2 == null) {
                        return true;
                    }
                    CustomLogcat.e(TAG, string2 + " size = " + object2.getLength() + "," + object + " size = " + ((File)object).length());
                    if (((File)object).length() == object2.getLength()) {
                        bl2 = true;
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return true;
                }
                catch (IOException iOException) {
                    bl3 = true;
                }
                if (!bl3) break block12;
                object2 = assetManager.open(string2);
                try {
                    CustomLogcat.e(TAG, string2 + " estimated size = " + ((InputStream)object2).available() + "," + object + " size = " + ((File)object).length());
                    if (((File)object).length() == (long)((InputStream)object2).available()) {
                        bl2 = true;
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    ((InputStream)object2).close();
                }
            }
            catch (Exception exception) {}
        }
        return bl2;
    }

    private static String getFileMd5(InputStream inputStream) {
        return Native.encrypt(inputStream, "MD5");
    }

    private static void copySoFile(String string2) throws NativeException {
        CustomLogcat.i(TAG, "try to copy ".concat(String.valueOf(string2)));
        String string3 = Native.getAssetsPath(string2);
        try {
            String string4 = Native.getLibDir().getAbsolutePath();
            Native.copyAssetLib(string2, string3, string4);
            return;
        }
        catch (Throwable throwable) {
            throw new NativeException("copy file:" + string2 + " failed!", throwable);
        }
    }

    private static String getDefaultVersionName() {
        String string2;
        try {
            string2 = Global.getPackageManager().getPackageInfo((String)Global.getPackageName(), (int)0).versionName;
        }
        catch (Exception exception) {
            string2 = String.valueOf(System.currentTimeMillis());
        }
        return string2;
    }

    public static void forceCopySoFile(String string2, String ... stringArray) throws NativeException {
        if (stringArray != null) {
            for (String string3 : stringArray) {
                Native.copySoFile(string3);
                Native.setCopiedInSpecifiedVersion(string2, string3, true);
            }
        }
    }

    private static boolean hasCopiedInSpecifiedVersion(String string2, String string3) {
        SharedPreferences sharedPreferences = Global.getSharedPreferences(PREFENCE_NAME, 0);
        string2 = Native.getCopiedKey(string2, string3);
        return sharedPreferences.getBoolean(string2, false);
    }

    private static void setCopiedInSpecifiedVersion(String string2, String string3, boolean bl2) {
        SharedPreferences sharedPreferences = Global.getSharedPreferences(PREFENCE_NAME, 0);
        string2 = Native.getCopiedKey(string2, string3);
        sharedPreferences.edit().putBoolean(string2, bl2).apply();
    }

    private static String getCopiedKey(String string2, String string3) {
        return "check_" + string2 + "_" + string3;
    }

    @SuppressLint(value={"SdCardPath"})
    private static String getInstallPath() {
        File file = Global.getFilesDir();
        if (file == null) {
            file = Global.getCacheDir();
        }
        if (file != null) {
            return file.getParent();
        }
        return "/data/data/" + Global.getPackageName();
    }

    private static boolean downloadNativeLibs() {
        File file = StorageDash.hasExternal() ? new File(Environment.getExternalStorageDirectory(), "mi" + File.separator + "milink") : Global.getCacheDir();
        if ((file = new File(file, "milink_network_lib.zip")).exists()) {
            file.delete();
        }
        CustomLogcat.w(TAG, "Prepare to Download Native Libs From Network ... ");
        CustomLogcat.w(TAG, "Url = http://data.game.xiaomi.com/lib/lib.zip");
        boolean bl2 = Http.isSuccess(Http.download(LIB_URL, file));
        CustomLogcat.w(TAG, "Download Native Libs => ".concat(String.valueOf(bl2)));
        if (!bl2) {
            return false;
        }
        CustomLogcat.w(TAG, "Prepare to Install Native Libs ...");
        bl2 = FileUtils.unzip(file, Native.getLibDir());
        CustomLogcat.w(TAG, "Install Native Libs => ".concat(String.valueOf(bl2)));
        if (file.exists()) {
            file.delete();
        }
        return bl2;
    }

    public static String encrypt(InputStream inputStream, String object) {
        String string2 = null;
        try {
            int n2;
            object = MessageDigest.getInstance((String)object);
            byte[] byArray = new byte[1024];
            while ((n2 = inputStream.read(byArray)) > 0) {
                ((MessageDigest)object).update(byArray, 0, n2);
            }
            string2 = Native.bytes2HexStr(((MessageDigest)object).digest());
        }
        catch (IOException iOException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        finally {
            CommonUtils.closeDataObject(inputStream);
        }
        return string2;
    }

    private static String bytes2HexStr(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        char[] cArray = new char[2 * byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byte by2 = byArray[i2];
            cArray[2 * i2 + 1] = digits[by2 & 0xF];
            by2 = (byte)(by2 >>> 4);
            cArray[2 * i2] = digits[by2 & 0xF];
        }
        return new String(cArray);
    }

    private static synchronized boolean copyAssetLib(String object, String string2, String string3) throws Throwable {
        Context context = Global.getContext();
        if (context == null || string2 == null) {
            return false;
        }
        if (string3 == null || string3.trim().length() == 0) {
            CustomLogcat.e(TAG, "not define lib out path");
            string3 = context.getFilesDir().getAbsolutePath();
        }
        Object object2 = new File(string3);
        File file = null;
        ((File)object2).mkdirs();
        object2 = null;
        FileOutputStream fileOutputStream = null;
        CustomLogcat.d(TAG, "copy lib:" + string2 + " to " + string3);
        try {
            int n2;
            object2 = context.getAssets().open(string2);
            file = new File(string3, (String)object);
            if (file.exists()) {
                Native.delete(file);
            }
            file.createNewFile();
            fileOutputStream = new FileOutputStream(file);
            object = new byte[4096];
            while (((InputStream)object2).available() > 0 && (n2 = ((InputStream)object2).read((byte[])object)) > 0) {
                fileOutputStream.write((byte[])object, 0, n2);
            }
            fileOutputStream.close();
            ((InputStream)object2).close();
        }
        catch (Throwable throwable) {
            CommonUtils.closeDataObject(fileOutputStream);
            CommonUtils.closeDataObject(object2);
            Native.delete(file);
            throw throwable;
        }
        return true;
    }

    public static void delete(File file) {
        Native.delete(file, false);
    }

    public static void delete(File file, boolean bl2) {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        int n2 = fileArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Native.delete(fileArray[i2], bl2);
        }
        if (!bl2) {
            file.delete();
        }
    }

    public static class NativeException
    extends RuntimeException {
        private static final long serialVersionUID = 411247780482311098L;

        public NativeException() {
        }

        public NativeException(String string2) {
            super(string2);
        }

        public NativeException(String string2, Throwable throwable) {
            super(string2, throwable);
        }
    }
}

