/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.base.os;

import android.text.TextUtils;
import android.util.Pair;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.util.compress.CompressionFactory;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public final class SimpleRequest {
    private static final String TAG = "SimpleRequest";
    private static final String ENC = "utf-8";
    private static final int TIMEOUT = 20000;

    protected static String appendUrl(String string2, List<NameValuePair> object) {
        if (string2 == null) {
            throw new NullPointerException("origin is not allowed null");
        }
        StringBuilder stringBuilder = new StringBuilder(string2);
        if (object != null && (object = URLEncodedUtils.format(object, ENC)) != null && ((String)object).length() > 0) {
            if (string2.contains("?")) {
                stringBuilder.append("&");
            } else {
                stringBuilder.append("?");
            }
            stringBuilder.append((String)object);
        }
        return stringBuilder.toString();
    }

    public static List<Pair<String, String>> mapToPairs(Map<String, String> object) {
        if (object == null) {
            return null;
        }
        ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>();
        for (Map.Entry entry : object.entrySet()) {
            String string2 = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            Pair object2 = new Pair((Object)string2, (Object)(string3 != null ? string3 : ""));
            arrayList.add((Pair<String, String>)object2);
        }
        return arrayList;
    }

    public static Map<String, String> listToMap(Map<String, List<String>> object) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (object != null) {
            for (Map.Entry entry : object.entrySet()) {
                String string2 = (String)entry.getKey();
                List object2 = (List)entry.getValue();
                if (string2 == null || object2 == null || object2.size() <= 0) continue;
                hashMap.put(string2, (String)object2.get(0));
            }
        }
        return hashMap;
    }

    public static StringContent postAsString(String string2, Map<String, String> map, Map<String, String> map2, boolean bl2, LengthPair lengthPair) throws IOException {
        return SimpleRequest.postAsString(string2, map, map2, bl2, null, lengthPair);
    }

    /*
     * Loose catch block
     */
    public static StringContent postAsStringByHttps(String object, Map<String, String> object2, Map<String, String> object3, boolean bl2, String map, LengthPair lengthPair) throws IOException {
        block32: {
            if ((object3 = SimpleRequest.makeConn((String)object, object3)) == null) {
                return null;
            }
            try {
                Object object4;
                Object object5;
                Object object6;
                block34: {
                    block33: {
                        ((URLConnection)object3).setDoInput(true);
                        ((URLConnection)object3).setDoOutput(true);
                        ((HttpURLConnection)object3).setRequestMethod("POST");
                        if (!TextUtils.isEmpty((CharSequence)((Object)map))) {
                            ((URLConnection)object3).addRequestProperty("Host", (String)((Object)map));
                        }
                        ((URLConnection)object3).addRequestProperty("Content-Encoding", "gzip");
                        ((URLConnection)object3).connect();
                        if (object2 != null) {
                            block31: {
                                object2 = SimpleRequest.formatContent(object2);
                                map = ((URLConnection)object3).getOutputStream();
                                object6 = new BufferedOutputStream((OutputStream)((Object)map));
                                object2 = ((String)object2).getBytes(ENC);
                                MiLinkLog.v(TAG, "originByteArray.length=" + ((Object)object2).length);
                                object5 = CompressionFactory.createCompression(1).compress((byte[])object2);
                                MiLinkLog.v(TAG, "compressByteArray.length=" + ((byte[])object5).length);
                                ((FilterOutputStream)object6).write((byte[])object5);
                                if (lengthPair == null) break block31;
                                lengthPair.originLength = ((Object)object2).length;
                                lengthPair.compressLength = ((byte[])object5).length;
                            }
                            try {
                                ((BufferedOutputStream)object6).flush();
                                ((FilterOutputStream)object6).close();
                            }
                            catch (IOException iOException) {}
                            break block33;
                            catch (Exception exception) {
                                try {
                                    MiLinkLog.e(TAG, exception);
                                }
                                catch (Throwable throwable) {
                                    try {
                                        ((BufferedOutputStream)object6).flush();
                                        ((FilterOutputStream)object6).close();
                                    }
                                    catch (IOException iOException) {}
                                    throw throwable;
                                }
                                try {
                                    ((BufferedOutputStream)object6).flush();
                                    ((FilterOutputStream)object6).close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                    int n2 = ((HttpURLConnection)object3).getResponseCode();
                    MiLinkLog.v(TAG, "getResponseCode=".concat(String.valueOf(n2)));
                    if (n2 != 200 && n2 != 302) break block32;
                    map = ((URLConnection)object3).getHeaderFields();
                    object6 = new CookieManager();
                    object4 = new URL((String)object);
                    object5 = new URI(((URL)object4).getProtocol(), ((URL)object4).getHost(), ((URL)object4).getPath(), ((URL)object4).getQuery(), null);
                    ((CookieManager)object6).put((URI)object5, map);
                    object4 = new StringBuilder();
                    if (bl2) {
                        String string2;
                        object = new BufferedReader(new InputStreamReader(((URLConnection)object3).getInputStream()), 1024);
                        while ((string2 = ((BufferedReader)object).readLine()) != null) {
                            ((StringBuilder)object4).append(string2);
                        }
                        try {
                            ((BufferedReader)object).close();
                        }
                        catch (IOException iOException) {}
                        break block34;
                        catch (IOException iOException) {
                            try {
                                MiLinkLog.e(TAG, iOException);
                            }
                            catch (Throwable throwable) {
                                try {
                                    ((BufferedReader)object).close();
                                }
                                catch (IOException iOException2) {}
                                throw throwable;
                            }
                            try {
                                ((BufferedReader)object).close();
                            }
                            catch (IOException iOException3) {}
                        }
                    }
                }
                object = new StringContent(((StringBuilder)object4).toString());
                Map<String, String> map2 = SimpleRequest.parseCookies(((CookieManager)object6).getCookieStore().get((URI)object5));
                ((HeaderContent)object).putCookies(map2);
                map2.putAll(SimpleRequest.listToMap(map));
                ((HeaderContent)object).putHeaders(map2);
                object4 = object;
                return object4;
            }
            catch (ProtocolException protocolException) {
                throw new IOException("protocol error");
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            finally {
                ((HttpURLConnection)object3).disconnect();
            }
        }
        return null;
    }

    private static String toUtf8(String string2) {
        String string3 = "";
        try {
            string3 = new String(string2.getBytes("UTF-8"), "UTF-8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string3;
    }

    private static String formatContent(Map<String, String> object) {
        String string2 = "";
        for (Map.Entry entry : object.entrySet()) {
            String string3 = SimpleRequest.toUtf8((String)entry.getKey());
            String object2 = SimpleRequest.toUtf8((String)entry.getValue());
            if (string3 == "") continue;
            if (string2 == "") {
                string2 = String.format("%s=%s", string3, object2);
                continue;
            }
            string2 = String.format("%s&%s=%s", string2, string3, object2);
        }
        return string2;
    }

    /*
     * Loose catch block
     */
    public static StringContent postAsString(String object, Map<String, String> object2, Map<String, String> object3, boolean bl2, String map, LengthPair lengthPair) throws IOException {
        block32: {
            if ((object3 = SimpleRequest.makeConn((String)object, object3)) == null) {
                return null;
            }
            try {
                Object object4;
                Object object5;
                Object object6;
                block34: {
                    block33: {
                        ((URLConnection)object3).setDoInput(true);
                        ((URLConnection)object3).setDoOutput(true);
                        ((HttpURLConnection)object3).setRequestMethod("POST");
                        if (!TextUtils.isEmpty((CharSequence)((Object)map))) {
                            ((URLConnection)object3).addRequestProperty("Host", (String)((Object)map));
                        }
                        ((URLConnection)object3).addRequestProperty("Content-Encoding", "gzip");
                        ((URLConnection)object3).connect();
                        if (object2 != null) {
                            block31: {
                                object2 = SimpleRequest.formatContent(object2);
                                map = ((URLConnection)object3).getOutputStream();
                                object6 = new BufferedOutputStream((OutputStream)((Object)map));
                                object2 = ((String)object2).getBytes(ENC);
                                MiLinkLog.v(TAG, "originByteArray.length=" + ((Object)object2).length);
                                object5 = CompressionFactory.createCompression(1).compress((byte[])object2);
                                MiLinkLog.v(TAG, "compressByteArray.length=" + ((byte[])object5).length);
                                ((FilterOutputStream)object6).write((byte[])object5);
                                if (lengthPair == null) break block31;
                                lengthPair.originLength = ((Object)object2).length;
                                lengthPair.compressLength = ((byte[])object5).length;
                            }
                            try {
                                ((BufferedOutputStream)object6).flush();
                                ((FilterOutputStream)object6).close();
                            }
                            catch (IOException iOException) {}
                            break block33;
                            catch (Exception exception) {
                                try {
                                    MiLinkLog.e(TAG, exception);
                                }
                                catch (Throwable throwable) {
                                    try {
                                        ((BufferedOutputStream)object6).flush();
                                        ((FilterOutputStream)object6).close();
                                    }
                                    catch (IOException iOException) {}
                                    throw throwable;
                                }
                                try {
                                    ((BufferedOutputStream)object6).flush();
                                    ((FilterOutputStream)object6).close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                    int n2 = ((HttpURLConnection)object3).getResponseCode();
                    MiLinkLog.v(TAG, "getResponseCode=".concat(String.valueOf(n2)));
                    if (n2 != 200 && n2 != 302) break block32;
                    map = ((URLConnection)object3).getHeaderFields();
                    object6 = new CookieManager();
                    object4 = new URL((String)object);
                    object5 = new URI(((URL)object4).getProtocol(), ((URL)object4).getHost(), ((URL)object4).getPath(), ((URL)object4).getQuery(), null);
                    ((CookieManager)object6).put((URI)object5, map);
                    object4 = new StringBuilder();
                    if (bl2) {
                        String string2;
                        object = new BufferedReader(new InputStreamReader(((URLConnection)object3).getInputStream()), 1024);
                        while ((string2 = ((BufferedReader)object).readLine()) != null) {
                            ((StringBuilder)object4).append(string2);
                        }
                        try {
                            ((BufferedReader)object).close();
                        }
                        catch (IOException iOException) {}
                        break block34;
                        catch (IOException iOException) {
                            try {
                                MiLinkLog.e(TAG, iOException);
                            }
                            catch (Throwable throwable) {
                                try {
                                    ((BufferedReader)object).close();
                                }
                                catch (IOException iOException2) {}
                                throw throwable;
                            }
                            try {
                                ((BufferedReader)object).close();
                            }
                            catch (IOException iOException3) {}
                        }
                    }
                }
                object = new StringContent(((StringBuilder)object4).toString());
                Map<String, String> map2 = SimpleRequest.parseCookies(((CookieManager)object6).getCookieStore().get((URI)object5));
                ((HeaderContent)object).putCookies(map2);
                map2.putAll(SimpleRequest.listToMap(map));
                ((HeaderContent)object).putHeaders(map2);
                object4 = object;
                return object4;
            }
            catch (ProtocolException protocolException) {
                throw new IOException("protocol error");
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            finally {
                ((HttpURLConnection)object3).disconnect();
            }
        }
        return null;
    }

    protected static HttpURLConnection makeConn(String object, Map<String, String> map) {
        URL uRL = null;
        try {
            uRL = new URL((String)object);
        }
        catch (MalformedURLException malformedURLException) {
            MiLinkLog.e(TAG, malformedURLException);
        }
        if (uRL == null) {
            return null;
        }
        try {
            object = (HttpURLConnection)uRL.openConnection();
            ((HttpURLConnection)object).setInstanceFollowRedirects(false);
            ((URLConnection)object).setConnectTimeout(20000);
            ((URLConnection)object).setUseCaches(false);
            ((URLConnection)object).setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            if (map != null) {
                ((URLConnection)object).setRequestProperty("Cookie", SimpleRequest.joinMap(map, "; "));
            }
            return object;
        }
        catch (Exception exception) {
            MiLinkLog.e(TAG, exception);
            return null;
        }
    }

    public static String joinMap(Map<String, String> iterator, String string2) {
        if (iterator == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        iterator = iterator.entrySet();
        int n2 = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object = (Map.Entry)iterator.next();
            if (n2 > 0) {
                stringBuilder.append(string2);
            }
            String string3 = (String)object.getKey();
            object = (String)object.getValue();
            stringBuilder.append(string3);
            stringBuilder.append("=");
            stringBuilder.append((String)object);
            ++n2;
        }
        return stringBuilder.toString();
    }

    protected static Map<String, String> parseCookies(List<HttpCookie> object) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (HttpCookie)object.next();
            if (((HttpCookie)object2).hasExpired()) continue;
            String string2 = ((HttpCookie)object2).getName();
            object2 = ((HttpCookie)object2).getValue();
            if (string2 == null) continue;
            hashMap.put(string2, (String)object2);
        }
        return hashMap;
    }

    public static class StreamContent
    extends HeaderContent {
        private InputStream stream;

        public StreamContent(InputStream inputStream) {
            this.stream = inputStream;
        }

        public InputStream getStream() {
            return this.stream;
        }
    }

    public static class MapContent
    extends HeaderContent {
        private Map<String, Object> bodies;

        public MapContent(Map<String, Object> map) {
            this.bodies = map;
        }

        public Object getFromBody(String string2) {
            return this.bodies.get(string2);
        }

        @Override
        public String toString() {
            return "MapContent{bodies=" + this.bodies + '}';
        }
    }

    public static class StringContent
    extends HeaderContent {
        private String body;

        public StringContent(String string2) {
            this.body = string2;
        }

        public String getBody() {
            return this.body;
        }

        @Override
        public String toString() {
            return "StringContent{body='" + this.body + '\'' + '}';
        }
    }

    public static class HeaderContent {
        private final Map<String, String> headers = new HashMap<String, String>();
        private final Map<String, String> cookies = new HashMap<String, String>();

        public void putHeader(String string2, String string3) {
            this.headers.put(string2, string3);
        }

        public String getHeader(String string2) {
            return this.headers.get(string2);
        }

        public void putCookie(String string2, String string3) {
            this.cookies.put(string2, string3);
        }

        public String getCookie(String string2) {
            return this.cookies.get(string2);
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public void putHeaders(Map<String, String> map) {
            this.headers.putAll(map);
        }

        public Map<String, String> getCookies() {
            return this.cookies;
        }

        public void putCookies(Map<String, String> map) {
            this.cookies.putAll(map);
        }

        public String toString() {
            return "HeaderContent{headers=" + this.headers + '}';
        }
    }

    public static class LengthPair {
        public int originLength;
        public int compressLength;
    }
}

