/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.base.os.dns;

import com.mi.milink.sdk.base.os.dns.WireParseException;

public class DNSInput {
    private byte[] array;
    private int pos;
    private int end;
    private int saved_pos;
    private int saved_end;

    public DNSInput(byte[] byArray) {
        this.array = byArray;
        this.pos = 0;
        this.end = this.array.length;
        this.saved_pos = -1;
        this.saved_end = -1;
    }

    public int current() {
        return this.pos;
    }

    public int remaining() {
        return this.end - this.pos;
    }

    private void require(int n2) throws WireParseException {
        if (n2 > this.remaining()) {
            throw new WireParseException("end of input");
        }
    }

    public void setActive(int n2) {
        if (n2 > this.array.length - this.pos) {
            throw new IllegalArgumentException("cannot set active region past end of input");
        }
        this.end = this.pos + n2;
    }

    public void clearActive() {
        this.end = this.array.length;
    }

    public void jump(int n2) {
        if (n2 >= this.array.length) {
            throw new IllegalArgumentException("cannot jump past end of input");
        }
        this.pos = n2;
        this.end = this.array.length;
    }

    public void save() {
        this.saved_pos = this.pos;
        this.saved_end = this.end;
    }

    public void restore() {
        if (this.saved_pos < 0) {
            throw new IllegalStateException("no previous state");
        }
        this.pos = this.saved_pos;
        this.end = this.saved_end;
        this.saved_pos = -1;
        this.saved_end = -1;
    }

    public int readU8() throws WireParseException {
        this.require(1);
        return this.array[this.pos++] & 0xFF;
    }

    public int readU16() throws WireParseException {
        this.require(2);
        int n2 = this.array[this.pos++] & 0xFF;
        int n3 = this.array[this.pos++] & 0xFF;
        return (n2 << 8) + n3;
    }

    public long readU32() throws WireParseException {
        this.require(4);
        int n2 = this.array[this.pos++] & 0xFF;
        int n3 = this.array[this.pos++] & 0xFF;
        int n4 = this.array[this.pos++] & 0xFF;
        int n5 = this.array[this.pos++] & 0xFF;
        return ((long)n2 << 24) + (long)(n3 << 16) + (long)(n4 << 8) + (long)n5;
    }

    public void readByteArray(byte[] byArray, int n2, int n3) throws WireParseException {
        this.require(n3);
        System.arraycopy(this.array, this.pos, byArray, n2, n3);
        this.pos += n3;
    }

    public byte[] readByteArray(int n2) throws WireParseException {
        this.require(n2);
        byte[] byArray = new byte[n2];
        System.arraycopy(this.array, this.pos, byArray, 0, n2);
        this.pos += n2;
        return byArray;
    }

    public byte[] readByteArray() {
        int n2 = this.remaining();
        byte[] byArray = new byte[n2];
        System.arraycopy(this.array, this.pos, byArray, 0, n2);
        this.pos += n2;
        this.end = this.array.length - 1;
        return byArray;
    }

    public byte[] readCountedString() throws WireParseException {
        this.require(1);
        int n2 = this.array[this.pos++] & 0xFF;
        return this.readByteArray(n2);
    }
}

