/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.base.os.dns;

import com.mi.milink.sdk.base.debug.CustomLogcat;
import com.mi.milink.sdk.base.os.dns.Lookup;
import com.mi.milink.sdk.base.os.dns.WireParseException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class DnsMain {
    private static final String TAG = DnsMain.class.getName();

    public static InetAddress[] getBetterHostByName(String string2, long l2) {
        string2 = DnsMain.getHostName(string2);
        CustomLogcat.w("DNSResolve", "hostName:" + string2 + ",timeout:" + l2);
        CustomLogcat.v(TAG, "get better host for name:".concat(String.valueOf(string2)));
        if (string2 == null || string2.trim().length() <= 0) {
            return null;
        }
        string2 = string2.trim();
        try {
            InetAddress[] inetAddressArray = new Lookup("114.114.114.114").run(string2, l2);
            if (inetAddressArray != null && inetAddressArray.length > 0) {
                return inetAddressArray;
            }
            CustomLogcat.e(TAG, "114 - Address == null ? WTF ?!");
        }
        catch (UnknownHostException unknownHostException) {
            CustomLogcat.e(TAG, "UnknownHostException cause[" + string2 + "][114.114.114.114]." + unknownHostException.getMessage());
        }
        catch (WireParseException wireParseException) {
            CustomLogcat.e(TAG, "WireParseException cause[" + string2 + "][114.114.114.114]." + wireParseException.getMessage());
        }
        catch (SocketTimeoutException socketTimeoutException) {
            CustomLogcat.e(TAG, "SocketTimeoutException cause[" + string2 + "][114.114.114.114]." + socketTimeoutException.getMessage());
        }
        catch (IOException iOException) {
            CustomLogcat.e(TAG, "IOException cause[" + string2 + "][114.114.114.114]." + iOException.getMessage());
        }
        catch (Exception exception) {
            CustomLogcat.e(TAG, "Exception cause[" + string2 + "][114.114.114.114]." + exception.getMessage());
        }
        return null;
    }

    public static String getHostName(String string2) {
        int n2;
        int n3;
        if (string2 == null) {
            return "";
        }
        String string3 = (string2 = string2.trim()).toLowerCase();
        string3 = string3.startsWith("http://") ? ((n3 = string2.indexOf("/", 8)) > 7 ? string2.substring(7, n3) : string2.substring(7)) : (string3.startsWith("https://") ? ((n2 = string2.indexOf("/", 9)) > 8 ? string2.substring(8, n2) : string2.substring(8)) : (string2.indexOf("/", 1) > 1 ? string2.substring(0, string2.indexOf("/", 1)) : string2));
        return string3;
    }
}

