/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.base.os.dns;

import com.mi.milink.sdk.base.debug.CustomLogcat;
import com.mi.milink.sdk.base.os.info.NetworkDash;
import com.mi.milink.sdk.base.os.info.WifiDash;
import java.net.InetAddress;
import java.util.LinkedHashMap;
import java.util.Map;

public class HostCacheManager {
    private final int MAX_CACHE_SIZE = 128;
    private Cache<String, HostEntity> data = new Cache(128);
    private static HostCacheManager manager = null;

    public static synchronized HostCacheManager getInstance() {
        if (manager == null) {
            manager = new HostCacheManager();
        }
        return manager;
    }

    public InetAddress[] getCacheItemByHost(String string2) {
        HostEntity hostEntity = this.data.get(string2);
        if (hostEntity != null) {
            if (!hostEntity.isValid()) {
                this.data.remove(string2);
            } else {
                return hostEntity.address;
            }
        }
        return null;
    }

    public void addCache(String string2, InetAddress[] inetAddressArray, long l2) {
        CustomLogcat.i("dnstest", "$$$addCache[" + string2 + "]");
        HostEntity hostEntity = new HostEntity();
        new HostEntity().expireTime = l2;
        hostEntity.address = inetAddressArray;
        String string3 = hostEntity.networkType = NetworkDash.isMobile() ? NetworkDash.getApnName() : WifiDash.getBSSID();
        if (this.data.containsKey(string2)) {
            this.data.remove(string2);
        }
        this.data.put(string2, hostEntity);
    }

    private class HostEntity {
        public long expireTime = 0L;
        public InetAddress[] address = null;
        public String networkType = null;

        private HostEntity() {
        }

        public boolean isValid() {
            boolean bl2 = System.currentTimeMillis() < this.expireTime;
            if (bl2) {
                String string2 = NetworkDash.isMobile() ? NetworkDash.getApnName() : WifiDash.getBSSID();
                bl2 = string2 == null ? false : string2.equalsIgnoreCase(this.networkType);
            }
            return bl2;
        }
    }

    private class Cache<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = -6940751117906094384L;
        private int capacity;
        private static final float DEFAULT_LOAD_FACTOR = 0.75f;
        private Object lock;

        public Cache(int n2) {
            super(n2, 0.75f, true);
            this.capacity = 5;
            this.lock = new Object();
            if (n2 > 0) {
                this.capacity = n2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.get(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V put(K k2, V v2) {
            Object object = this.lock;
            synchronized (object) {
                return super.put(k2, v2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            Object object = this.lock;
            synchronized (object) {
                super.putAll(map);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V remove(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.lock;
            synchronized (object) {
                super.clear();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.containsKey(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.lock;
            synchronized (object) {
                return super.size();
            }
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
            return this.size() > this.capacity;
        }
    }
}

