/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.base.os.dns;

import com.mi.milink.sdk.base.os.dns.DNSInput;
import com.mi.milink.sdk.base.os.dns.HostCacheManager;
import com.mi.milink.sdk.base.os.dns.RequestPacket;
import com.mi.milink.sdk.base.os.dns.ResponsePacket;
import com.mi.milink.sdk.base.os.dns.UdpClient;
import com.mi.milink.sdk.base.os.dns.WireParseException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class Lookup {
    private String dnsServerAddress = "";

    public Lookup(String string2) throws UnknownHostException {
        this.dnsServerAddress = string2;
    }

    public void setDnsAddress(String string2) {
        this.dnsServerAddress = string2;
    }

    public InetAddress[] run(String string2, long l2) throws IOException, SocketTimeoutException, WireParseException, UnknownHostException, Exception {
        InetAddress[] inetAddressArray = null;
        RequestPacket requestPacket = new RequestPacket(string2);
        byte[] byArray = requestPacket.getQueryData();
        if (byArray == null) {
            return null;
        }
        try {
            UdpClient udpClient = new UdpClient();
            udpClient.setTimeout(l2);
            Object object = udpClient.sendrecv(this.dnsServerAddress, byArray);
            if (object != null) {
                ResponsePacket responsePacket = new ResponsePacket(new DNSInput((byte[])object), string2);
                object = responsePacket;
                if (responsePacket.getReqId() == requestPacket.getReqId() && (inetAddressArray = ((ResponsePacket)object).getByAddress()) != null && inetAddressArray.length > 0) {
                    HostCacheManager.getInstance().addCache(string2, inetAddressArray, ((ResponsePacket)object).getExpireTime());
                }
            }
        }
        catch (WireParseException wireParseException) {
            throw wireParseException;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            throw socketTimeoutException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        return inetAddressArray;
    }
}

