/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.base.os.dns;

import com.mi.milink.sdk.base.debug.CustomLogcat;
import com.mi.milink.sdk.base.os.dns.AnswerRecord;
import com.mi.milink.sdk.base.os.dns.ByteBase;
import com.mi.milink.sdk.base.os.dns.DNSInput;
import com.mi.milink.sdk.base.os.dns.WireParseException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;

public class ResponsePacket {
    private DNSInput in;
    private int[] counts = new int[4];
    private int reqId;
    private int flags;
    private ArrayList[] sections;
    private long expireTime = 0L;
    private String host = "";
    private static final int MAXLABEL = 64;
    private static final int LABEL_NORMAL = 0;
    private static final int LABEL_COMPRESSION = 192;
    private static final int LABEL_MASK = 192;
    private static final int SECTION_QUESTION = 0;
    private static final int SECTION_ADDRESS = 1;
    private byte[] label = new byte[64];
    private StringBuilder nameBuilder = new StringBuilder();

    public ResponsePacket(DNSInput dNSInput, String string2) throws WireParseException, UnknownHostException, Exception {
        this.in = dNSInput;
        this.host = string2;
        this.sections = new ArrayList[4];
        this.initHeader();
        ResponsePacket responsePacket = this;
        responsePacket.check(responsePacket.flags);
        this.parseAnswer();
    }

    public ArrayList<AnswerRecord> getAnswers() {
        return this.sections[1];
    }

    public InetAddress[] getByAddress() {
        if (this.sections[1] != null && this.sections[1].size() > 0) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i2 = 0; i2 < this.sections[1].size(); ++i2) {
                Object object = (AnswerRecord)this.sections[1].get(i2);
                try {
                    object = InetAddress.getByAddress(((AnswerRecord)object).domain, ((AnswerRecord)object).ip);
                    if (object == null || ((InetAddress)object).getHostName() == null || ((InetAddress)object).getHostName().equals(((InetAddress)object).getHostAddress())) continue;
                    arrayList.add(object);
                    continue;
                }
                catch (UnknownHostException unknownHostException) {
                    CustomLogcat.e("ResponsePacket", "getByAddress>>>", unknownHostException);
                }
            }
            ArrayList<Object> arrayList2 = arrayList;
            return arrayList2.toArray(new InetAddress[arrayList2.size()]);
        }
        return null;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public int getReqId() {
        return this.reqId;
    }

    private void initHeader() throws WireParseException {
        this.reqId = this.in.readU16();
        this.flags = this.in.readU16();
        for (int i2 = 0; i2 < this.counts.length; ++i2) {
            this.counts[i2] = this.in.readU16();
        }
    }

    private void parseAnswer() throws WireParseException {
        for (int i2 = 0; i2 < 2; ++i2) {
            int n2 = this.counts[i2];
            if (n2 > 0) {
                this.sections[i2] = new ArrayList(n2);
            }
            for (int i3 = 0; i3 < n2; ++i3) {
                AnswerRecord answerRecord = new AnswerRecord();
                if (i2 == 0) {
                    answerRecord.domain = this.retrieveName();
                    answerRecord.type = this.in.readU16();
                    answerRecord.qclass = this.in.readU16();
                    this.sections[i2].add(answerRecord);
                    continue;
                }
                this.retrieveName();
                answerRecord.domain = this.host;
                answerRecord.type = this.in.readU16();
                answerRecord.qclass = this.in.readU16();
                answerRecord.ttl = this.in.readU32();
                this.in.setActive(this.in.readU16());
                answerRecord.ip = this.in.readByteArray();
                if (answerRecord.type != 1) continue;
                this.setExpireTime(answerRecord.ttl);
                this.sections[i2].add(answerRecord);
            }
        }
        return;
    }

    private String retrieveName() throws WireParseException {
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.nameBuilder.length() > 0) {
            this.nameBuilder.delete(0, this.nameBuilder.length());
        }
        block4: while (!bl2) {
            int n2 = this.in.readU8();
            switch (n2 & 0xC0) {
                case 0: {
                    if (n2 == 0) {
                        bl2 = true;
                        continue block4;
                    }
                    this.in.readByteArray(this.label, 0, n2);
                    this.nameBuilder.append(ByteBase.byteString(this.label, n2));
                    this.nameBuilder.append(".");
                    continue block4;
                }
                case 192: {
                    n2 = this.in.readU8() + ((n2 & 0xFFFFFF3F) << 8);
                    if (n2 >= this.in.current() - 2) {
                        throw new WireParseException("bad compression");
                    }
                    if (!bl3) {
                        this.in.save();
                        bl3 = true;
                    }
                    this.in.jump(n2);
                    continue block4;
                }
            }
            throw new WireParseException("bad label type");
        }
        if (bl3) {
            this.in.restore();
        }
        if (this.nameBuilder.length() > 0) {
            this.nameBuilder.deleteCharAt(this.nameBuilder.length() - 1);
        }
        return this.nameBuilder.toString();
    }

    private void check(int n2) throws UnknownHostException, Exception {
        String string2 = Integer.toBinaryString(n2);
        if (string2.length() < 4) {
            throw new Exception("exception cause [FBS - " + string2 + "]");
        }
        String string3 = string2;
        string2 = string3.substring(string3.length() - 4);
        if (string2.equals("0011")) {
            throw new UnknownHostException("Unable to resolve host \"" + this.host + "\": No address associated with hostname");
        }
        if (!string2.equals("0000")) {
            throw new Exception("exception cause [RCODE - " + string2 + "][HOST - " + this.host + "]");
        }
    }

    private void setExpireTime(long l2) {
        if (this.expireTime == 0L && l2 > 0L) {
            this.expireTime = System.currentTimeMillis() + l2 * 1000L;
        }
    }
}

