/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.base.os.dns;

import com.mi.milink.sdk.util.SecureRandomUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.security.SecureRandom;

final class UdpClient {
    private static final int EPHEMERAL_START = 1024;
    private static final int EPHEMERAL_STOP = 65535;
    private static final int EPHEMERAL_RANGE = 64511;
    private long timeout_value = 5000L;
    private static final int MAX_SIZE = 512;
    private static SecureRandom prng = SecureRandomUtils.createSecureRandom();

    UdpClient() {
    }

    public final byte[] sendrecv(String object, byte[] byArray) throws IOException, SocketTimeoutException {
        SelectionKey selectionKey = null;
        try {
            DatagramChannel datagramChannel = DatagramChannel.open();
            ((SelectableChannel)datagramChannel).configureBlocking(false);
            Selector selector = Selector.open();
            selectionKey = datagramChannel.register(selector, 1);
            datagramChannel = (DatagramChannel)selectionKey.channel();
            int n2 = prng.nextInt(64511) + 1024;
            InetSocketAddress inetSocketAddress = new InetSocketAddress(n2);
            datagramChannel.socket().bind(inetSocketAddress);
            object = new InetSocketAddress(InetAddress.getByName((String)object), 53);
            datagramChannel.connect((SocketAddress)object);
            datagramChannel.write(ByteBuffer.wrap(byArray));
            object = new byte[512];
            long l2 = System.currentTimeMillis() + this.timeout_value;
            try {
                while (!selectionKey.isReadable()) {
                    UdpClient.blockUntil(selectionKey, l2);
                }
            }
            finally {
                if (selectionKey.isValid()) {
                    selectionKey.interestOps(0);
                }
            }
            long l3 = datagramChannel.read(ByteBuffer.wrap((byte[])object));
            if (l3 > 0L) {
                int n3 = (int)l3;
                byArray = new byte[n3];
                System.arraycopy(object, 0, byArray, 0, n3);
                object = byArray;
                return object;
            }
        }
        finally {
            if (selectionKey != null) {
                selectionKey.selector().close();
                selectionKey.channel().close();
            }
        }
        return null;
    }

    public final void setTimeout(long l2) {
        if (l2 > 0L) {
            this.timeout_value = l2;
        }
    }

    private static void blockUntil(SelectionKey selectionKey, long l2) throws IOException, SocketTimeoutException {
        long l3 = l2 - System.currentTimeMillis();
        int n2 = 0;
        if (l3 > 0L) {
            n2 = selectionKey.selector().select(l3);
        } else if (l3 == 0L) {
            n2 = selectionKey.selector().selectNow();
        }
        if (n2 == 0) {
            throw new SocketTimeoutException();
        }
    }
}

