/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.base.os.info;

import com.mi.milink.sdk.base.os.info.ServiceProvider;
import java.util.HashMap;

public enum AccessPoint {
    NONE("", ServiceProvider.NONE, false),
    NEVER_HEARD("I don't know", ServiceProvider.NEVER_HEARD, false),
    CMNET("cmnet", ServiceProvider.CHINA_MOBILE, false),
    CMWAP("cmwap", ServiceProvider.CHINA_MOBILE, true),
    UNINET("uninet", ServiceProvider.CHINA_UNICOM, false),
    UNIWAP("uniwap", ServiceProvider.CHINA_UNICOM, true),
    _3GNET("3gnet", ServiceProvider.CHINA_UNICOM, false),
    _3GWAP("3gwap", ServiceProvider.CHINA_UNICOM, true),
    WONET("wonet", ServiceProvider.CHINA_UNICOM, false),
    CTNET("ctnet", ServiceProvider.CHINA_TELECOM, false),
    CTWAP("ctwap", ServiceProvider.CHINA_TELECOM, true),
    CTLTE("ctlte", ServiceProvider.CHINA_TELECOM, false),
    SHARP777("#777", ServiceProvider.CHINA_TELECOM, false);

    private static HashMap<String, AccessPoint> ACCESS_POINT_MAP;
    private String name;
    private ServiceProvider provider;
    private boolean wap;

    public static AccessPoint forName(String object) {
        if (object == null) {
            return NONE;
        }
        if ((object = ACCESS_POINT_MAP.get(object.toLowerCase())) == null) {
            return NEVER_HEARD;
        }
        return object;
    }

    private AccessPoint(String string3, ServiceProvider serviceProvider, boolean bl2) {
        this.setName(string3);
        this.setProvider(serviceProvider);
        this.setWap(bl2);
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String string2) {
        this.name = string2;
    }

    public final ServiceProvider getProvider() {
        return this.provider;
    }

    public final void setProvider(ServiceProvider serviceProvider) {
        this.provider = serviceProvider;
    }

    public final boolean isWap() {
        return this.wap;
    }

    public final void setWap(boolean bl2) {
        this.wap = bl2;
    }

    static {
        ACCESS_POINT_MAP = new HashMap();
        for (AccessPoint accessPoint : AccessPoint.values()) {
            ACCESS_POINT_MAP.put(accessPoint.getName(), accessPoint);
        }
    }
}

