/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.base.os.info;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.os.AsyncTask;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.base.os.info.NetworkDash;
import com.mi.milink.sdk.base.os.info.NetworkState;
import com.mi.milink.sdk.base.os.info.NetworkStateListener;
import com.miui.deviceid.IdentifierManager;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLEncoder;

public class DeviceDash
implements NetworkStateListener {
    private static final DeviceDash instance = new DeviceDash();
    private String mDeviceInfo = null;
    private String mDeviceSimplifiedInfo = null;
    private String mDeviceId = null;
    private String mOAID = null;
    private String androidId = "";

    @SuppressLint(value={"StaticFieldLeak"})
    public DeviceDash() {
        NetworkDash.addListener(this);
        if (IdentifierManager.a()) {
            this.mOAID = IdentifierManager.a(Global.getContext());
        }
        this.getAndroidId();
        new AsyncTask<Void, Integer, Void>(){

            protected Void doInBackground(Void ... voidArray) {
                DeviceDash.this.updateDeviceInfo();
                return null;
            }
        }.execute((Object[])new Void[0]);
    }

    public String updateDeviceInfo() {
        Object object = (WindowManager)Global.getSystemService("window");
        Object object2 = new DisplayMetrics();
        try {
            object.getDefaultDisplay().getMetrics((DisplayMetrics)object2);
        }
        catch (Exception exception) {}
        object = new StringBuilder();
        String string2 = this.getDeviceId();
        String string3 = NetworkDash.isWifi() ? "wifi" : (NetworkDash.is2G() ? "2G" : (NetworkDash.is3G() ? "3G" : (NetworkDash.isEthernet() ? "ethernet" : "wan")));
        ((StringBuilder)object).append("imei=").append(string2).append('&');
        String string4 = Build.MODEL;
        if (!TextUtils.isEmpty((CharSequence)string4) && string4.contains("&")) {
            try {
                string4 = URLEncoder.encode(string4, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        ((StringBuilder)object).append("model=").append(string4).append('&');
        ((StringBuilder)object).append("os=").append(Build.VERSION.RELEASE).append('&');
        ((StringBuilder)object).append("apilevel=").append(Build.VERSION.SDK_INT).append('&');
        ((StringBuilder)object).append("macaddress=N/A&");
        ((StringBuilder)object).append("network=").append(string3).append('&');
        ((StringBuilder)object).append("display=").append(((DisplayMetrics)object2).widthPixels).append('*').append(((DisplayMetrics)object2).heightPixels).append('&');
        try {
            ((StringBuilder)object).append("manu=").append(URLEncoder.encode(Build.MANUFACTURER, "UTF-8")).append('&');
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        ((StringBuilder)object).append("gv=").append(Global.getClientAppInfo().getGv()).append('&');
        ((StringBuilder)object).append("versioncode=").append(Global.getClientAppInfo().getVersionCode()).append('&');
        ((StringBuilder)object).append("packagename=").append(Global.getClientAppInfo().getPackageName()).append('&');
        ((StringBuilder)object).append("oaid=").append(this.mOAID).append('&');
        ((StringBuilder)object).append("gaid=").append(Global.gaid);
        try {
            object2 = Class.forName("android.os.SystemProperties").getDeclaredMethod("get", String.class, String.class);
            string3 = (String)((Method)object2).invoke(null, "ro.miui.ui.version.name", "");
            ((StringBuilder)object).append("&");
            ((StringBuilder)object).append("miui=").append(string3);
            object2 = (String)((Method)object2).invoke(null, "ro.build.version.incremental", "");
            ((StringBuilder)object).append("&");
            ((StringBuilder)object).append("subversion=").append(URLEncoder.encode((String)object2, "UTF-8"));
            ((StringBuilder)object).append("&");
            ((StringBuilder)object).append("deviceid=").append(string2);
            ((StringBuilder)object).append("&");
            ((StringBuilder)object).append("androidid=").append(this.mOAID);
            ((StringBuilder)object).append("&");
            ((StringBuilder)object).append("wifiname=N/A");
        }
        catch (Exception exception) {}
        this.mDeviceSimplifiedInfo = ((StringBuilder)object).toString();
        ((StringBuilder)object).append('&');
        ((StringBuilder)object).append("wifi=N/A&");
        ((StringBuilder)object).append("dns=N/A");
        this.mDeviceInfo = ((StringBuilder)object).toString();
        return this.mDeviceInfo;
    }

    @SuppressLint(value={"MissingPermission"})
    public String getDeviceId() {
        if (TextUtils.isEmpty((CharSequence)this.mDeviceId)) {
            try {
                TelephonyManager telephonyManager = (TelephonyManager)Global.getSystemService("phone");
                this.mDeviceId = telephonyManager.getDeviceId();
                if (TextUtils.isEmpty((CharSequence)this.mDeviceId)) {
                    this.mDeviceId = "N/A";
                }
            }
            catch (Exception exception) {
                this.mDeviceId = "N/A";
            }
        }
        return this.mDeviceId;
    }

    public String getAndroidId() {
        if (TextUtils.isEmpty((CharSequence)this.androidId)) {
            try {
                this.androidId = Settings.Secure.getString((ContentResolver)Global.getApplicationContext().getContentResolver(), (String)"android_id");
            }
            catch (Exception exception) {
                this.androidId = "";
            }
        }
        return this.androidId;
    }

    public static DeviceDash getInstance() {
        return instance;
    }

    public String getDeviceInfo() {
        if (this.mDeviceInfo == null || this.mDeviceInfo.length() <= 0) {
            return this.updateDeviceInfo();
        }
        return this.mDeviceInfo;
    }

    public String getDeviceSimplifiedInfo() {
        if (this.mDeviceSimplifiedInfo == null || this.mDeviceSimplifiedInfo.length() <= 0) {
            this.updateDeviceInfo();
        }
        return this.mDeviceSimplifiedInfo;
    }

    @Override
    @SuppressLint(value={"StaticFieldLeak"})
    public void onNetworkStateChanged(NetworkState networkState, NetworkState networkState2) {
        this.updateDeviceInfo();
    }
}

