/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.base.os.info;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.base.debug.CustomLogcat;
import com.mi.milink.sdk.base.os.info.AccessPoint;
import com.mi.milink.sdk.base.os.info.NetworkObserver;
import com.mi.milink.sdk.base.os.info.NetworkState;
import com.mi.milink.sdk.base.os.info.NetworkStateListener;
import com.mi.milink.sdk.base.os.info.NetworkType;
import com.mi.milink.sdk.base.os.info.ServiceProvider;
import com.mi.milink.sdk.debug.MiLinkLog;
import java.lang.ref.WeakReference;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NetworkDash {
    private static NetworkState sCurrState;
    private static NetworkState sLastState;
    private static Handler sMainHandler;
    private static ServiceProvider sImsiProvider;
    private static final NetworkObserver OBSERVER;
    private static final List<WeakReference<NetworkStateListener>> OBSERVER_LIST;

    public static boolean isAvailable() {
        NetworkDash.updateNetworkState();
        if (NetworkDash.getCurrState() != null) {
            return NetworkDash.getCurrState().isAvailable();
        }
        return false;
    }

    public static AccessPoint getAccessPoint() {
        NetworkState networkState = NetworkDash.getCurrState();
        if (networkState != null) {
            return networkState.getAccessPoint();
        }
        return AccessPoint.NONE;
    }

    public static NetworkType getType() {
        NetworkState networkState = NetworkDash.getCurrState();
        if (networkState != null) {
            return networkState.getType();
        }
        return NetworkType.NONE;
    }

    public static String getApnName() {
        NetworkState networkState = NetworkDash.getCurrState();
        if (networkState != null) {
            return networkState.getApnName();
        }
        return "";
    }

    public static int getApnType() {
        NetworkState networkState = NetworkDash.getCurrState();
        if (networkState != null) {
            return networkState.getApnType();
        }
        return -1;
    }

    public static String getApnNameOrWifi() {
        if (!NetworkDash.isAvailable()) {
            return "";
        }
        if (NetworkDash.isWifi()) {
            return "wifi";
        }
        return NetworkDash.getApnName();
    }

    public static String getApnNameOrWifiOrEthernet() {
        if (!NetworkDash.isAvailable()) {
            return "";
        }
        if (NetworkDash.isWifi()) {
            return "wifi";
        }
        if (NetworkDash.isEthernet()) {
            return "ethernet";
        }
        return NetworkDash.getApnName();
    }

    public static ServiceProvider getProvider() {
        NetworkState networkState = NetworkDash.getCurrState();
        if (networkState != null) {
            return networkState.getAccessPoint().getProvider();
        }
        return ServiceProvider.NONE;
    }

    public static ServiceProvider getProvider(boolean bl2) {
        ServiceProvider serviceProvider;
        if (bl2 && !ServiceProvider.NONE.equals((Object)(serviceProvider = NetworkDash.getIMSIProvider()))) {
            return serviceProvider;
        }
        return NetworkDash.getProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceProvider updateIMSIProvider() {
        try {
            Class<NetworkDash> clazz = NetworkDash.class;
            synchronized (NetworkDash.class) {
                String string2 = NetworkDash.getIMSI();
                sImsiProvider = ServiceProvider.fromIMSI(string2);
                CustomLogcat.w("NetworkObserver", string2 + " => " + (Object)((Object)sImsiProvider));
                // ** MonitorExit[var0] (shouldn't be in output)
                return sImsiProvider;
            }
        }
        catch (Exception exception) {
            return ServiceProvider.NONE;
        }
    }

    public static String getIMSI() {
        try {
            String string2 = ((TelephonyManager)Global.getSystemService("phone")).getSimOperator();
            if (TextUtils.isEmpty((CharSequence)string2)) {
                string2 = NetworkDash.getDeviceIdBySlot(Global.getContext(), 0);
            }
            if (TextUtils.isEmpty((CharSequence)string2)) {
                string2 = NetworkDash.getDeviceIdBySlot(Global.getContext(), 1);
            }
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getDeviceIdBySlot(Context object, int n2) {
        CustomLogcat.v("NetworkDash", "isDeviceIdBySlot:".concat(String.valueOf(n2)));
        if (object == null) {
            return null;
        }
        if (n2 < 0 || n2 > 1) {
            return null;
        }
        String string2 = null;
        try {
            object = (TelephonyManager)object.getSystemService("phone");
            GenericDeclaration genericDeclaration = Class.forName("android.telephony.TelephonyManager");
            Class[] classArray = new Class[1];
            Object[] objectArray = classArray;
            classArray[0] = Integer.TYPE;
            genericDeclaration = ((Class)genericDeclaration).getMethod("getSimOperatorGemini", (Class<?>[])objectArray);
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = n2;
            object = ((Method)genericDeclaration).invoke(object, objectArray);
            if (object != null) {
                string2 = object.toString();
            }
        }
        catch (Exception exception) {}
        return string2;
    }

    public static ServiceProvider getIMSIProvider() {
        if (sImsiProvider == null) {
            NetworkDash.updateIMSIProvider();
        }
        return sImsiProvider;
    }

    public static boolean isWap() {
        return NetworkDash.getAccessPoint().isWap();
    }

    public static boolean isMobile() {
        NetworkType networkType = NetworkDash.getType();
        return NetworkType.MOBILE_3G.equals((Object)networkType) || NetworkType.MOBILE_2G.equals((Object)networkType);
    }

    public static boolean is2G() {
        NetworkType networkType = NetworkDash.getType();
        return NetworkType.MOBILE_2G.equals((Object)networkType);
    }

    public static boolean is3G() {
        NetworkType networkType = NetworkDash.getType();
        return NetworkType.MOBILE_3G.equals((Object)networkType);
    }

    public static boolean isWifi() {
        return NetworkType.WIFI.equals((Object)NetworkDash.getType());
    }

    public static boolean isEthernet() {
        return NetworkType.ETHERNET.equals((Object)NetworkDash.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(NetworkStateListener networkStateListener) {
        List<WeakReference<NetworkStateListener>> list = OBSERVER_LIST;
        synchronized (list) {
            OBSERVER_LIST.add(new WeakReference<NetworkStateListener>(networkStateListener));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(NetworkStateListener networkStateListener) {
        List<WeakReference<NetworkStateListener>> list = OBSERVER_LIST;
        synchronized (list) {
            WeakReference<NetworkStateListener> weakReference = null;
            for (WeakReference<NetworkStateListener> weakReference2 : OBSERVER_LIST) {
                NetworkStateListener networkStateListener2 = (NetworkStateListener)weakReference2.get();
                if (networkStateListener2 == null || !networkStateListener2.equals(networkStateListener)) continue;
                weakReference = weakReference2;
                break;
            }
            OBSERVER_LIST.remove(weakReference);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyNetworkStateChange() {
        if (OBSERVER_LIST == null) {
            return;
        }
        List<WeakReference<NetworkStateListener>> list = OBSERVER_LIST;
        synchronized (list) {
            Iterator<WeakReference<NetworkStateListener>> iterator = OBSERVER_LIST.iterator();
            while (iterator.hasNext()) {
                NetworkStateListener networkStateListener = (NetworkStateListener)iterator.next().get();
                if (networkStateListener == null) continue;
                networkStateListener.onNetworkStateChanged(NetworkDash.getLastState(), NetworkDash.getCurrState());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateNetworkState() {
        Class<NetworkDash> clazz = NetworkDash.class;
        synchronized (NetworkDash.class) {
            ConnectivityManager connectivityManager;
            try {
                connectivityManager = (ConnectivityManager)Global.getSystemService("connectivity");
                if (connectivityManager == null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return false;
                }
                connectivityManager = connectivityManager.getActiveNetworkInfo();
            }
            catch (Error error) {
                connectivityManager = null;
            }
            catch (Exception exception) {
                connectivityManager = null;
            }
            boolean bl2 = NetworkDash.setCurrState(NetworkState.fromNetworkInfo((NetworkInfo)connectivityManager));
            if (bl2) {
                NetworkDash.updateIMSIProvider();
                if (sMainHandler == null) {
                    sMainHandler = new Handler(Global.getMainLooper());
                }
                sMainHandler.post(new Runnable(){

                    @Override
                    public final void run() {
                        NetworkDash.notifyNetworkStateChange();
                    }
                });
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return bl2;
        }
    }

    public static NetworkState getCurrState() {
        return sCurrState;
    }

    protected static NetworkState getLastState() {
        return sLastState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean setCurrState(NetworkState networkState) {
        Class<NetworkDash> clazz = NetworkDash.class;
        synchronized (NetworkDash.class) {
            boolean bl2 = false;
            if (sCurrState == null) {
                sLastState = sCurrState;
                sCurrState = networkState;
                bl2 = true;
            }
            if (!sCurrState.equals(networkState)) {
                sLastState = sCurrState;
                sCurrState = networkState;
                bl2 = true;
            }
            if (bl2) {
                CustomLogcat.w("NetworkObserver", "LAST -> " + sLastState);
                CustomLogcat.w("NetworkObserver", "CURR -> " + sCurrState);
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return bl2;
        }
    }

    static {
        sImsiProvider = null;
        OBSERVER = new NetworkObserver(){
            private Thread mThread;
            private Object mWorkLock = new Object();
            private int sThreadIndex = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void onNetworkChanged() {
                if (this.mThread == null) {
                    this.startThread();
                }
                Object object = this.mWorkLock;
                synchronized (object) {
                    this.mWorkLock.notify();
                    return;
                }
            }

            public final void startThread() {
                this.mThread = new Thread("Milink-NetWorkDash-" + ++this.sThreadIndex){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        super.run();
                        while (true) {
                            try {
                                while (true) {
                                    Object object = mWorkLock;
                                    synchronized (object) {
                                        mWorkLock.wait();
                                    }
                                    NetworkDash.updateNetworkState();
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                MiLinkLog.e(this.getClass().getName(), interruptedException.toString());
                                continue;
                            }
                            break;
                        }
                    }
                };
                this.mThread.start();
            }
        };
        OBSERVER_LIST = new ArrayList<WeakReference<NetworkStateListener>>();
        NetworkDash.updateNetworkState();
        OBSERVER.startListen();
    }
}

