/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.base.os.info;

import android.net.NetworkInfo;
import android.util.Base64;
import com.mi.milink.sdk.base.os.info.AccessPoint;
import com.mi.milink.sdk.base.os.info.NetworkType;

public class NetworkState {
    private static final NetworkState NONE = new NetworkState(false, null, AccessPoint.NONE, NetworkType.NONE);
    private static final int NETWORK_TYPE_WIFI = -1;
    private static final int NETWORK_TYPE_UNKNOWN = 0;
    private static final int NETWORK_TYPE_GPRS = 1;
    private static final int NETWORK_TYPE_EDGE = 2;
    private static final int NETWORK_TYPE_UMTS = 3;
    private static final int NETWORK_TYPE_CDMA = 4;
    private static final int NETWORK_TYPE_EVDO_0 = 5;
    private static final int NETWORK_TYPE_EVDO_A = 6;
    private static final int NETWORK_TYPE_1xRTT = 7;
    private static final int NETWORK_TYPE_HSDPA = 8;
    private static final int NETWORK_TYPE_HSUPA = 9;
    private static final int NETWORK_TYPE_HSPA = 10;
    private static final int NETWORK_TYPE_IDEN = 11;
    private static final int NETWORK_TYPE_EVDO_B = 12;
    private static final int NETWORK_TYPE_LTE = 13;
    private static final int NETWORK_TYPE_EHRPD = 14;
    private static final int NETWORK_TYPE_HSPAP = 15;
    private static final int NETWORK_CLASS_UNKNOWN = 0;
    private static final int NETWORK_CLASS_2_G = 1;
    private static final int NETWORK_CLASS_3_G = 2;
    private static final int NETWORK_CLASS_4_G = 3;
    private boolean connected = false;
    private boolean available = false;
    private String apnName = null;
    private int apnType = -1;
    private NetworkType type = NetworkType.NONE;
    private AccessPoint accessPoint = AccessPoint.NONE;
    private NetworkInfo moreInfo;

    public static NetworkState fromNetworkInfo(NetworkInfo networkInfo) {
        if (networkInfo == null) {
            return NONE;
        }
        NetworkState networkState = new NetworkState();
        networkState.setAvailable(networkInfo.isAvailable());
        networkState.setConnected(networkInfo.isConnected());
        networkState.setApnName(networkInfo.getExtraInfo());
        NetworkState networkState2 = networkState;
        networkState2.setAccessPoint(AccessPoint.forName(networkState2.getApnName()));
        switch (networkInfo.getType()) {
            case 1: {
                networkState.setType(NetworkType.WIFI);
                networkState.setApnType(-1);
                break;
            }
            case 9: {
                networkState.setType(NetworkType.ETHERNET);
                networkState.setApnType(-1);
                break;
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                networkState.setType(NetworkState.is3GMobileType(networkInfo.getSubtype()) ? NetworkType.MOBILE_3G : NetworkType.MOBILE_2G);
                networkState.setApnType(networkInfo.getSubtype());
                break;
            }
            default: {
                networkState.setType(NetworkType.OTHERS);
                networkState.setApnType(-1);
            }
        }
        networkState.setMoreInfo(networkInfo);
        return networkState;
    }

    private NetworkState(boolean bl2, String string2, AccessPoint accessPoint, NetworkType networkType) {
        this.setConnected(bl2);
        this.setApnName(string2);
        this.setAccessPoint(accessPoint);
        this.setType(networkType);
    }

    private NetworkState() {
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof NetworkState) {
            return ((NetworkState)object).isConnected() == this.isConnected() && ((NetworkState)object).getType().equals((Object)this.getType()) && ((NetworkState)object).getApnName().equals(this.getApnName());
        }
        return false;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean bl2) {
        this.available = bl2;
    }

    public void setConnected(boolean bl2) {
        this.connected = bl2;
    }

    public String getApnName() {
        if (this.apnName == null) {
            return "";
        }
        return this.apnName;
    }

    public void setApnName(String string2) {
        this.apnName = string2;
    }

    public int getApnType() {
        return this.apnType;
    }

    public void setApnType(int n2) {
        this.apnType = n2;
    }

    public NetworkType getType() {
        return this.type;
    }

    public void setType(NetworkType networkType) {
        this.type = networkType;
    }

    public AccessPoint getAccessPoint() {
        return this.accessPoint;
    }

    public void setAccessPoint(AccessPoint accessPoint) {
        this.accessPoint = accessPoint;
    }

    private static boolean is3GMobileType(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return false;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    private static boolean is4GMobileType(int n2) {
        return NetworkState.getNetworkClass(n2) == 3;
    }

    private static int getNetworkClass(int n2) {
        switch (n2) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return 1;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return 2;
            }
            case 13: {
                return 3;
            }
        }
        return 0;
    }

    public NetworkInfo getMoreInfo() {
        return this.moreInfo;
    }

    public void setMoreInfo(NetworkInfo networkInfo) {
        this.moreInfo = networkInfo;
    }

    public String toString() {
        if (this.apnName != null) {
            return "NetworkState [connected=" + this.connected + ", apnName=" + new String(Base64.encode((byte[])this.apnName.getBytes(), (int)0)) + ", type=" + (Object)((Object)this.type) + ", accessPoint=" + (Object)((Object)this.accessPoint) + "]";
        }
        return "NetworkState [connected=" + this.connected + ", apnName=" + this.apnName + ", type=" + (Object)((Object)this.type) + ", accessPoint=" + (Object)((Object)this.accessPoint) + "]";
    }
}

