/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.base.os.info;

import java.util.HashMap;
import java.util.Map;

public enum ServiceProvider {
    NONE("N/A"),
    NEVER_HEARD("Unknown"),
    CHINA_MOBILE("China Mobile"),
    CHINA_UNICOM("China Unicom"),
    CHINA_TELECOM("China Telecom");

    private static final Map<String, ServiceProvider> IMSI_PROVIDER_MAP;
    private String name;

    public static ServiceProvider fromIMSI(String object) {
        if (object == null) {
            return NONE;
        }
        if (object.length() < 5) {
            return NONE;
        }
        if ((object = IMSI_PROVIDER_MAP.get(object.substring(0, 5))) != null) {
            return object;
        }
        return NEVER_HEARD;
    }

    private ServiceProvider(String string3) {
        this.setName(string3);
    }

    public final String getName() {
        return this.name;
    }

    private void setName(String string2) {
        this.name = string2;
    }

    public final String toString() {
        return this.getName();
    }

    static {
        IMSI_PROVIDER_MAP = new HashMap<String, ServiceProvider>();
        IMSI_PROVIDER_MAP.put("46000", CHINA_MOBILE);
        IMSI_PROVIDER_MAP.put("46002", CHINA_MOBILE);
        IMSI_PROVIDER_MAP.put("46007", CHINA_MOBILE);
        IMSI_PROVIDER_MAP.put("46003", CHINA_TELECOM);
        IMSI_PROVIDER_MAP.put("46005", CHINA_TELECOM);
        IMSI_PROVIDER_MAP.put("46001", CHINA_UNICOM);
        IMSI_PROVIDER_MAP.put("46006", CHINA_UNICOM);
        IMSI_PROVIDER_MAP.put("46020", CHINA_MOBILE);
    }
}

