/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.base.os.info;

import android.os.StatFs;
import java.io.File;

public class StorageInfo {
    private File rootPath;
    private long totalSize;
    private long availableSize;

    public File getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(File file) {
        this.rootPath = file;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(long l2) {
        this.totalSize = l2;
    }

    public long getAvailableSize() {
        return this.availableSize;
    }

    public void setAvailableSize(long l2) {
        this.availableSize = l2;
    }

    public static StorageInfo fromFile(File file) {
        StorageInfo storageInfo = new StorageInfo();
        storageInfo.setRootPath(file);
        try {
            file = new StatFs(file.getAbsolutePath());
            long l2 = file.getBlockSize();
            long l3 = file.getBlockCount();
            long l4 = file.getAvailableBlocks();
            storageInfo.setTotalSize(l3 * l2);
            storageInfo.setAvailableSize(l4 * l2);
        }
        catch (Exception exception) {
            storageInfo.setAvailableSize(0L);
            storageInfo.setTotalSize(0L);
        }
        return storageInfo;
    }

    public String toString() {
        return String.format("[%s : %d / %d]", this.rootPath == null ? "NULL" : this.rootPath.getAbsolutePath(), this.getAvailableSize(), this.getTotalSize());
    }
}

