/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.base.os.timer;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.config.HeartBeatManager;
import com.mi.milink.sdk.debug.MiLinkLog;

public class AlarmClockService {
    private static final String TAG = "AlarmClockService";
    private static boolean sStop = true;
    static PendingIntent pendingIntent = null;
    private static long mNextPingTs = 0L;

    private static void setExact(AlarmManager alarmManager, long l2, PendingIntent pendingIntent) {
        Class<AlarmManager> clazz = AlarmManager.class;
        try {
            clazz.getMethod("setExact", Integer.TYPE, Long.TYPE, PendingIntent.class).invoke((Object)alarmManager, 0, l2, pendingIntent);
            return;
        }
        catch (Exception exception) {
            MiLinkLog.e(TAG, exception);
            return;
        }
    }

    public static boolean start(long l2) {
        MiLinkLog.e("HeartBeat", "\u5fc3\u8df3\u5f00\u59cb \u65f6\u957f \uff1a ".concat(String.valueOf(l2)));
        if (Global.isSuicideEnable()) {
            return false;
        }
        sStop = false;
        try {
            Intent intent = new Intent("com.milink.sdk.heartbeat");
            intent.setPackage(Global.getPackageName());
            pendingIntent = PendingIntent.getBroadcast((Context)Global.getContext(), (int)987, (Intent)intent, (int)0x8000000);
            intent = (AlarmManager)Global.getSystemService("alarm");
            long l3 = AlarmClockService.getNextPing(l2);
            if (Build.VERSION.SDK_INT >= 23) {
                intent.setAlarmClock(new AlarmManager.AlarmClockInfo(l3, pendingIntent), pendingIntent);
            } else if (Build.VERSION.SDK_INT >= 19) {
                AlarmClockService.setExact((AlarmManager)intent, l3, pendingIntent);
            } else {
                intent.set(0, l3, pendingIntent);
            }
            return true;
        }
        catch (Exception exception) {
            MiLinkLog.e("HeartBeat", "\u5fc3\u8df3crash : " + exception.getMessage());
            return false;
        }
    }

    public static boolean start() {
        return AlarmClockService.start(HeartBeatManager.getInstance().getHeartBeatInterval());
    }

    public static boolean startIfNeed() {
        if (sStop) {
            return AlarmClockService.start(HeartBeatManager.getInstance().getHeartBeatInterval());
        }
        return false;
    }

    public static boolean stop() {
        sStop = true;
        try {
            AlarmManager alarmManager = (AlarmManager)Global.getSystemService("alarm");
            if (pendingIntent != null) {
                alarmManager.cancel(pendingIntent);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void resetNextPing() {
        mNextPingTs = 0L;
    }

    private static long getNextPing(long l2) {
        MiLinkLog.w("MiLinkAlarm", "internal=" + l2 + ",Ts = " + mNextPingTs);
        mNextPingTs = System.currentTimeMillis() + l2;
        MiLinkLog.w("MiLinkAlarm", "next Ts = " + mNextPingTs);
        return mNextPingTs;
    }
}

