/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.client;

import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.mi.milink.sdk.account.ChannelAccount;
import com.mi.milink.sdk.account.manager.MiChannelAccountManager;
import com.mi.milink.sdk.aidl.PacketData;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.base.MessageTask;
import com.mi.milink.sdk.client.IEventListener;
import com.mi.milink.sdk.client.IPacketListener;
import com.mi.milink.sdk.client.MiLinkException;
import com.mi.milink.sdk.client.MiLinkObserver;
import com.mi.milink.sdk.client.MilinkBaseClient;
import com.mi.milink.sdk.client.ipc.ClientLog;
import com.mi.milink.sdk.config.ConfigManager;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.debug.MiLinkMonitor;
import com.mi.milink.sdk.event.BaseMilinkEvent;
import com.mi.milink.sdk.event.MiLinkEventForSimpleChannel;
import com.mi.milink.sdk.session.common.ResponseListener;
import com.mi.milink.sdk.session.persistent.MnsPacketDispatcher;
import com.mi.milink.sdk.session.persistent.UploadLogManager;
import com.mi.milink.sdk.session.simplechannel.SessionManagerForSimpleChannel;
import com.mi.milink.sdk.util.StatisticsLog;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class MiLinkChannelClient
extends MilinkBaseClient {
    private final String TAG = "MiLinkChannelClient";
    private MiLinkObserver mMiLinkObserver;
    private IEventListener mEventCallback;
    boolean isInit = false;
    private SessionManagerForSimpleChannel sessionManager;
    private MiChannelAccountManager accountManager;
    private EventBus channelEventBus;
    private int appId;

    public MiLinkChannelClient() {
        this.appId = Global.getClientAppInfo().getAppId();
        this.channelEventBus = new EventBus();
        if (!EventBus.getDefault().isRegistered(this)) {
            EventBus.getDefault().register(this);
        }
        this.init();
    }

    public MiLinkChannelClient(int n2) {
        this.appId = n2;
        this.channelEventBus = new EventBus();
        this.init();
    }

    private void init() {
        MiLinkLog.w("MiLinkChannelClient", "MiLinkChannelClient no ipc build,host version=" + Global.getClientAppInfo().getVersionCode());
    }

    public void setMilinkStateObserver(MiLinkObserver miLinkObserver) {
        this.mMiLinkObserver = miLinkObserver;
    }

    public void setPacketListener(IPacketListener iPacketListener) {
        MnsPacketDispatcher.getInstance().setCallback(iPacketListener);
    }

    public void setEventListener(IEventListener iEventListener) {
        this.mEventCallback = iEventListener;
    }

    public void setDispatchPacketDelayMillis(int n2) {
        MnsPacketDispatcher.getInstance().setDispatchPacketDelayTime(n2);
    }

    public synchronized boolean uploadMilinkLog(boolean bl2) {
        try {
            MiChannelAccountManager miChannelAccountManager = new MiChannelAccountManager(null, this.appId);
            miChannelAccountManager.setUserId("" + System.currentTimeMillis());
            MiLinkLog.d("MiLinkChannelClient", "temp userid for upload log : " + miChannelAccountManager.getUserId());
            return UploadLogManager.uploadMilinkLog(null, miChannelAccountManager.getCurrentAccount(), bl2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public synchronized void initUseChannelMode() {
        StatisticsLog.begin("init");
        if (!this.channelEventBus.isRegistered(this)) {
            this.channelEventBus.register(this);
        }
        MiLinkLog.w("MiLinkChannelClient", "init, milinkversion=" + Global.getMiLinkVersion() + "_" + Global.getMiLinkSubVersion());
        long l2 = SystemClock.elapsedRealtime();
        if (this.accountManager == null) {
            MiLinkLog.d("MiLinkChannelClient", "initUseChannelMode accountManager==null");
            this.accountManager = new MiChannelAccountManager(this.channelEventBus, this.appId);
        }
        long l3 = SystemClock.elapsedRealtime();
        Log.e((String)"MiLinkChannelClient", (String)String.format("init 1 \u6d88\u8017\u65f6\u95f4\uff1a%s", l3 - l2));
        if (this.sessionManager == null) {
            MiLinkLog.d("MiLinkChannelClient", "initUseChannelMode sessionManager==null");
            this.sessionManager = new SessionManagerForSimpleChannel(this.channelEventBus, this.accountManager, this.appId);
        }
        if (!this.channelEventBus.isRegistered(this.sessionManager)) {
            this.channelEventBus.register(this.sessionManager);
        }
        l2 = SystemClock.elapsedRealtime();
        Log.e((String)"MiLinkChannelClient", (String)String.format("init 2 \u6d88\u8017\u65f6\u95f4\uff1a%s", l2 - l3));
        this.sessionManager.initApp();
        this.accountManager.initUserChannelMode();
        this.isInit = true;
        l3 = SystemClock.elapsedRealtime();
        Log.e((String)"MiLinkChannelClient", (String)String.format("init 3 \u6d88\u8017\u65f6\u95f4\uff1a%s", l3 - l2));
        StatisticsLog.end("init");
    }

    public static void setUploadTime(int n2) {
        ConfigManager.getInstance().setUploadTime(n2);
    }

    public static long getAnonymousAccountId() {
        try {
            return Long.parseLong(ChannelAccount.getInstance().getUserId());
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public synchronized void setKeepAliveTime(int n2) {
        if (this.accountManager != null) {
            this.accountManager.setKeepAliveTime(n2);
        }
    }

    public synchronized void sendAsyncWithResponse(PacketData packetData, int n2, ResponseListener responseListener) {
        if (!this.isInit) {
            this.initUseChannelMode();
        }
        if (this.sessionManager != null) {
            this.sessionManager.sendData(packetData, n2, responseListener);
        }
    }

    public synchronized void sendAsync(PacketData packetData, int n2) {
        if (!this.isInit) {
            this.initUseChannelMode();
        }
        if (this.sessionManager != null) {
            this.sessionManager.sendData(packetData, n2, null);
        }
    }

    public synchronized void sendAsync(PacketData packetData) {
        if (!this.isInit) {
            this.initUseChannelMode();
        }
        if (this.sessionManager != null) {
            this.sessionManager.sendData(packetData, 0, null);
        }
    }

    public synchronized void internalClose() {
        if (this.sessionManager != null) {
            this.sessionManager.close();
        }
    }

    public synchronized void logoff() {
        if (this.sessionManager == null) {
            MiLinkLog.i("MiLinkChannelClient", "--------> channel logoff but session manager is null");
            return;
        }
        MiLinkLog.i("MiLinkChannelClient", "--------> channel logoff");
        if (this.accountManager != null) {
            MiLinkLog.i("MiLinkChannelClient", "--------> channel  accountManager logoff");
            this.accountManager.userLogoff();
        }
        if (this.channelEventBus.isRegistered(this)) {
            this.channelEventBus.unregister(this);
        }
        if (this.channelEventBus.isRegistered(this.sessionManager)) {
            this.channelEventBus.unregister(this.sessionManager);
        }
        if (this.sessionManager != null) {
            MiLinkLog.i("MiLinkChannelClient", "--------> channel  sessionManager logoff");
            this.sessionManager.logoff();
        }
        this.accountManager = null;
        this.sessionManager = null;
        if (EventBus.getDefault().isRegistered(this)) {
            EventBus.getDefault().unregister(this);
        }
    }

    public void forceReconnect() {
        MiLinkLog.i("MiLinkChannelClient", "[channel]forceReconnet begin");
        if (this.sessionManager != null && this.sessionManager.getSessionState() != 0) {
            MiLinkLog.i("MiLinkChannelClient", "[channel]milink is in connection, need not reconnect!!!");
            return;
        }
        if (this.sessionManager != null) {
            this.sessionManager.logoff();
            this.sessionManager = null;
        }
        MiLinkLog.i("MiLinkChannelClient", "[channel]forceReconnet init");
        this.initUseChannelMode();
    }

    public void setMiLinkLogLevel(final int n2) {
        new Thread("Milink-ChannelClient"){

            @Override
            public void run() {
                MiLinkLog.setLogcatTraceLevel(n2);
                MiLinkLog.setFileTraceLevel(n2);
                ClientLog.setLogcatTraceLevel(n2);
                ClientLog.setFileTraceLevel(n2);
            }
        }.start();
    }

    public int getMiLinkConnectState() {
        return this.sessionManager.getSessionState();
    }

    public synchronized boolean isMiLinkLogined() {
        try {
            if (this.sessionManager != null) {
                MiLinkLog.i("MiLinkChannelClient", "isMiLinkLogined:" + this.sessionManager.isMilinkLogined());
                return this.sessionManager.isMilinkLogined();
            }
            MiLinkLog.i("MiLinkChannelClient", "false isMiLinkLogined");
        }
        catch (Exception exception) {}
        return false;
    }

    public PacketData sendSyncClient(PacketData object, int n2) throws MiLinkException {
        if (object == null) {
            throw new MiLinkException(100001, "package is null");
        }
        if (TextUtils.isEmpty((CharSequence)((PacketData)object).getCommand())) {
            throw new MiLinkException(100002, "cmd is null");
        }
        object = new MessageTask((PacketData)object, n2){
            final /* synthetic */ PacketData val$packetData;
            final /* synthetic */ int val$timeOut;
            {
                this.val$packetData = packetData;
                this.val$timeOut = n2;
            }

            @Override
            public void doSendWork() {
                MiLinkChannelClient.this.sendAsyncWithResponse(this.val$packetData, this.val$timeOut, new ResponseListener(){

                    @Override
                    public void onDataSendSuccess(int n2, PacketData packetData) {
                        if (!this.isCancelled() && !this.isDone()) {
                            this.set(packetData);
                            return;
                        }
                        this.setException(new MiLinkException(533, "not net work"));
                    }

                    @Override
                    public void onDataSendFailed(int n2, String string2) {
                        this.setException(new MiLinkException(n2, string2));
                    }
                });
            }
        }.start();
        try {
            return ((MessageTask)object).getResult(n2 + 5000, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            object = interruptedException;
            interruptedException.printStackTrace();
            throw new MiLinkException(((Throwable)object).getMessage());
        }
        catch (ExecutionException executionException) {
            object = executionException;
            executionException.printStackTrace();
            throw new MiLinkException(((Throwable)object).getMessage());
        }
        catch (TimeoutException timeoutException) {
            object = timeoutException;
            timeoutException.printStackTrace();
            throw new MiLinkException(((Throwable)object).getMessage());
        }
    }

    public PacketData sendDataBySimpleChannel(final PacketData packetData, final int n2) {
        long l2 = SystemClock.elapsedRealtime();
        if (!this.isInit) {
            this.initUseChannelMode();
        }
        if (packetData == null) {
            throw new IllegalArgumentException(" packet is null");
        }
        if (TextUtils.isEmpty((CharSequence)packetData.getCommand())) {
            throw new IllegalArgumentException("Packet's command is null");
        }
        Object object = new MessageTask(){

            @Override
            public void doSendWork() {
                MiLinkChannelClient.this.sendAsyncWithResponse(packetData, n2, new ResponseListener(){

                    @Override
                    public void onDataSendSuccess(int n2, PacketData packetData) {
                        if (!this.isCancelled() && !this.isDone()) {
                            if (n2 == 0 && packetData != null) {
                                this.set(packetData);
                                return;
                            }
                            this.setException(new MiLinkException(n2, "server return error"));
                            return;
                        }
                        this.setException(new CancellationException("canceled packet"));
                    }

                    @Override
                    public void onDataSendFailed(int n2, String string2) {
                        if (!this.isCancelled() && !this.isDone()) {
                            this.setException(new MiLinkException(n2, string2));
                            return;
                        }
                        this.setException(new CancellationException("canceled packet"));
                    }
                });
            }
        }.start();
        try {
            PacketData packetData2 = ((MessageTask)object).getChannelResult(n2 + 5000, TimeUnit.MILLISECONDS);
            return packetData2;
        }
        catch (InterruptedException interruptedException) {
            MiLinkLog.e("MiLinkChannelClient", "task InterruptedException", interruptedException);
        }
        catch (ExecutionException executionException) {
            MiLinkLog.e("MiLinkChannelClient", "send packet callback command: " + packetData.getCommand());
            object = executionException.getCause();
            if (object != null && object instanceof MiLinkException) {
                MiLinkLog.e("MiLinkChannelClient", "", (Throwable)object);
            } else {
                MiLinkLog.e("MiLinkChannelClient", "task ExecutionException", executionException);
            }
            MiLinkMonitor.getInstance().trace("", 0, packetData.getCommand(), 557, l2, SystemClock.elapsedRealtime(), 0, 0, 0);
        }
        catch (CancellationException cancellationException) {
            MiLinkLog.e("MiLinkChannelClient", "task CancellationException", cancellationException);
        }
        catch (TimeoutException timeoutException) {
            MiLinkLog.e("MiLinkChannelClient", "task TimeoutException, detailName=" + timeoutException.getClass().getName());
            packetData.setBusiCode(555);
            if (this.sessionManager != null && this.sessionManager.getSessionState() == 1) {
                this.sessionManager.setState(0);
            }
            MiLinkMonitor.getInstance().trace("", 0, packetData.getCommand(), 555, l2, SystemClock.elapsedRealtime(), 0, 0, 0);
            object = packetData;
            return object;
        }
        catch (Exception exception) {
            MiLinkLog.e("MiLinkChannelClient", "task Exception, detailName=" + exception.getClass().getName() + ", error message " + exception);
            packetData.setBusiCode(519);
            MiLinkMonitor.getInstance().trace("", 0, packetData.getCommand(), 519, l2, SystemClock.elapsedRealtime(), 0, 0, 0);
            if (this.sessionManager != null && this.sessionManager.getSessionState() == 1) {
                this.sessionManager.setState(0);
            }
            object = packetData;
            return object;
        }
        finally {
            MiLinkLog.e("MiLinkChannelClient", "send packet callback command: " + packetData.getCommand());
        }
        if (this.sessionManager != null && this.sessionManager.getSessionState() == 1) {
            this.sessionManager.setState(0);
        }
        MiLinkLog.e("MiLinkChannelClient", "task unknown state");
        packetData.setBusiCode(520);
        MiLinkMonitor.getInstance().trace("", 0, packetData.getCommand(), 520, l2, SystemClock.elapsedRealtime(), 0, 0, 0);
        return packetData;
    }

    protected void onSessionStateChanged(int n2, int n3) {
        if (this.mMiLinkObserver != null) {
            this.mMiLinkObserver.onServerStateUpdate(n2, n3);
        }
    }

    protected void onLoginStateChanged(int n2) {
        if (this.mMiLinkObserver != null) {
            this.mMiLinkObserver.onLoginStateUpdate(n2);
        }
    }

    protected void onEventGetServiceToken() {
        if (this.mEventCallback != null) {
            this.mEventCallback.onEventGetServiceToken();
        }
    }

    protected void onEventInvilidPacket() {
        if (this.mEventCallback != null) {
            this.mEventCallback.onEventInvalidPacket();
        }
    }

    @Subscribe
    public void onEvent(MiLinkEventForSimpleChannel.SessionManagerStateChangeEvent sessionManagerStateChangeEvent) {
        MiLinkLog.e("MiLinkReceive", "milinkChannelOnEevent " + (Object)((Object)sessionManagerStateChangeEvent.mEventType));
        switch (sessionManagerStateChangeEvent.mEventType) {
            case LoginStateChange: {
                this.onLoginStateChanged(sessionManagerStateChangeEvent.mNewState);
                return;
            }
            case SessionStateChange: {
                this.onSessionStateChanged(sessionManagerStateChangeEvent.mOldState, sessionManagerStateChangeEvent.mNewState);
            }
        }
    }

    @Subscribe
    public void onEvent(MiLinkEventForSimpleChannel.SessionManagerNotificationEvent sessionManagerNotificationEvent) {
        switch (sessionManagerNotificationEvent.mEventType) {
            case GetServiceToken: {
                this.onEventGetServiceToken();
                return;
            }
            case RecvInvalidPacket: {
                this.onEventInvilidPacket();
            }
        }
    }

    @Subscribe
    public void onEvent(BaseMilinkEvent.ServiceQualityEvent serviceQualityEvent) {
        if (serviceQualityEvent == null) {
            return;
        }
        if (serviceQualityEvent.qualityBean == null) {
            return;
        }
        if (this.report == null) {
            return;
        }
        this.report.ServiceQualityReportCallback(serviceQualityEvent.qualityBean);
    }
}

