/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.client;

import android.text.TextUtils;
import com.mi.milink.sdk.account.AnonymousAccount;
import com.mi.milink.sdk.account.manager.MiAccountManager;
import com.mi.milink.sdk.aidl.PacketData;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.base.MessageTask;
import com.mi.milink.sdk.base.os.timer.AlarmClockService;
import com.mi.milink.sdk.client.IEventListener;
import com.mi.milink.sdk.client.IPacketListener;
import com.mi.milink.sdk.client.IPushPacketListener;
import com.mi.milink.sdk.client.ISinglePacketListener;
import com.mi.milink.sdk.client.MiLinkException;
import com.mi.milink.sdk.client.MiLinkObserver;
import com.mi.milink.sdk.client.MilinkBaseClient;
import com.mi.milink.sdk.client.SendPacketListener;
import com.mi.milink.sdk.client.StateObserver;
import com.mi.milink.sdk.client.ipc.ClientLog;
import com.mi.milink.sdk.config.ConfigManager;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.event.BaseMilinkEvent;
import com.mi.milink.sdk.event.MiLinkEvent;
import com.mi.milink.sdk.proto.PushPacketProto;
import com.mi.milink.sdk.service.MiLinkExceptionHandler;
import com.mi.milink.sdk.session.common.ResponseListener;
import com.mi.milink.sdk.session.persistent.MnsPacketDispatcher;
import com.mi.milink.sdk.session.persistent.SessionManager;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class MiLinkClient
extends MilinkBaseClient {
    private static final String TAG = "MiLinkClient";
    private static MiLinkClient INSTANCE;
    private MiLinkObserver mMiLinkObserver;
    private StateObserver mStateObserver;
    private IEventListener mEventCallback;
    private boolean mMiPushSwitch = false;

    private MiLinkClient() {
        EventBus.getDefault().register(this);
        Thread.setDefaultUncaughtExceptionHandler(new MiLinkExceptionHandler());
        MiLinkLog.w(TAG, "MiLinkClient no ipc build");
        AlarmClockService.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MiLinkClient getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<MiLinkClient> clazz = MiLinkClient.class;
        synchronized (MiLinkClient.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new MiLinkClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static void setMilinkStateObserver(MiLinkObserver miLinkObserver) {
        MiLinkClient.getInstance().mMiLinkObserver = miLinkObserver;
    }

    public static void setStateObserver(StateObserver stateObserver) {
        MiLinkClient.getInstance().mStateObserver = stateObserver;
    }

    public static void setPacketListener(IPacketListener iPacketListener) {
        MnsPacketDispatcher.getInstance().setCallback(iPacketListener);
    }

    public static void setPushPacketListener(IPushPacketListener iPushPacketListener) {
        MnsPacketDispatcher.getInstance().setPushCallback(iPushPacketListener);
    }

    public static void setSinglePacketListener(ISinglePacketListener iSinglePacketListener) {
        MnsPacketDispatcher.getInstance().setSingleCallback(iSinglePacketListener);
    }

    public static void setEventListener(IEventListener iEventListener) {
        MiLinkClient.getInstance().mEventCallback = iEventListener;
    }

    public static void setDispatchPacketDelayMillis(int n2) {
        MnsPacketDispatcher.getInstance().setDispatchPacketDelayTime(n2);
    }

    public static void initUseAnonymousMode() {
        SessionManager.getInstance().initApp();
        MiAccountManager.getInstance().initUseAnonymousMode();
    }

    public static void setAllowAnonymousLoginSwitch(boolean bl2) {
        MiAccountManager.getInstance().setAnonymousModeSwitch(bl2);
    }

    public static void init(String string2, String string3, String string4, byte[] byArray, boolean bl2) {
        MiLinkLog.w(TAG, "init, milinkversion=" + Global.getMiLinkVersion() + "_" + Global.getMiLinkSubVersion());
        MiLinkLog.v(TAG, "init service,passportInit=" + bl2 + " ,app is user id " + string2 + "serviceToken=" + string3 + ", security=" + string4);
        MiAccountManager.getInstance().setUserId(string2);
        ConfigManager.getInstance().loadSuid();
        SessionManager.getInstance().initApp();
        MiAccountManager.getInstance().login(string2, string3, string4, byArray, bl2);
    }

    public static synchronized void close() {
        SessionManager.getInstance().close();
    }

    public static void init(String string2, String string3, String string4, byte[] byArray, boolean bl2, boolean bl3) {
        MiLinkLog.w(TAG, "init, milinkversion=" + Global.getMiLinkVersion() + "_" + Global.getMiLinkSubVersion());
        MiLinkLog.v(TAG, "init service,passportInit=" + bl2 + " ,app  is serviceToken=" + string3 + ",security=" + string4);
        MiAccountManager.getInstance().setUserId(string2);
        ConfigManager.getInstance().loadSuid();
        SessionManager.getInstance().initApp();
        MiAccountManager.getInstance().login(string2, string3, string4, byArray, bl2);
    }

    public static void sendAsync(PacketData packetData, int n2, final SendPacketListener sendPacketListener) {
        SessionManager.getInstance().sendData(packetData, n2, new ResponseListener(){

            @Override
            public final void onDataSendSuccess(int n2, PacketData packetData) {
                sendPacketListener.onResponse(packetData);
            }

            @Override
            public final void onDataSendFailed(int n2, String string2) {
                sendPacketListener.onFailed(n2, string2);
            }
        });
    }

    public static void sendAsync(PacketData packetData, int n2, ResponseListener responseListener) {
        SessionManager.getInstance().sendData(packetData, n2, responseListener);
    }

    public static void sendAsync(PacketData packetData, int n2) {
        SessionManager.getInstance().sendData(packetData, n2, null);
    }

    public static void sendAsync(PacketData packetData) {
        SessionManager.getInstance().sendData(packetData, 0, null);
    }

    public static PacketData sendSyncClient(PacketData object, int n2) throws MiLinkException {
        if (object == null) {
            throw new MiLinkException(100001, "package is null");
        }
        if (TextUtils.isEmpty((CharSequence)((PacketData)object).getCommand())) {
            throw new MiLinkException(100002, "cmd is null");
        }
        object = new MessageTask((PacketData)object, n2){
            final /* synthetic */ PacketData val$packetData;
            final /* synthetic */ int val$timeOut;
            {
                this.val$packetData = packetData;
                this.val$timeOut = n2;
            }

            @Override
            public final void doSendWork() {
                MiLinkClient.sendAsync(this.val$packetData, this.val$timeOut, new SendPacketListener(){

                    @Override
                    public void onResponse(PacketData packetData) {
                        if (!this.isCancelled() && !this.isDone()) {
                            this.set(packetData);
                            return;
                        }
                        this.setException(new MiLinkException(533, "not net work"));
                    }

                    @Override
                    public void onFailed(int n2, String string2) {
                        this.setException(new MiLinkException(n2, string2));
                    }
                });
            }
        }.start();
        try {
            return ((MessageTask)object).getResult(n2 + 5000, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            object = interruptedException;
            interruptedException.printStackTrace();
            throw new MiLinkException(((Throwable)object).getMessage());
        }
        catch (ExecutionException executionException) {
            throw new MiLinkException(executionException.getMessage());
        }
        catch (TimeoutException timeoutException) {
            object = timeoutException;
            timeoutException.printStackTrace();
            throw new MiLinkException(((Throwable)object).getMessage());
        }
    }

    public static PacketData sendSync(PacketData object, int n2) {
        if (object == null) {
            throw new IllegalArgumentException(" packet is null");
        }
        if (TextUtils.isEmpty((CharSequence)((PacketData)object).getCommand())) {
            throw new IllegalArgumentException("Packet's command is null");
        }
        object = new MessageTask((PacketData)object, n2){
            final /* synthetic */ PacketData val$packet;
            final /* synthetic */ int val$timeout;
            {
                this.val$packet = packetData;
                this.val$timeout = n2;
            }

            @Override
            public final void doSendWork() {
                MiLinkClient.sendAsync(this.val$packet, this.val$timeout, new SendPacketListener(){

                    @Override
                    public void onResponse(PacketData packetData) {
                        if (!this.isCancelled() && !this.isDone()) {
                            this.set(packetData);
                            return;
                        }
                        this.setException(new MiLinkException(533, "not net work"));
                    }

                    @Override
                    public void onFailed(int n2, String string2) {
                        if (!this.isCancelled() && !this.isDone()) {
                            this.setException(new MiLinkException(n2, string2));
                        }
                    }
                });
            }
        }.start();
        try {
            return ((MessageTask)object).getResult(n2 + 5000, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            MiLinkLog.e(TAG, "task InterruptedException", interruptedException);
        }
        catch (ExecutionException executionException) {
            object = executionException;
            Throwable throwable = executionException.getCause();
            if (throwable != null && throwable instanceof MiLinkException) {
                MiLinkLog.e(TAG, "milink exception", throwable);
            } else {
                MiLinkLog.e(TAG, "task ExecutionException", (Throwable)object);
            }
        }
        catch (CancellationException cancellationException) {
            MiLinkLog.e(TAG, "task CancellationException", cancellationException);
        }
        catch (TimeoutException timeoutException) {
            MiLinkLog.e(TAG, "task TimeoutException, detailName=" + timeoutException.getClass().getName());
        }
        catch (Exception exception) {
            MiLinkLog.e(TAG, "task exception, detailName=" + exception.getClass().getName(), exception);
        }
        return null;
    }

    public static void logoff() {
        MiLinkLog.i(TAG, "logoff");
        if (SessionManager.getInstance() != null) {
            SessionManager.getInstance().logoff();
        }
        MiAccountManager.getInstance().userLogoff();
    }

    public static void forceReconnect() {
        MiLinkLog.i(TAG, "forceReconnet");
        EventBus.getDefault().post(new MiLinkEvent.ClientActionEvent(MiLinkEvent.ClientActionEvent.EventType.ClientForceOpen));
    }

    public static void setMilinkLogLevel(int n2) {
        MiLinkLog.setLogcatTraceLevel(n2);
        MiLinkLog.setFileTraceLevel(n2);
        ClientLog.setLogcatTraceLevel(n2);
        ClientLog.setFileTraceLevel(n2);
    }

    public static int getMiLinkConnectState() {
        return SessionManager.getInstance().getSessionState();
    }

    public static boolean isMiLinkLogined() {
        MiLinkLog.i(TAG, "isMiLinkLogined");
        return SessionManager.getInstance().isMiLinkLogined();
    }

    public static boolean enableConnectModeManual(boolean bl2) {
        return SessionManager.getInstance().enableConnectionManualMode(bl2);
    }

    public static void setIpAndPortInManualMode(String string2, int n2) {
        SessionManager.getInstance().setIpAndPortInManualMode(string2, n2);
    }

    public static long getAnonymousAccountId() {
        try {
            return Long.parseLong(AnonymousAccount.getInstance().getUserId());
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static boolean setTimeoutMultiply(float f2) {
        if (f2 < 1.0f || f2 > 10.0f) {
            ClientLog.e(TAG, "illegal timeoutMultiply\uff0ctimeoutMultiply between 1-10");
            return false;
        }
        ConfigManager.getInstance().setTimeoutMultiply(f2);
        return true;
    }

    public static void setLanguage(String string2) {
        Global.getClientAppInfo().setLanguageCode(string2);
    }

    protected void onSessionStateChanged(int n2, int n3) {
        if (this.mMiLinkObserver != null) {
            this.mMiLinkObserver.onServerStateUpdate(n2, n3);
        }
        if (this.mStateObserver != null) {
            this.mStateObserver.onServerStateUpdate(n2, n3);
        }
    }

    protected void onLoginStateChanged(int n2) {
        if (this.mMiLinkObserver != null) {
            this.mMiLinkObserver.onLoginStateUpdate(n2);
        }
        if (this.mStateObserver != null) {
            this.mStateObserver.onLoginStateUpdate(n2);
        }
    }

    protected void onEventShouldUpdate() {
        if (this.mEventCallback != null) {
            this.mEventCallback.onEventShouldCheckUpdate();
        }
    }

    protected void onEventServiceTokenExpired() {
        if (this.mEventCallback != null) {
            this.mEventCallback.onEventServiceTokenExpired();
        }
    }

    protected void onEventKickByServer(int n2, long l2, String string2) {
        if (this.mEventCallback != null) {
            this.mEventCallback.onEventKickedByServer(n2, l2, string2);
        }
    }

    protected void onEventGetServiceToken() {
        if (this.mEventCallback != null) {
            this.mEventCallback.onEventGetServiceToken();
        }
    }

    protected void onEventInvilidPacket() {
        if (this.mEventCallback != null) {
            this.mEventCallback.onEventInvalidPacket();
        }
    }

    @Subscribe
    public void onEvent(MiLinkEvent.SessionManagerStateChangeEvent sessionManagerStateChangeEvent) {
        switch (sessionManagerStateChangeEvent.mEventType) {
            case LoginStateChange: {
                this.onLoginStateChanged(sessionManagerStateChangeEvent.mNewState);
                return;
            }
            case SessionStateChange: {
                this.onSessionStateChanged(sessionManagerStateChangeEvent.mOldState, sessionManagerStateChangeEvent.mNewState);
            }
        }
    }

    @Subscribe
    public void onEvent(MiLinkEvent.SessionManagerNotificationEvent object) {
        MiLinkLog.e("MiLinkReceive", "milinkClient " + (Object)((Object)((MiLinkEvent.SessionManagerNotificationEvent)object).mEventType));
        switch (((MiLinkEvent.SessionManagerNotificationEvent)object).mEventType) {
            case GetServiceToken: {
                this.onEventGetServiceToken();
                return;
            }
            case KickByServer: {
                int n2 = 1;
                long l2 = 0L;
                String string2 = "";
                if (((MiLinkEvent.SessionManagerNotificationEvent)object).mObject != null) {
                    object = (PushPacketProto.KickMessage)((MiLinkEvent.SessionManagerNotificationEvent)object).mObject;
                    n2 = ((PushPacketProto.KickMessage)object).getType();
                    l2 = ((PushPacketProto.KickMessage)object).getTime();
                    string2 = ((PushPacketProto.KickMessage)object).getDevice();
                    MiLinkLog.e("MiLinkReceive", "kickout type: " + n2 + " kickMsg.getType() : " + ((PushPacketProto.KickMessage)object).getType());
                }
                this.onEventKickByServer(n2, l2 * 1000L, string2);
                return;
            }
            case ServiceTokenExpired: {
                this.onEventServiceTokenExpired();
                return;
            }
            case ShouldUpdate: {
                this.onEventShouldUpdate();
                return;
            }
            case RecvInvalidPacket: {
                this.onEventInvilidPacket();
            }
        }
    }

    @Subscribe
    public void onEvent(BaseMilinkEvent.ServiceQualityEvent serviceQualityEvent) {
        if (serviceQualityEvent == null) {
            return;
        }
        if (serviceQualityEvent.qualityBean == null) {
            return;
        }
        if (this.report == null) {
            return;
        }
        this.report.ServiceQualityReportCallback(serviceQualityEvent.qualityBean);
    }
}

