/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.client.ipc;

import android.os.AsyncTask;
import com.mi.milink.sdk.base.debug.FileTracer;
import com.mi.milink.sdk.base.debug.FileTracerReader;
import com.mi.milink.sdk.base.debug.LogcatTracer;
import com.mi.milink.sdk.data.Option;
import com.mi.milink.sdk.debug.MiLinkTracer;
import com.mi.milink.sdk.util.CommonUtils;
import com.mi.milink.sdk.util.FileUtils;
import java.io.File;
import java.io.IOException;

public class ClientLog
extends MiLinkTracer {
    private static ClientLog sInstance = null;
    private static AsyncTask<Void, Void, Void> generateSystemLogThread = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClientLog getInstance() {
        if (sInstance != null) return sInstance;
        Class<ClientLog> clazz = ClientLog.class;
        synchronized (ClientLog.class) {
            if (sInstance != null) return sInstance;
            sInstance = new ClientLog();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public static void setMaxFolderSize(long l2) {
        int n2 = (int)(l2 / 524288L);
        if (n2 <= 0) {
            n2 = 48;
        }
        Option.putInt("client.debug.file.blockcount", n2).apply();
    }

    public static void setMaxKeepPeriod(long l2) {
        if (l2 < 86400000L) {
            l2 = 172800000L;
        }
        Option.putLong("client.debug.file.keepperiod", l2).apply();
    }

    public static void setFileTraceLevel(int n2) {
        int n3 = n2;
        if (n2 > 63 || n2 < 0) {
            n3 = 63;
        }
        Option.putInt("client.debug.file.tracelevel", n3).apply();
    }

    public static void setLogcatTraceLevel(int n2) {
        int n3 = n2;
        if (n2 > 63 || n2 < 0) {
            n3 = 63;
        }
        Option.putInt("client.debug.logcat.tracelevel", n3).apply();
    }

    public static final void v(String string2, String string3) {
        ClientLog.getInstance().trace(1, string2, string3, null);
    }

    public static final void v(String string2, String string3, Throwable throwable) {
        ClientLog.getInstance().trace(1, string2, string3, throwable);
    }

    public static final void d(String string2, String string3) {
        ClientLog.getInstance().trace(2, string2, string3, null);
    }

    public static final void d(String string2, String string3, Throwable throwable) {
        ClientLog.getInstance().trace(2, string2, string3, throwable);
    }

    public static final void i(String string2, String string3) {
        ClientLog.getInstance().trace(4, string2, string3, null);
    }

    public static final void i(String string2, String string3, Throwable throwable) {
        ClientLog.getInstance().trace(4, string2, string3, throwable);
    }

    public static final void w(String string2, String string3) {
        ClientLog.getInstance().trace(8, string2, string3, null);
    }

    public static final void w(String string2, String string3, Throwable throwable) {
        ClientLog.getInstance().trace(8, string2, string3, throwable);
    }

    public static final void e(String string2, String string3) {
        ClientLog.getInstance().trace(16, string2, string3, null);
    }

    public static final void e(String string2, String string3, Throwable throwable) {
        ClientLog.getInstance().trace(16, string2, string3, throwable);
    }

    public static boolean packLogs(long l2, File file, File file2) {
        return ClientLog.getInstance().pack(l2, file, file2);
    }

    public static void ensureLogsToFile() {
        ClientLog.getInstance().flush();
    }

    protected ClientLog() {
        this.fileTracer = new FileTracer(CLIENT_CONFIG);
        this.logcatTracer = new LogcatTracer();
        MiLinkTracer.setInstance(this);
        this.onSharedPreferenceChanged(null, "client.debug.file.tracelevel");
        this.onSharedPreferenceChanged(null, "client.debug.logcat.tracelevel");
    }

    public boolean pack(long l2, File file, File file2) {
        File file3 = new FileTracerReader(SERVICE_CONFIG).pack(l2, file, false);
        File file4 = new FileTracerReader(CLIENT_CONFIG).pack(l2, file, false);
        File file5 = new FileTracerReader(CHANNEL_CONFIG).pack(l2, file, false);
        return FileUtils.zip(new File[]{file3, file4, file5}, file2);
    }

    public static synchronized void generateSystemLog() {
        if (generateSystemLogThread != null) {
            return;
        }
        generateSystemLogThread = new AsyncTask<Void, Void, Void>(){

            protected final void onPostExecute(Void void_) {
                generateSystemLogThread = null;
            }

            protected final Void doInBackground(Void ... object) {
                object = MiLinkTracer.getLogFilePath().getAbsolutePath() + File.separator + CommonUtils.createDataFormat("yyyy-MM-dd").format(System.currentTimeMillis()) + File.separator;
                String string2 = "1.system.log";
                object = (String)object + string2;
                object = String.format("logcat -v time -f %s -t %d", object, 8000);
                ClientLog.v("Command", (String)object);
                try {
                    Runtime.getRuntime().exec((String)object);
                    Runtime.getRuntime().exec("logcat -c");
                }
                catch (IOException iOException) {}
                return null;
            }
        };
        generateSystemLogThread.execute((Object[])new Void[0]);
    }
}

