/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.client.ipc;

import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Pair;
import com.mi.milink.sdk.account.manager.MiAccountManager;
import com.mi.milink.sdk.aidl.IService;
import com.mi.milink.sdk.aidl.PacketData;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.base.MessageTask;
import com.mi.milink.sdk.client.IEventListener;
import com.mi.milink.sdk.client.IPacketListener;
import com.mi.milink.sdk.client.MiLinkException;
import com.mi.milink.sdk.client.MiLinkObserver;
import com.mi.milink.sdk.client.SendPacketListener;
import com.mi.milink.sdk.client.ipc.ClientLog;
import com.mi.milink.sdk.client.ipc.internal.MiLinkServiceHost;
import com.mi.milink.sdk.client.ipc.internal.MnsSendPacketListener;
import com.mi.milink.sdk.debug.MiLinkMonitor;
import java.util.Vector;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class MiLinkClientIpc
extends MiLinkServiceHost {
    private static MiLinkClientIpc INSTANCE;
    static boolean mPassportInit;
    Vector<Pair<PacketData, SendPacketListener>> mServiceNotReadyCache = new Vector();

    private MiLinkClientIpc() {
        super(Global.getApplicationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MiLinkClientIpc getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<MiLinkClientIpc> clazz = MiLinkClientIpc.class;
        synchronized (MiLinkClientIpc.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new MiLinkClientIpc();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static boolean init(String string2, String string3, String string4, byte[] byArray, boolean bl2) {
        ClientLog.w("MiLinkClient", "init, milinkversion=" + Global.getMiLinkVersion() + "_" + Global.getMiLinkSubVersion());
        ClientLog.w("MiLinkClient", "init service,passportInit=" + bl2 + " ,app  is serviceToken=" + string3 + ", serviceToken.length= " + string3.length() + "security=" + string4 + ", security.length= " + string4.length());
        if (!mPassportInit) {
            mPassportInit = bl2;
        }
        MiAccountManager.getInstance().setUserId(string2);
        try {
            IService iService = MiLinkClientIpc.getRemoteService();
            if (iService != null) {
                iService.init(string2, string3, string4, byArray, mPassportInit);
                mPassportInit = false;
                return true;
            }
            ClientLog.v("MiLinkClient", "init but remote service = null");
        }
        catch (RemoteException remoteException) {
            ClientLog.e("MiLinkClient", "error when init", remoteException);
        }
        return false;
    }

    public static void setAllowAnonymousLoginSwitch(boolean bl2) {
        try {
            IService iService = MiLinkClientIpc.getRemoteService();
            if (iService != null) {
                iService.setAllowAnonymousLoginSwitch(bl2);
                return;
            }
            ClientLog.v("MiLinkClient", "setAllowAnonymousLoginSwitch but remote service = null");
            return;
        }
        catch (RemoteException remoteException) {
            ClientLog.e("MiLinkClient", "error when setAllowAnonymousLoginSwitch", remoteException);
            return;
        }
    }

    public static void initUseAnonymousMode() {
        try {
            IService iService = MiLinkClientIpc.getRemoteService();
            if (iService != null) {
                iService.initUseAnonymousMode();
                return;
            }
            ClientLog.v("MiLinkClient", "initUseAnonymousMode but remote service = null");
            return;
        }
        catch (RemoteException remoteException) {
            ClientLog.e("MiLinkClient", "error when initUseAnonymousMode", remoteException);
            return;
        }
    }

    public static void setPacketListener(IPacketListener iPacketListener) {
        MiLinkClientIpc.getInstance().mPacketListener = iPacketListener;
    }

    public static void setEventListener(IEventListener iEventListener) {
        MiLinkClientIpc.getInstance().mEventListener = iEventListener;
    }

    public static void setMilinkStateObserver(MiLinkObserver miLinkObserver) {
        ClientLog.v("MiLinkClient", "setMilinkStateObserver");
        MiLinkClientIpc.getInstance().deleteObservers();
        MiLinkClientIpc.getInstance().addObserver(miLinkObserver);
    }

    public static void logoff() {
        try {
            IService iService = MiLinkClientIpc.getRemoteService();
            if (iService != null) {
                iService.logoff();
                MiLinkClientIpc.getInstance().stopService();
                return;
            }
            ClientLog.v("MiLinkClient", "logoff but remote service = null");
            return;
        }
        catch (RemoteException remoteException) {
            ClientLog.e("MiLinkClient", "error when logoff", remoteException);
            return;
        }
    }

    public static void setIpAndPortInManualMode(String string2, int n2) {
        try {
            IService iService = MiLinkClientIpc.getRemoteService();
            if (iService != null) {
                iService.setIpAndPortInManualMode(string2, n2);
                return;
            }
            ClientLog.v("MiLinkClient", "setIpAndPortInManualMode but remote service = null");
            return;
        }
        catch (RemoteException remoteException) {
            ClientLog.e("MiLinkClient", "error when setIpAndPortInManualMode", remoteException);
            return;
        }
    }

    public static IService getRemoteService() {
        return MiLinkClientIpc.getInstance().getRemoteServiceProxy();
    }

    public static void forceReconnet() {
        try {
            IService iService = MiLinkClientIpc.getRemoteService();
            if (iService != null) {
                iService.forceReconnet();
                return;
            }
            ClientLog.v("MiLinkClient", "forceReconnet but remote service = null");
            return;
        }
        catch (RemoteException remoteException) {
            ClientLog.e("MiLinkClient", "error when forceReconnet", remoteException);
            return;
        }
    }

    public static void fastLogin(String string2, String string3, String string4, byte[] byArray) {
        ClientLog.v("MiLinkClient", "fastLogin");
        try {
            IService iService = MiLinkClientIpc.getRemoteService();
            if (iService != null) {
                iService.fastLogin(string2, string3, string4, byArray);
                return;
            }
            ClientLog.v("MiLinkClient", "registerBind but remote service = null");
            return;
        }
        catch (RemoteException remoteException) {
            ClientLog.e("MiLinkClient", "error when registerBind", remoteException);
            return;
        }
    }

    public static String getSuid() {
        try {
            IService iService = MiLinkClientIpc.getRemoteService();
            if (iService != null) {
                return iService.getSuid();
            }
            ClientLog.v("MiLinkClient", "getSuid but remote service = null");
        }
        catch (RemoteException remoteException) {
            ClientLog.e("MiLinkClient", "error when getSuid", remoteException);
        }
        return "";
    }

    public static long getAnonymousAccountId() {
        try {
            IService iService = MiLinkClientIpc.getRemoteService();
            if (iService != null) {
                return iService.getAnonymousAccountId();
            }
            ClientLog.v("MiLinkClient", "getSuid but remote service = null");
        }
        catch (RemoteException remoteException) {
            ClientLog.e("MiLinkClient", "error when getSuid", remoteException);
        }
        return 0L;
    }

    public static void sendAsync(PacketData packetData) {
        MiLinkClientIpc.sendAsync(packetData, 0);
    }

    public static void sendAsync(PacketData packetData, int n2) {
        MiLinkClientIpc.sendAsync(packetData, n2, null);
    }

    public static void sendAsync(PacketData packetData, int n2, SendPacketListener sendPacketListener) {
        MiLinkClientIpc.sendAsync(packetData, n2, sendPacketListener, true);
    }

    public static void sendAsync(PacketData packetData, int n2, SendPacketListener sendPacketListener, boolean bl2) {
        if (packetData == null) {
            throw new IllegalArgumentException("Ary you kidding me ? packet is null");
        }
        if (TextUtils.isEmpty((CharSequence)packetData.getCommand())) {
            throw new IllegalArgumentException("Packet's command is null");
        }
        try {
            IService iService = MiLinkClientIpc.getRemoteService();
            if (iService != null) {
                if (sendPacketListener == null) {
                    iService.sendAsyncWithResponse(packetData, n2, null);
                    return;
                }
                iService.sendAsyncWithResponse(packetData, n2, new MnsSendPacketListener(sendPacketListener));
                return;
            }
            if (bl2) {
                MiLinkClientIpc.getInstance().addToServiceNotReadyCache((Pair<PacketData, SendPacketListener>)new Pair((Object)packetData, (Object)sendPacketListener));
                ClientLog.v("MiLinkClient", "sendAsync but remote service = null,try add to cache");
                return;
            }
            if (sendPacketListener != null) {
                sendPacketListener.onFailed(-3, "milink-service not ready!");
            }
            return;
        }
        catch (RemoteException remoteException) {
            ClientLog.e("MiLinkClient", "error when sendAsync", remoteException);
            return;
        }
    }

    public void addToServiceNotReadyCache(Pair<PacketData, SendPacketListener> pair) {
        try {
            Pair<PacketData, SendPacketListener> pair2;
            if (this.mServiceNotReadyCache.size() > 100 && (pair2 = this.mServiceNotReadyCache.remove(0)) != null) {
                ((SendPacketListener)pair2.second).onFailed(-4, "milink-service not ready and cache queue is full!!abandon");
            }
            this.mServiceNotReadyCache.add(pair);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void internalStop() {
        this.killService();
    }

    @Override
    protected void onMilinkServiceReady() {
        if (!this.mServiceNotReadyCache.isEmpty()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ClientLog.d("MiLinkClient", "onMilinkServiceReady send cache size:" + MiLinkClientIpc.this.mServiceNotReadyCache.size());
                    try {
                        for (Pair<PacketData, SendPacketListener> pair : MiLinkClientIpc.this.mServiceNotReadyCache) {
                            MiLinkClientIpc.sendAsync((PacketData)pair.first, 10000, (SendPacketListener)pair.second, true);
                        }
                        MiLinkClientIpc.this.mServiceNotReadyCache.clear();
                        return;
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
            }).start();
        }
    }

    public static PacketData sendSync(PacketData packetData, int n2) {
        return MiLinkClientIpc.sendSync(packetData, n2, true);
    }

    public static PacketData sendSync(PacketData object, int n2, boolean bl2) {
        MessageTask messageTask = new MessageTask((PacketData)object, n2, bl2){
            final /* synthetic */ PacketData val$packet;
            final /* synthetic */ int val$timeout;
            final /* synthetic */ boolean val$fromCache;
            {
                this.val$packet = packetData;
                this.val$timeout = n2;
                this.val$fromCache = bl2;
            }

            @Override
            public final void doSendWork() {
                MiLinkClientIpc.sendAsync(this.val$packet, this.val$timeout, new SendPacketListener(){

                    @Override
                    public void onResponse(PacketData packetData) {
                        if (!this.isCancelled() && !this.isDone()) {
                            this.set(packetData);
                        }
                    }

                    @Override
                    public void onFailed(int n2, String string2) {
                        if (!this.isCancelled() && !this.isDone()) {
                            this.setException(new MiLinkException(n2, string2));
                        }
                    }
                }, this.val$fromCache);
            }
        }.start();
        long l2 = SystemClock.elapsedRealtime();
        try {
            PacketData packetData = messageTask.getResult(n2 + 5000, TimeUnit.MILLISECONDS);
            MiLinkMonitor.getInstance().trace("", 0, packetData.getCommand(), packetData.getBusiCode(), l2, SystemClock.elapsedRealtime(), 0, packetData.getResponseSize(), packetData.getSeqNo());
            return packetData;
        }
        catch (InterruptedException interruptedException) {
            ClientLog.e("MiLinkClient", "task InterruptedException", interruptedException);
        }
        catch (ExecutionException executionException) {
            ExecutionException executionException2 = executionException;
            object = executionException.getCause();
            if (object != null && object instanceof MiLinkException) {
                ClientLog.e("MiLinkClient", "", (Throwable)object);
            } else {
                ClientLog.e("MiLinkClient", "task ExecutionException", executionException2);
            }
        }
        catch (CancellationException cancellationException) {
            ClientLog.e("MiLinkClient", "task CancellationException", cancellationException);
        }
        catch (TimeoutException timeoutException) {
            MiLinkMonitor.getInstance().trace("", 0, ((PacketData)object).getCommand(), 515, l2, SystemClock.elapsedRealtime(), 0, 0, 0);
            ClientLog.e("MiLinkClient", "task TimeoutException, detailName=" + timeoutException.getClass().getName());
        }
        catch (Exception exception) {
            ClientLog.e("MiLinkClient", "task execption, detailName=" + exception.getClass().getName(), exception);
        }
        return null;
    }

    public static int getMiLinkConnectState() {
        try {
            IService iService = MiLinkClientIpc.getRemoteService();
            if (iService != null) {
                return iService.getServerState();
            }
            ClientLog.v("MiLinkClient", "getMiLinkConnectState but remote service = null");
        }
        catch (RemoteException remoteException) {
            ClientLog.e("MiLinkClient", "error when getMiLinkConnectState", remoteException);
        }
        return 0;
    }

    public static boolean isMiLinkLogined() {
        try {
            IService iService = MiLinkClientIpc.getRemoteService();
            if (iService != null) {
                return iService.isMiLinkLogined();
            }
            ClientLog.v("MiLinkClient", "isMiLinkLogined but remote service = null");
        }
        catch (RemoteException remoteException) {
            ClientLog.e("MiLinkClient", "error when isMiLinkLogined", remoteException);
        }
        return false;
    }

    public static boolean setTimeoutMultiply(float f2) {
        if (f2 < 1.0f || f2 > 10.0f) {
            ClientLog.e("MiLinkClient", "illegal timeoutMultiply\uff0ctimeoutMultiply between 1-10");
            return false;
        }
        try {
            IService iService = MiLinkClientIpc.getRemoteService();
            if (iService != null) {
                iService.setTimeoutMultiply(f2);
                return true;
            }
            ClientLog.v("MiLinkClient", "setTimeoutMultiply but remote service = null");
        }
        catch (RemoteException remoteException) {
            ClientLog.e("MiLinkClient", "error when setBackground", remoteException);
        }
        return false;
    }

    public static boolean enableConnectModeManual(boolean bl2) {
        try {
            IService iService = MiLinkClientIpc.getRemoteService();
            if (iService != null) {
                return iService.enableConnectionManualMode(bl2);
            }
            ClientLog.v("MiLinkClient", "enableConnectModeManual but remote service = null");
        }
        catch (RemoteException remoteException) {
            ClientLog.e("MiLinkClient", "error when setConnectModeAuto", remoteException);
        }
        return false;
    }

    public static boolean setMiPushRegId(String string2) {
        ClientLog.v("MiLinkClient", "mMiPushRegId=".concat(String.valueOf(string2)));
        MiLinkClientIpc.getInstance().mMiPushRegId = string2;
        try {
            IService iService = MiLinkClientIpc.getRemoteService();
            if (iService != null) {
                iService.setMipushRegId(string2);
            } else {
                ClientLog.v("MiLinkClient", "setMiPushRegId but remote service = null");
            }
        }
        catch (RemoteException remoteException) {
            ClientLog.e("MiLinkClient", "error when setMiPushRegId", remoteException);
        }
        return false;
    }

    public static void suspectBadConnection() {
        try {
            IService iService = MiLinkClientIpc.getRemoteService();
            if (iService != null) {
                iService.suspectBadConnection();
                return;
            }
            ClientLog.v("MiLinkClient", "suspectBadConnection but remote service = null");
            return;
        }
        catch (RemoteException remoteException) {
            ClientLog.e("MiLinkClient", "error when suspectBadConnection", remoteException);
            return;
        }
    }

    public static void setMilinkLogLevel(int n2) {
        MiLinkClientIpc.getInstance().mLogLevel = n2;
        try {
            IService iService = MiLinkClientIpc.getRemoteService();
            if (iService != null) {
                iService.setMilinkLogLevel(n2);
                return;
            }
            ClientLog.v("MiLinkClient", "setMilinkLogLevel but remote service = null");
            return;
        }
        catch (RemoteException remoteException) {
            ClientLog.e("MiLinkClient", "error when setMilinkLogLevel", remoteException);
            return;
        }
    }

    public static void setGlobalPushFlag(boolean bl2) {
        MiLinkClientIpc.getInstance().mGlobalPushFlag = bl2;
        try {
            IService iService = MiLinkClientIpc.getRemoteService();
            if (iService != null) {
                iService.setGlobalPushFlag(bl2);
                return;
            }
            ClientLog.v("MiLinkClient", "setMilinkLogLevel but remote service = null");
            return;
        }
        catch (RemoteException remoteException) {
            ClientLog.e("MiLinkClient", "error when setMilinkLogLevel", remoteException);
            return;
        }
    }

    public static void setLanguage(String string2) {
        try {
            IService iService = MiLinkClientIpc.getRemoteService();
            if (iService != null) {
                iService.setLanguage(string2);
                return;
            }
            ClientLog.v("MiLinkClient", "setMilinkLogLevel but remote service = null");
            return;
        }
        catch (RemoteException remoteException) {
            ClientLog.e("MiLinkClient", "error when setMilinkLogLevel", remoteException);
            return;
        }
    }

    static {
        mPassportInit = false;
    }
}

