/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.client.ipc.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import com.mi.milink.sdk.aidl.IEventCallback;
import com.mi.milink.sdk.aidl.IPacketCallback;
import com.mi.milink.sdk.aidl.IService;
import com.mi.milink.sdk.aidl.PacketData;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.base.os.HandlerThreadEx;
import com.mi.milink.sdk.base.os.timer.AlarmClockService;
import com.mi.milink.sdk.client.IEventListener;
import com.mi.milink.sdk.client.IPacketListener;
import com.mi.milink.sdk.client.ipc.ClientLog;
import com.mi.milink.sdk.debug.MiLinkMonitor;
import com.mi.milink.sdk.util.SystemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;

public class MiLinkServiceHost
extends Observable
implements ServiceConnection {
    protected static final String TAG = "MiLinkClient";
    private static final int MILINK_OPEN_OPEN_SERVICE_SUCCESS = 0;
    private static final int MILINK_OPEN_OPEN_SERVICE_FAILED = 1;
    private static final int MILINK_OPEN_BIND_SERVICE_SUCCESS = 0;
    private static final int MILINK_OPEN_BIND_SERVICE_FIRST_FAILED = 1;
    private static final int MILINK_OPEN_BIND_SERVICE_SECOND_FAILED = 2;
    private static final int MILINK_OPEN_GET_REMOTE_SERVICE_SUCCESS = 0;
    private static final int MILINK_OPEN_GET_REMOTE_SERVICE_FAILED = 1;
    private static final int SERVICE_STOP_THRESHOLD = 2;
    private static final int SERVICE_START_THRESHOLD = 3;
    protected Context context;
    protected volatile IService remoteService;
    private volatile int servicePid = Integer.MIN_VALUE;
    private volatile boolean serviceConnecting = false;
    private volatile Object SERVICE_LOCK = new Object();
    private volatile boolean userStartService = false;
    private volatile int restartTimes = 0;
    private HandlerThreadEx eventCenter;
    private Handler.Callback eventCallback = new Handler.Callback(){

        public boolean handleMessage(Message message) {
            ClientLog.v(MiLinkServiceHost.TAG, "receive event callback: " + message.what);
            if (MiLinkServiceHost.this.onHandleInternalServiceEvent(message)) {
                return false;
            }
            MiLinkServiceHost.this.setChanged();
            try {
                MiLinkServiceHost.this.notifyObservers(message);
            }
            catch (Exception exception) {}
            return false;
        }
    };
    protected IEventListener mEventListener;
    protected IPacketListener mPacketListener;
    private IEventCallback.Stub mIEventCallback;
    private IPacketCallback.Stub mIPacketCallback;
    protected String mMiPushRegId = null;
    protected int mLogLevel = 63;
    protected boolean mGlobalPushFlag = false;
    private boolean isStartServiceThreadRunning = false;
    private Runnable mStartServiceRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MiLinkServiceHost.this.isStartServiceThreadRunning = true;
            long l2 = SystemClock.elapsedRealtime();
            int n2 = 0;
            while (MiLinkServiceHost.this.remoteService == null && n2 < 2) {
                ClientLog.e(MiLinkServiceHost.TAG, "getRemoteService, but remoteService = null, stopCount=".concat(String.valueOf(n2)));
                int n3 = 0;
                while (MiLinkServiceHost.this.remoteService == null && n3++ < 3) {
                    ClientLog.e(MiLinkServiceHost.TAG, "try startService, startCount=".concat(String.valueOf(n3)));
                    try {
                        MiLinkServiceHost.this.serviceConnecting = false;
                        if (MiLinkServiceHost.this.startService(Reason.Restart)) {
                            Object object = MiLinkServiceHost.this.SERVICE_LOCK;
                            synchronized (object) {
                                try {
                                    MiLinkServiceHost.this.SERVICE_LOCK.wait(3000L);
                                }
                                catch (InterruptedException interruptedException) {}
                                continue;
                            }
                        }
                        SystemClock.sleep((long)1000L);
                    }
                    catch (Exception exception) {
                        ClientLog.e(MiLinkServiceHost.TAG, "startService(Reason.Restart) exception  :" + exception.getMessage());
                        SystemClock.sleep((long)3000L);
                    }
                }
                if (MiLinkServiceHost.this.remoteService != null) continue;
                ++n2;
                MiLinkServiceHost.this.stopService(Reason.UserCall);
            }
            if (MiLinkServiceHost.this.remoteService == null) {
                ClientLog.e(MiLinkServiceHost.TAG, "mns service start failed ,create system.log. stopCount=".concat(String.valueOf(n2)));
                ClientLog.generateSystemLog();
                MiLinkMonitor.getInstance().trace("", 0, "milink.getremoteservice", 1, l2, SystemClock.elapsedRealtime(), 0, 0, 0);
                MiLinkMonitor.getInstance().doPostDataAtOnce();
            } else {
                MiLinkMonitor.getInstance().trace("", 0, "milink.getremoteservice", 0, l2, SystemClock.elapsedRealtime(), 0, 0, 0);
            }
            MiLinkServiceHost.this.isStartServiceThreadRunning = false;
        }
    };
    private Runnable mKillRunnable = new Runnable(){

        @Override
        public void run() {
            MiLinkServiceHost.this.killService();
            MiLinkServiceHost.this.killApp();
        }
    };

    protected MiLinkServiceHost(Context context) {
        this.context = context;
        this.eventCenter = new HandlerThreadEx("MiLinkEventNotifier", true, 10, this.eventCallback);
        this.mIEventCallback = new IEventCallback.Stub(){

            @Override
            public void onEventShouldCheckUpdate() throws RemoteException {
                if (MiLinkServiceHost.this.mEventListener != null) {
                    MiLinkServiceHost.this.mEventListener.onEventShouldCheckUpdate();
                }
            }

            @Override
            public void onEventServiceTokenExpired() throws RemoteException {
                if (MiLinkServiceHost.this.mEventListener != null) {
                    MiLinkServiceHost.this.mEventListener.onEventServiceTokenExpired();
                }
            }

            @Override
            public void onEventKickedByServer(int n2, long l2, String string2) throws RemoteException {
                if (MiLinkServiceHost.this.mEventListener != null) {
                    MiLinkServiceHost.this.mEventListener.onEventKickedByServer(n2, l2, string2);
                }
            }

            @Override
            public void onEventInvalidPacket() throws RemoteException {
                if (MiLinkServiceHost.this.mEventListener != null) {
                    MiLinkServiceHost.this.mEventListener.onEventInvalidPacket();
                }
            }

            @Override
            public void onEventGetServiceToken() throws RemoteException {
                if (MiLinkServiceHost.this.mEventListener != null) {
                    MiLinkServiceHost.this.mEventListener.onEventGetServiceToken();
                }
            }
        };
        this.mIPacketCallback = new IPacketCallback.Stub(){

            @Override
            public boolean onReceive(List<PacketData> list) throws RemoteException {
                if (MiLinkServiceHost.this.mPacketListener != null) {
                    MiLinkServiceHost.this.mPacketListener.onReceive((ArrayList)list);
                    return true;
                }
                return false;
            }
        };
    }

    public IService getRemoteServiceProxy() {
        if (this.remoteService != null) {
            return this.remoteService;
        }
        if (Looper.myLooper() != null && Looper.myLooper() == Looper.getMainLooper()) {
            ClientLog.e(TAG, "dangerous!!!!getRemoteService in main Thread is not safe!!!");
            if (!this.isStartServiceThreadRunning) {
                new Thread(this.mStartServiceRunnable).start();
            }
        } else if (!this.isStartServiceThreadRunning) {
            this.mStartServiceRunnable.run();
        }
        return this.remoteService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServiceConnected(ComponentName object, IBinder object2) {
        ClientLog.e(TAG, "onServiceConnected()");
        object = this;
        synchronized (object) {
            try {
                if (this.serviceConnecting) {
                    this.serviceConnecting = false;
                } else {
                    ClientLog.e(TAG, "Ghost's Call? Nobody binds service but Callback here. WTF!!!");
                }
                this.remoteService = IService.Stub.asInterface(object2);
                this.remoteService.setEventCallBack(this.mIEventCallback);
                this.remoteService.setPacketCallBack(this.mIPacketCallback);
                object2 = new Bundle();
                object2.putParcelable("ipc.client.notifier", (Parcelable)this.eventCenter.getMessenger());
                this.servicePid = this.remoteService.setClientInfo((Bundle)object2);
                if (!TextUtils.isEmpty((CharSequence)this.mMiPushRegId)) {
                    this.remoteService.setMipushRegId(this.mMiPushRegId);
                }
                this.remoteService.setMilinkLogLevel(this.mLogLevel);
                this.remoteService.setGlobalPushFlag(this.mGlobalPushFlag);
                if (this.servicePid == Integer.MIN_VALUE) {
                    this.stopService(Reason.ClientError);
                }
                this.onMilinkServiceReady();
            }
            catch (Exception exception) {
                this.stopService(Reason.ClientError);
            }
            if (this.remoteService != null) {
                ClientLog.e(TAG, "onServiceConnected got a binder");
            }
            object2 = this.SERVICE_LOCK;
            synchronized (object2) {
                this.SERVICE_LOCK.notifyAll();
            }
            return;
        }
    }

    protected void onMilinkServiceReady() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServiceDisconnected(ComponentName object) {
        ClientLog.e(TAG, "onServiceDisconnected()");
        object = this;
        synchronized (object) {
            ++this.restartTimes;
            this.stopService(Reason.Disconnect);
            return;
        }
    }

    protected boolean onHandleInternalServiceEvent(Message message) {
        return message.what == 12;
    }

    public void killService() {
        ClientLog.e(TAG, "Service[" + this.servicePid + "] will be Terminated");
        this.setServicePidByServiceName();
        AlarmClockService.stop();
        Process.killProcess((int)this.servicePid);
    }

    private void killApp() {
        int n2 = Process.myPid();
        ClientLog.e(TAG, "app[" + n2 + "] will be Terminated beccause getRemoteService==null");
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {}
        Process.killProcess((int)n2);
    }

    public void setServicePidByServiceName() {
        String string2 = Global.getClientAppInfo().getServiceProcessName();
        this.servicePid = SystemUtils.getPidByProcessName(string2);
        ClientLog.e(TAG, "serviceProcess pid = " + this.servicePid);
    }

    public boolean isServiceAvailable() {
        return this.remoteService != null;
    }

    public boolean isServiceAlive() {
        try {
            return this.isServiceAvailable();
        }
        catch (Exception exception) {
            ClientLog.e(TAG, "Remote Service is Dead");
            return false;
        }
    }

    public int getServicePid() {
        if (this.remoteService != null) {
            return this.servicePid;
        }
        return -1;
    }

    private void initService() {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName(this.context, "com.mi.milink.sdk.service.MiLinkService"));
        intent.setPackage(Global.getPackageName());
        long l2 = SystemClock.elapsedRealtime();
        intent = this.context.startService(intent);
        if (intent == null) {
            ClientLog.e(TAG, "start service failed");
            MiLinkMonitor.getInstance().trace("", 0, "milink.startservice", 1, l2, SystemClock.elapsedRealtime(), 0, 0, 0);
            return;
        }
        ClientLog.e(TAG, "startService ComponentName = " + intent.toString());
        ClientLog.e(TAG, "start service success");
        MiLinkMonitor.getInstance().trace("", 0, "milink.startservice", 0, l2, SystemClock.elapsedRealtime(), 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startService(Reason reason) {
        MiLinkServiceHost miLinkServiceHost = this;
        synchronized (miLinkServiceHost) {
            if (Reason.UserCall.equals((Object)reason)) {
                this.userStartService = true;
            }
            if (this.serviceConnecting) {
                return true;
            }
            this.initService();
            reason = new Intent();
            reason.setComponent(new ComponentName(this.context, "com.mi.milink.sdk.service.MiLinkService"));
            reason.setPackage(Global.getPackageName());
            long l2 = SystemClock.elapsedRealtime();
            boolean bl2 = this.context.bindService((Intent)reason, (ServiceConnection)this, 1);
            if (!bl2) {
                MiLinkMonitor.getInstance().trace("", 0, "milink.bindservice", 1, l2, SystemClock.elapsedRealtime(), 0, 0, 0);
                ClientLog.i(TAG, "bindService() first time failed!!");
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                l2 = SystemClock.elapsedRealtime();
                bl2 = this.context.bindService((Intent)reason, (ServiceConnection)this, 1);
                if (!bl2) {
                    ClientLog.i(TAG, "bindService() second time failed too!!");
                    MiLinkMonitor.getInstance().trace("", 0, "milink.bindservice", 2, l2, SystemClock.elapsedRealtime(), 0, 0, 0);
                    this.stopService(Reason.SystemFatal);
                    new Handler(this.context.getMainLooper()).postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            ClientLog.i(MiLinkServiceHost.TAG, "bindService() twice failed , then inform the client by called onServiceConnected()");
                            MiLinkServiceHost.this.onServiceConnected(new ComponentName(MiLinkServiceHost.this.context, "com.mi.milink.sdk.service.MiLinkService"), null);
                        }
                    }, 200L);
                    return false;
                }
            }
            MiLinkMonitor.getInstance().trace("", 0, "milink.bindservice", 0, l2, SystemClock.elapsedRealtime(), 0, 0, 0);
            ClientLog.i(TAG, "bindService() success!!");
            if (bl2) {
                this.serviceConnecting = true;
            }
            return bl2;
        }
    }

    public void stopService() {
        this.stopService(Reason.UserCall);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopService(Reason reason) {
        ClientLog.v(TAG, "stopService".concat(String.valueOf((Object)reason)));
        MiLinkServiceHost miLinkServiceHost = this;
        synchronized (miLinkServiceHost) {
            try {
                this.serviceConnecting = false;
                if (Reason.UserCall.equals((Object)reason)) {
                    AlarmClockService.stop();
                    this.userStartService = false;
                    this.context.unbindService((ServiceConnection)this);
                    reason = new Intent();
                    reason.setComponent(new ComponentName(this.context, "com.mi.milink.sdk.service.MiLinkService"));
                    this.context.stopService((Intent)reason);
                    ClientLog.v(TAG, "stopService over");
                }
            }
            catch (Exception exception) {}
            this.remoteService = null;
            return;
        }
    }

    public static interface OnServiceStartListener {
        public void onServiceStarted(ServiceStartResult var1);
    }

    public static enum ServiceStartResult {
        Success,
        SystemError,
        NativeUnzipFailed,
        NativeLoadFailed;

    }

    private static enum Reason {
        UserCall("\u7528\u6237\u8c03\u7528"),
        Restart("\u65ad\u5f00\u540e\u91cd\u8fde"),
        Disconnect("\u670d\u52a1\u4e3b\u52a8\u65ad\u5f00"),
        ClientError("\u53d1\u751f\u9519\u8bef\u65ad\u5f00"),
        RemoteDead("\u670d\u52a1\u6302\u4e86"),
        SystemFatal("\u670d\u52a1\u542f\u52a8\u5931\u8d25");

        private String reason;

        private Reason(String string3) {
            this.reason = string3;
        }

        public final String toString() {
            return this.reason;
        }
    }
}

