/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.config;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.text.TextUtils;
import com.mi.milink.sdk.account.manager.MiAccountManager;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.base.os.info.NetworkDash;
import com.mi.milink.sdk.base.os.timer.AlarmClockService;
import com.mi.milink.sdk.debug.MiLinkLog;
import java.util.HashSet;
import java.util.Observable;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfigManager
extends Observable {
    private static final String TAG = "ConfigManager";
    public static final long SERVICE_SUICIDE_INTERVAL = 3600000L;
    private static final int DEFAULT_HEART_BEAT_INTERVAL = 300000;
    private static final int DEFAULT_SPEED_TEST_INTERVAL = 43200000;
    private static final String PREF_MNS_SETTINGS_DATA_NAME = "mns_settings_data";
    private static final String PREF_KEY_SUID = "suid";
    private static final String PREF_KEY_SUID_ANONYMOUS = "suid_anonymous";
    private static final String PREF_KEY_HEART_BEAT_INTERVAL = "heart_beat_interval";
    private static final String PREF_KEY_CHANNEL_PUB_KEY = "channel_public_key";
    private static final String PREF_KEY_SPEED_TEST_TIP = "speed_test_tip";
    private static final String PREF_KEY_SPEED_TEST_UIP = "speed_test_uip";
    private static final String PREF_KEY_SPEED_TEST_INTERVAL = "speed_test_interval";
    private static final String PREF_KEY_SAMPLE_STATICTIS_FACTOR = "sample_statistics_factor";
    private static final String PREF_KEY_LOG_LEVEL = "log_level";
    private static final int MOBILE_NETWORK_CONNECTION_TIME_OUT = 5000;
    private static final int WIFI_CONNECTION_TIME_OUT = 3000;
    private static final int MOBILE_NETWORK_REQUEST_TIME_OUT = 30000;
    private static final int WIFI_REQUEST_TIME_OUT = 15000;
    private static int MOBILE_NETWORK_UPLOAD_STASTIC_INTERVAL = 600000;
    private static int WIFI_UPLOAD_STASTIC_INTERVAL = 300000;
    private static final int MOBILE_NETWORK_DNS_TIME_OUT = 6000;
    private static final int WIFI_DNS_TIME_OUT = 4000;
    private static final String JSON_KEY_HB = "hb";
    private static final String JSON_KEY_ST = "st";
    private static final String JSON_KEY_TIP = "tip";
    private static final String JSON_KEY_UIP = "uip";
    private static final String JSON_KEY_INTL = "intl";
    private static final String JSON_KEY_ENGINE_CONFIG_RATIO = "engineConfRatio";
    private static final String JSON_KEY_STATISTICS_FACTOR = "sf";
    private static final String JSON_KEY_LOG_LEVEL = "logLev";
    private String suid = null;
    private String suidAnonymous = null;
    private float engineConfigRatio = 0.5f;
    private long heartBeatInterval = 300000L;
    private long speedTestInterval = 43200000L;
    private long configTimeStamp = 0L;
    private int samplingStatisticsFactor = 5;
    private int logLevel = 63;
    private Context context = null;
    private String speedTestTip = null;
    private String speedTestUip = null;
    private Set<String> channelPubKeySet = new HashSet<String>(6);
    private static ConfigManager sIntance = new ConfigManager();
    private float timeoutMultiply = 1.0f;
    JSONObject engineMatch = null;

    public static ConfigManager getInstance() {
        return sIntance;
    }

    private ConfigManager() {
        this.context = Global.getContext();
        this.loadConfig();
    }

    public int getConnetionTimeout() {
        int n2 = 3000;
        if (NetworkDash.isMobile()) {
            n2 = 5000;
        }
        return n2;
    }

    public int getRequestTimeout() {
        int n2 = 15000;
        if (NetworkDash.isMobile()) {
            n2 = 30000;
        }
        return n2;
    }

    public int getUploadStasticInterval() {
        int n2 = MOBILE_NETWORK_UPLOAD_STASTIC_INTERVAL;
        if (NetworkDash.isWifi()) {
            n2 = WIFI_UPLOAD_STASTIC_INTERVAL;
        }
        return n2;
    }

    public int getDnsTimeout() {
        int n2 = 4000;
        if (NetworkDash.isMobile()) {
            n2 = 6000;
        }
        return n2;
    }

    public synchronized String getSpeedTestTcpIps() {
        return this.speedTestTip;
    }

    private synchronized void updateSpeedTestTcpIps(String string2) {
        MiLinkLog.v(TAG, "speedtest tip is ".concat(String.valueOf(string2)));
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(this.speedTestTip)) {
            this.speedTestTip = string2;
        }
    }

    public synchronized String getSpeedTestUdpIps() {
        return this.speedTestUip;
    }

    private synchronized void updateSpeedTestUdpIps(String string2) {
        MiLinkLog.v(TAG, "speedtest uip is ".concat(String.valueOf(string2)));
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(this.speedTestUip)) {
            this.speedTestUip = string2;
        }
    }

    public synchronized float getEngineConfigRatio() {
        return this.engineConfigRatio;
    }

    public synchronized String getSuid() {
        return this.suid;
    }

    public synchronized void updateSuid(String string2) {
        if (!string2.equals(this.suid)) {
            this.suid = string2;
            this.saveConfig();
        }
    }

    public synchronized void loadSuid() {
        SharedPreferences sharedPreferences = this.context.getSharedPreferences(PREF_MNS_SETTINGS_DATA_NAME, 0);
        String string2 = String.format("%s_%s_%s", PREF_KEY_SUID, Global.getClientAppInfo().getAppId(), MiAccountManager.getInstance().getUserId());
        this.suid = sharedPreferences.getString(string2, "");
        MiLinkLog.e(TAG, string2 + " suid=" + this.suid);
    }

    public synchronized String getSuidAnonymous() {
        return this.suidAnonymous;
    }

    public void updateSuidAnonymous(String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(this.suidAnonymous)) {
            this.suidAnonymous = string2;
            this.saveConfig();
        }
    }

    public synchronized long getSpeedTestInterval() {
        return this.speedTestInterval;
    }

    private synchronized void updateSpeedTestInterval(long l2) {
        MiLinkLog.v(TAG, "speedtest interval from server is ".concat(String.valueOf(l2)));
        if (l2 > 0L && (l2 *= 1000L) != this.speedTestInterval) {
            this.speedTestInterval = l2;
        }
    }

    public synchronized long getHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    private synchronized void updateHeartBeatInterval(long l2) {
        MiLinkLog.v(TAG, "heartbeat interval from server is ".concat(String.valueOf(l2)));
        if (l2 > 0L && (l2 *= 1000L) != this.heartBeatInterval) {
            MiLinkLog.w(TAG, "update heat beat interval from " + this.heartBeatInterval + " to " + l2);
            this.heartBeatInterval = l2;
            AlarmClockService.resetNextPing();
        }
    }

    public synchronized long getConfigTimeStamp() {
        return this.configTimeStamp;
    }

    public synchronized Set<String> getChannelPubKeys() {
        if (this.channelPubKeySet == null || this.channelPubKeySet.size() == 0) {
            this.loadConfig();
        }
        return this.channelPubKeySet;
    }

    public synchronized void updateChannelPubKeySet(Set<String> set) {
        this.channelPubKeySet = set;
        this.saveConfig();
    }

    private synchronized void updateLogLevel(int n2) {
        MiLinkLog.v(TAG, "update logLevel =".concat(String.valueOf(n2)));
        if (n2 != this.logLevel) {
            this.logLevel = n2;
            MiLinkLog.setLogcatTraceLevel(this.logLevel);
            MiLinkLog.setFileTraceLevel(this.logLevel);
        }
    }

    private synchronized void updateSamplingStatisticFactor(int n2) {
        MiLinkLog.v(TAG, "update sample statistic factor = ".concat(String.valueOf(n2)));
        if (n2 <= 10 && n2 >= 0 && n2 != this.samplingStatisticsFactor) {
            this.samplingStatisticsFactor = n2;
        }
    }

    public float getTimeoutMultiply() {
        return this.timeoutMultiply;
    }

    public synchronized void setTimeoutMultiply(float f2) {
        this.timeoutMultiply = f2;
    }

    public synchronized void setUploadTime(int n2) {
        MOBILE_NETWORK_UPLOAD_STASTIC_INTERVAL = n2;
        WIFI_UPLOAD_STASTIC_INTERVAL = n2;
    }

    public int getSamplingStatisticsFactor() {
        return this.samplingStatisticsFactor;
    }

    @SuppressLint(value={"NewApi"})
    private synchronized void saveConfig() {
        SharedPreferences.Editor editor = this.context.getSharedPreferences(PREF_MNS_SETTINGS_DATA_NAME, 0).edit();
        editor.putLong(PREF_KEY_HEART_BEAT_INTERVAL, this.heartBeatInterval);
        editor.putLong(PREF_KEY_SPEED_TEST_INTERVAL, this.speedTestInterval);
        editor.putString(PREF_KEY_SPEED_TEST_TIP, this.speedTestTip);
        editor.putString(PREF_KEY_SPEED_TEST_UIP, this.speedTestUip);
        editor.putInt(PREF_KEY_SAMPLE_STATICTIS_FACTOR, this.samplingStatisticsFactor);
        editor.putInt(PREF_KEY_LOG_LEVEL, this.logLevel);
        String string2 = String.format("%s_%s_%s", PREF_KEY_SUID, Global.getClientAppInfo().getAppId(), MiAccountManager.getInstance().getUserId());
        MiLinkLog.e(TAG, string2 + " suid=" + this.suid);
        editor.putString(string2, this.suid);
        editor.putString(PREF_KEY_SUID_ANONYMOUS, this.suidAnonymous);
        editor.putStringSet(PREF_KEY_CHANNEL_PUB_KEY, this.channelPubKeySet);
        if (Build.VERSION.SDK_INT >= 9) {
            editor.apply();
            return;
        }
        editor.commit();
    }

    @SuppressLint(value={"NewApi"})
    private synchronized void loadConfig() {
        SharedPreferences sharedPreferences = this.context.getSharedPreferences(PREF_MNS_SETTINGS_DATA_NAME, 0);
        this.heartBeatInterval = sharedPreferences.getLong(PREF_KEY_HEART_BEAT_INTERVAL, 300000L);
        this.speedTestInterval = sharedPreferences.getLong(PREF_KEY_SPEED_TEST_INTERVAL, 43200000L);
        this.speedTestTip = sharedPreferences.getString(PREF_KEY_SPEED_TEST_TIP, "");
        this.speedTestUip = sharedPreferences.getString(PREF_KEY_SPEED_TEST_UIP, "");
        this.samplingStatisticsFactor = sharedPreferences.getInt(PREF_KEY_SAMPLE_STATICTIS_FACTOR, 5);
        this.logLevel = sharedPreferences.getInt(PREF_KEY_LOG_LEVEL, 63);
        this.suid = sharedPreferences.getString(PREF_KEY_SUID, "");
        this.suidAnonymous = sharedPreferences.getString(PREF_KEY_SUID_ANONYMOUS, "");
        this.channelPubKeySet = sharedPreferences.getStringSet(PREF_KEY_CHANNEL_PUB_KEY, null);
    }

    public synchronized JSONObject getEngineMatch() {
        return this.engineMatch;
    }

    public synchronized boolean updateConfig(long l2, String string2) {
        MiLinkLog.v(TAG, "update config from " + this.configTimeStamp + " to " + l2 + ", jsonConfig=" + string2);
        if (l2 > this.configTimeStamp) {
            this.configTimeStamp = l2;
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                try {
                    JSONObject jSONObject = new JSONObject(string2);
                    if (jSONObject.length() == 0) {
                        return false;
                    }
                    this.updateHeartBeatInterval(jSONObject.optInt(JSON_KEY_HB, 0));
                    JSONObject jSONObject2 = jSONObject.optJSONObject(JSON_KEY_ST);
                    if (jSONObject2 != null) {
                        this.updateSpeedTestInterval(jSONObject2.optInt(JSON_KEY_INTL, 0));
                        this.updateSpeedTestTcpIps(jSONObject2.optString(JSON_KEY_TIP, ""));
                        this.updateSpeedTestUdpIps(jSONObject2.optString(JSON_KEY_UIP, ""));
                    }
                    try {
                        this.engineConfigRatio = Float.parseFloat(jSONObject.getString(JSON_KEY_ENGINE_CONFIG_RATIO));
                    }
                    catch (Exception exception) {}
                    this.updateSamplingStatisticFactor(jSONObject.optInt(JSON_KEY_STATISTICS_FACTOR, -1));
                    this.updateLogLevel(jSONObject.optInt(JSON_KEY_LOG_LEVEL, 63));
                    try {
                        this.engineMatch = jSONObject.getJSONObject("engine_match");
                    }
                    catch (Exception exception) {
                        MiLinkLog.e(TAG, exception);
                        this.engineMatch = null;
                    }
                }
                catch (JSONException jSONException) {
                    MiLinkLog.e(TAG, jSONException);
                }
            }
            this.saveConfig();
            return true;
        }
        return false;
    }

    public void deleteChannelPubKey(String string2) {
        if (this.channelPubKeySet == null) {
            return;
        }
        this.channelPubKeySet.remove(string2);
    }
}

