/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.config;

import android.annotation.SuppressLint;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.base.os.timer.AlarmClockService;
import com.mi.milink.sdk.config.IIpInfoManager;
import com.mi.milink.sdk.debug.MiLinkLog;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

@SuppressLint(value={"NewApi"})
public class HeartBeatManager {
    private static final String TAG = "HeartBeatManager";
    private static final int incIntervalTime = 25000;
    private static int minHeartBeatInterval = 180000;
    private static int maxHeartBeatInterval = 300000;
    private int heartBeatInterval = minHeartBeatInterval;
    private long lastPacketSendTime = 0L;
    private static final int maxListElemet = 2;
    Queue<HeartBeatInfo> packetList = new ConcurrentLinkedQueue<HeartBeatInfo>();
    private HeartBeatInfo lastHeartBeatInfo;
    private HeartBeatInfo currHeartBeatInfo;
    private long lastReviveTimeoutHbTime = 0L;
    private HeartBeatModEnum modle;
    private boolean probeIsStop = false;
    boolean probeFailedPoint = false;
    private Map<String, Integer> apnsHeartBeatTimeMap = new ConcurrentHashMap<String, Integer>(5);
    private static final String heartBeatTimeFileName = "apnhearttime";
    private static HeartBeatManager sIntance = new HeartBeatManager();
    private int appId;

    private void printfManager(String object) {
        MiLinkLog.d(TAG, "HeartBeatManager info:" + (String)object + ",Interval=" + this.heartBeatInterval + ",lHbI=" + this.lastHeartBeatInfo + ",cHBI=" + this.currHeartBeatInfo + ",lPacketSt=" + this.lastPacketSendTime + ",model=" + (Object)((Object)this.modle) + ",packetSize = " + this.packetList.size());
        if (this.packetList.size() > 0) {
            for (HeartBeatInfo heartBeatInfo : this.packetList) {
                MiLinkLog.d(TAG, "PacketListInfo = ".concat(String.valueOf(heartBeatInfo)));
            }
        }
    }

    public static HeartBeatManager getInstance() {
        return sIntance;
    }

    public long getLastPacketSendTime() {
        MiLinkLog.d(TAG, "lastPacketSendTime = " + this.lastPacketSendTime);
        return this.lastPacketSendTime;
    }

    public long getHeartBeatInterval() {
        MiLinkLog.d(TAG, "heartBeatInterval = " + this.heartBeatInterval);
        return this.heartBeatInterval;
    }

    private void loadHeartBeatTimeMap() {
        try {
            Object object = IIpInfoManager.loadObject(heartBeatTimeFileName);
            if (object != null) {
                this.apnsHeartBeatTimeMap = (Map)object;
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void saveConfig() {
        String string2 = IIpInfoManager.getCurrentApn();
        if (string2 == null) {
            MiLinkLog.i(TAG, "saveconfig apn = null , no save");
            return;
        }
        this.apnsHeartBeatTimeMap.put(string2, this.heartBeatInterval);
        IIpInfoManager.saveObject(this.apnsHeartBeatTimeMap, heartBeatTimeFileName);
        MiLinkLog.i(TAG, "********* save config apn=" + string2 + ",time = " + this.heartBeatInterval);
    }

    private void setHeartBeatInterval() {
        String string2 = IIpInfoManager.getCurrentApn();
        MiLinkLog.d(TAG, "apn = ".concat(String.valueOf(string2)));
        if (this.apnsHeartBeatTimeMap == null || string2 == null) {
            this.heartBeatInterval = minHeartBeatInterval;
            return;
        }
        Integer object2 = this.apnsHeartBeatTimeMap.get(string2);
        if (object2 != null && object2 >= minHeartBeatInterval) {
            this.heartBeatInterval = object2;
            MiLinkLog.i(TAG, "load config find apn = " + (String)string2 + ",heartBeatInterval = " + this.heartBeatInterval);
        }
        for (String string3 : this.apnsHeartBeatTimeMap.keySet()) {
            MiLinkLog.d(TAG, "apnName=" + string3 + ",hbt=" + this.apnsHeartBeatTimeMap.get(string3));
        }
    }

    private void loadConfig() {
        this.loadHeartBeatTimeMap();
        if (this.apnsHeartBeatTimeMap == null) {
            return;
        }
        this.setHeartBeatInterval();
    }

    public HeartBeatManager() {
        this.appId = Global.getClientAppInfo().getAppId();
        MiLinkLog.d(TAG, "HeartBeatManager start()");
        this.clearPacketList();
        this.clearHeartBeatManagerInfo(true);
        this.registerAlarmClock();
        this.modle = HeartBeatModEnum.INC;
        this.loadConfig();
        this.probeIsStop = false;
        if (this.appId == 10007) {
            maxHeartBeatInterval = 240000;
        }
        MiLinkLog.d(TAG, "HeartBeatManager end()");
    }

    public HeartBeatManager(int n2) {
        MiLinkLog.d(TAG, "HeartBeatManager start()");
        this.clearPacketList();
        this.clearHeartBeatManagerInfo(true);
        this.registerAlarmClock();
        this.modle = HeartBeatModEnum.INC;
        this.loadConfig();
        this.probeIsStop = false;
        if (n2 == 10007) {
            maxHeartBeatInterval = 240000;
        }
        MiLinkLog.d(TAG, "HeartBeatManager end()");
    }

    private void clearPacketList() {
        this.packetList.clear();
    }

    private void clearHeartBeatManagerInfo(boolean bl2) {
        if (bl2) {
            this.lastHeartBeatInfo = null;
            this.currHeartBeatInfo = null;
        }
        this.lastReviveTimeoutHbTime = 0L;
        MiLinkLog.i(TAG, "clearHeartBeatManagerInfo");
    }

    public void startHeartBeatProbeManager(int n2) {
        MiLinkLog.e("HeartBeat", "\u5f00\u59cb\u63a2\u6d4b\u5fc3\u8df3");
        this.printfManager("startHeartBeatProbeManager-----start");
        this.probeIsStop = false;
        this.clearHeartBeatManagerInfo(true);
        MiLinkLog.d(TAG, "start heartBeatProbeManager send first beat..");
        if (!this.probeFailedPoint) {
            this.setHeartBeatInterval();
        }
        this.registerAlarmClock();
        MiLinkLog.d(TAG, "probeFailedPoint = " + this.probeFailedPoint);
        this.printfManager("startHeartBeatProbeManager-----end");
        this.sendHeartBeat(n2);
    }

    public void setLastPacketSendTime(int n2) {
        this.lastPacketSendTime = System.currentTimeMillis();
        MiLinkLog.d(TAG, "set lastpacketSendTime time = " + this.lastPacketSendTime + ",seq = " + n2);
    }

    public void setLastPacketSendTime(int n2, String string2) {
        if ("milink.heartbeat".equals(string2)) {
            return;
        }
        Global.LAST_PACKET_SEND_TIME = this.lastPacketSendTime = System.currentTimeMillis();
        MiLinkLog.d(TAG, "set lastpacketSendTime time = " + this.lastPacketSendTime + ",seq = " + n2 + ",command = " + string2);
    }

    public long getLastHeartBeatSendTime() {
        long l2 = 0L;
        if (this.currHeartBeatInfo != null) {
            l2 = this.currHeartBeatInfo.getSendTime();
        }
        return l2;
    }

    public void sendHeartBeat(int n2) {
        MiLinkLog.e("HeartBeat", "\u53d1\u9001\u5fc3\u8df3 \uff1a ".concat(String.valueOf(n2)));
        if (this.probeIsStop) {
            MiLinkLog.d(TAG, "probeIsStop is true do nothing sendHeartBeat");
            return;
        }
        this.printfManager("sendHeartBeat----start---");
        HeartBeatInfo heartBeatInfo = new HeartBeatInfo();
        heartBeatInfo.setSeq(n2);
        heartBeatInfo.setSendTime(System.currentTimeMillis());
        long l2 = 0L;
        if (this.currHeartBeatInfo != null) {
            l2 = this.currHeartBeatInfo.getSendTime();
        }
        this.lastHeartBeatInfo = this.currHeartBeatInfo;
        MiLinkLog.d(TAG, "sendHeartBeat lastPacketSendTime =" + this.lastPacketSendTime + ",lastHeartBeatSendTime = " + l2 + ",less = " + (this.lastPacketSendTime - l2));
        this.currHeartBeatInfo = heartBeatInfo;
        if (this.lastHeartBeatInfo == null) {
            MiLinkLog.i(TAG, "send Heart Beat first beat,no put in packetlist,currHeartBeatInfo = " + this.currHeartBeatInfo.toString());
            this.printfManager("sendHeartBeat----end---");
            return;
        }
        if (l2 > 0L && this.lastPacketSendTime > l2) {
            MiLinkLog.d(TAG, "lastpacketSendtime > lastHeartBeatSendTime," + this.lastPacketSendTime + "," + l2 + ",no put in packetlist");
            this.printfManager("sendHeartBeat----end---");
            return;
        }
        MiLinkLog.d(TAG, "sendHeartBeat seqNo=" + n2 + " find ok,put in packetlist");
        this.lastHeartBeatInfo.setOk(true);
        HeartBeatManager heartBeatManager = this;
        heartBeatManager.putHBInfoInList(heartBeatManager.lastHeartBeatInfo);
        this.startAanalysisHeartBeat();
        this.printfManager("sendHeartBeat----end---");
    }

    public void reciveConnectRunError(int n2) {
        this.printfManager("reciveConnectRunError----start---");
        long l2 = System.currentTimeMillis();
        MiLinkLog.d(TAG, "currentTime=".concat(String.valueOf(l2)));
        long l3 = 0L;
        if (this.currHeartBeatInfo != null) {
            l3 = this.currHeartBeatInfo.getSendTime();
        }
        long l4 = l2 - l3;
        long l5 = this.lastPacketSendTime - l3;
        MiLinkLog.i(TAG, "reciveConnectRunError,currentTime - timerStartTime = " + l4 + ", " + minHeartBeatInterval + ",timerStartTime = " + l3 + ",packetSendLess=" + l5);
        if (l5 < 0L && l4 >= (long)(this.heartBeatInterval - 50000) || n2 == 104) {
            this.reciveTimeoutHeartBeat(0);
        }
        this.printfManager("reciveConnectRunError----end---");
    }

    public void reciveTimeoutHeartBeat(int n2) {
        this.printfManager("reciveTimeoutHeartBeat----start---");
        if (this.probeIsStop) {
            MiLinkLog.d(TAG, "probeIsStop is true do nothing reciveTimeoutHeartBeat");
            return;
        }
        long l2 = System.currentTimeMillis();
        if (l2 - this.lastReviveTimeoutHbTime < (long)this.heartBeatInterval) {
            MiLinkLog.e(TAG, "reciveTimeoutHeartBeat but do nothing, currentTime = " + l2 + ", lastReviveTimeoutHbTime = " + this.lastReviveTimeoutHbTime + ",less = " + (l2 - this.lastReviveTimeoutHbTime) + " < heartBeatInterval" + this.heartBeatInterval);
            return;
        }
        if (this.currHeartBeatInfo == null) {
            this.currHeartBeatInfo = new HeartBeatInfo();
        }
        this.currHeartBeatInfo.setOk(false);
        MiLinkLog.e(TAG, "recive TimeoutHeartBeat.packetSeq=" + n2 + ",currHeartBeatInfo = " + this.currHeartBeatInfo);
        HeartBeatManager heartBeatManager = this;
        heartBeatManager.putHBInfoInList(heartBeatManager.currHeartBeatInfo);
        this.startAanalysisHeartBeat();
        this.lastReviveTimeoutHbTime = l2;
        this.printfManager("reciveTimeoutHeartBeat----end---");
    }

    private void putHBInfoInList(HeartBeatInfo heartBeatInfo) {
        if (heartBeatInfo.getSeq() != 0) {
            this.packetList.remove(heartBeatInfo);
        }
        try {
            int n2;
            this.packetList.offer(heartBeatInfo);
            while (true) {
                if ((n2 = this.packetList.size()) <= 2) break;
                MiLinkLog.d(TAG, "packetList poll element.size = ".concat(String.valueOf(n2)));
                this.packetList.poll();
            }
            MiLinkLog.d(TAG, "packetList size = ".concat(String.valueOf(n2)));
            if (this.packetList.size() > 0) {
                for (HeartBeatInfo heartBeatInfo2 : this.packetList) {
                    MiLinkLog.d(TAG, "PacketListInfo = ".concat(String.valueOf(heartBeatInfo2)));
                }
            }
            return;
        }
        catch (Throwable throwable) {
            MiLinkLog.e(TAG, "putHBInfoInList error, err" + throwable.getMessage());
            return;
        }
    }

    private void startAanalysisHeartBeat() {
        int n2 = this.packetList.size();
        MiLinkLog.d(TAG, "currunt modle = " + (Object)((Object)this.modle));
        if (n2 != 2) {
            if (n2 > 0) {
                if (this.getPacketStatus() == ListPacketStatusEnum.ALLFAILED) {
                    this.probeFailedPoint = true;
                    MiLinkLog.d(TAG, "probeFailedPoint = " + this.probeFailedPoint);
                }
                MiLinkLog.d(TAG, "packetLise size = " + n2 + ",do nothing");
            }
            return;
        }
        ListPacketStatusEnum listPacketStatusEnum = this.getPacketStatus();
        MiLinkLog.i(TAG, "list packet status is =" + (Object)((Object)listPacketStatusEnum) + " modle = " + (Object)((Object)this.modle));
        if (listPacketStatusEnum == ListPacketStatusEnum.ALLSUCCESS) {
            this.probeFailedPoint = false;
            if (this.modle == HeartBeatModEnum.INC) {
                this.saveConfig();
                if (this.heartBeatInterval >= maxHeartBeatInterval) {
                    this.probeIsStop = true;
                    this.registerAlarmClock();
                    this.clearHeartBeatManagerInfo(true);
                    this.clearPacketList();
                    this.modle = HeartBeatModEnum.INC;
                    MiLinkLog.i(TAG, "probeIsStop max come heartBeatInterval register alarm time = " + this.heartBeatInterval);
                    return;
                }
                this.heartBeatInterval += 25000;
                if (this.heartBeatInterval >= maxHeartBeatInterval) {
                    this.heartBeatInterval = maxHeartBeatInterval;
                }
                this.registerAlarmClock();
                this.clearHeartBeatManagerInfo(false);
                this.clearPacketList();
                MiLinkLog.d(TAG, "inc heartBeatInterval value = " + this.heartBeatInterval + ",lastHeartBeatInfo=" + this.lastHeartBeatInfo);
            }
            if (this.modle == HeartBeatModEnum.DEC) {
                this.saveConfig();
                this.probeIsStop = true;
                this.registerAlarmClock();
                this.clearHeartBeatManagerInfo(true);
                this.clearPacketList();
                this.modle = HeartBeatModEnum.INC;
                MiLinkLog.i(TAG, "probeIsStop  register alarm time = " + this.heartBeatInterval);
            }
        }
        if (listPacketStatusEnum == ListPacketStatusEnum.ALLFAILED) {
            this.modle = HeartBeatModEnum.DEC;
            this.heartBeatInterval -= 25000;
            if (this.heartBeatInterval < minHeartBeatInterval || this.heartBeatInterval == 0) {
                this.heartBeatInterval = minHeartBeatInterval;
            }
            MiLinkLog.i(TAG, "find all hb status error.heartBeatInterval=" + this.heartBeatInterval + " modle = " + (Object)((Object)this.modle));
            this.saveConfig();
            this.registerAlarmClock();
            this.clearHeartBeatManagerInfo(false);
            this.clearPacketList();
            this.probeFailedPoint = false;
        }
        if (listPacketStatusEnum == ListPacketStatusEnum.BLENDSTATUS) {
            MiLinkLog.i(TAG, "list packet status is =" + (Object)((Object)listPacketStatusEnum) + " modle = " + (Object)((Object)this.modle) + " do nothing.");
            this.probeFailedPoint = true;
        }
    }

    private ListPacketStatusEnum getPacketStatus() {
        boolean bl2 = false;
        boolean bl3 = false;
        Iterator iterator = this.packetList.iterator();
        while (iterator.hasNext()) {
            if (((HeartBeatInfo)iterator.next()).isOk()) {
                bl2 = true;
                continue;
            }
            bl3 = true;
        }
        if (bl2 && bl3) {
            return ListPacketStatusEnum.BLENDSTATUS;
        }
        if (bl2) {
            return ListPacketStatusEnum.ALLSUCCESS;
        }
        if (bl3) {
            return ListPacketStatusEnum.ALLFAILED;
        }
        return ListPacketStatusEnum.ALLSUCCESS;
    }

    public void registerAlarmClock() {
        AlarmClockService.stop();
        AlarmClockService.start(this.heartBeatInterval);
        MiLinkLog.i(TAG, "re registerALarmClock time=" + this.heartBeatInterval);
    }

    public static enum ListPacketStatusEnum {
        ALLSUCCESS,
        ALLFAILED,
        BLENDSTATUS;

    }

    public static enum HeartBeatModEnum {
        INC,
        DEC;

    }

    private class HeartBeatInfo {
        private int seq;
        private long sendTime;
        private boolean isOk;

        private HeartBeatInfo() {
        }

        public boolean isOk() {
            return this.isOk;
        }

        public void setOk(boolean bl2) {
            this.isOk = bl2;
        }

        public long getSendTime() {
            return this.sendTime;
        }

        public int getSeq() {
            return this.seq;
        }

        public void setSeq(int n2) {
            this.seq = n2;
        }

        public void setSendTime(long l2) {
            this.sendTime = l2;
        }

        public String toString() {
            return "[seq:" + this.seq + ",isOk:" + this.isOk + " sendTime:" + this.sendTime + "]";
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof HeartBeatInfo)) {
                return false;
            }
            object = (HeartBeatInfo)object;
            return this.getSeq() == ((HeartBeatInfo)object).getSeq();
        }
    }
}

