/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.config;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.base.os.info.NetworkDash;
import com.mi.milink.sdk.base.os.info.WifiDash;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.session.common.OptimumServerData;
import com.mi.milink.sdk.session.common.RecentlyServerData;
import com.mi.milink.sdk.session.common.ServerProfile;
import com.mi.milink.sdk.session.common.ThreadHelper;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public abstract class IIpInfoManager {
    protected AppIpConfig mIpInfo = null;
    private static final String DEFAULT_OPTIMUM_SERVER_KEY = "other";
    private List<ServerProfile> mBackupIPList = null;
    private ConcurrentHashMap<String, OptimumServerData> mOptimumIpMap = null;
    private ConcurrentHashMap<String, RecentlyServerData> mRcentlyIpMap = null;
    private ConcurrentHashMap<String, String> mApnIspMap = null;
    protected static final String TAG = "IIpInfoManager";
    private static String sNetApnKey;
    private int appId;

    public int getAppId() {
        return this.appId;
    }

    protected IIpInfoManager() {
        this.appId = Global.getClientAppInfo().getAppId();
        this.init();
    }

    protected IIpInfoManager(int n2) {
        this.appId = n2;
        this.init();
    }

    protected abstract String getOptimumServerFileName();

    protected abstract String getBackupServerFileName();

    protected abstract String getRecentlyServerFileName();

    protected abstract String getApnIspFileName();

    public abstract void destroy();

    public String getDefaultHost() {
        if (this.mIpInfo == null) {
            return "";
        }
        return this.mIpInfo.getHost();
    }

    public ServerProfile[] getTestBackupIp() {
        return this.mIpInfo.getTestBackupIpList();
    }

    public ServerProfile getDefaultServer() {
        return new ServerProfile(this.getDefaultHost(), 0, 1, 4);
    }

    public synchronized OptimumServerData getCurrentApnOptimumServerData() {
        String string2 = DEFAULT_OPTIMUM_SERVER_KEY;
        String string3 = IIpInfoManager.getCurrentApn();
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            string2 = this.getApnIspMap().get(string3);
        }
        MiLinkLog.v(TAG, "get current apn optimum server list, apnKey is " + string3 + ", ispKey is" + string2);
        return this.getOptimumServerData(string2);
    }

    private synchronized OptimumServerData getOptimumServerData(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            MiLinkLog.v(TAG, "get optimum server list, the value of the key is empty, use default key");
            string2 = DEFAULT_OPTIMUM_SERVER_KEY;
        } else {
            MiLinkLog.v(TAG, "get optimum server list, key is ".concat(String.valueOf(string2)));
        }
        OptimumServerData optimumServerData = this.getOptimumIpMap().get(string2);
        MiLinkLog.v(TAG, "getOptimumServerData serverData:" + optimumServerData + ",ispKey:" + string2);
        return optimumServerData;
    }

    public synchronized void setOptmumServerList(String string2, List<ServerProfile> list) {
        if (list != null && !list.isEmpty()) {
            OptimumServerData optimumServerData;
            String string3;
            if (TextUtils.isEmpty((CharSequence)string2)) {
                MiLinkLog.v(TAG, "set optimum server list, but key is empty, use default key");
                string2 = DEFAULT_OPTIMUM_SERVER_KEY;
            }
            if (!TextUtils.isEmpty((CharSequence)(string3 = IIpInfoManager.getCurrentApn()))) {
                this.getApnIspMap().put(string3, string2);
                this.saveApnIspMap();
            }
            if ((optimumServerData = this.getOptimumServerData(string2)) == null) {
                optimumServerData = new OptimumServerData();
            }
            optimumServerData.setOptimumServers(list);
            optimumServerData.setTimeStamp(System.currentTimeMillis());
            this.getOptimumIpMap().put(string2, optimumServerData);
            this.saveOptimumServerMap();
            MiLinkLog.w(TAG, "setOptmumServerList serverData:" + optimumServerData + ",ispKey:" + string2 + ",apnKey:" + string3);
            return;
        }
        MiLinkLog.w(TAG, "serverList is null");
    }

    public synchronized RecentlyServerData getRecentlyServerData() {
        String string2 = IIpInfoManager.getCurrentApn();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                RecentlyServerData recentlyServerData = this.getRcentlyIpMap().get(string2);
                MiLinkLog.v(TAG, "getRecentlyServerData serverData:" + recentlyServerData + ",apnKey:" + string2);
                return recentlyServerData;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public void setRecentlyServer(final ServerProfile serverProfile) {
        ThreadHelper.NETWORK.submit(new Runnable(){

            @Override
            public void run() {
                MiLinkLog.i(IIpInfoManager.TAG, "thread-pool: setRecentlyServer start");
                if (serverProfile != null) {
                    RecentlyServerData recentlyServerData = IIpInfoManager.this.getRecentlyServerData();
                    if (recentlyServerData == null) {
                        recentlyServerData = new RecentlyServerData();
                    }
                    recentlyServerData.setRecentlyServer(serverProfile);
                    recentlyServerData.setTimeStamp(System.currentTimeMillis());
                    String string2 = IIpInfoManager.getCurrentApn();
                    if (!TextUtils.isEmpty((CharSequence)string2)) {
                        IIpInfoManager.this.getRcentlyIpMap().put(string2, recentlyServerData);
                        IIpInfoManager.this.saveRecentlyServerMap();
                        MiLinkLog.v(IIpInfoManager.TAG, "setRecentlyServer serverData:" + recentlyServerData + ",apnKey:" + string2);
                    } else {
                        MiLinkLog.v(IIpInfoManager.TAG, "set recently server list, but key is null");
                    }
                }
                MiLinkLog.i(IIpInfoManager.TAG, "thread-pool: setRecentlyServer end");
            }
        });
    }

    public synchronized void setBackupServerList(List<ServerProfile> list) {
        if (list != null && !list.isEmpty()) {
            this.mBackupIPList = list;
            this.saveBackupServerList();
        }
    }

    public synchronized List<ServerProfile> getBackupServerList() {
        if (this.mBackupIPList == null) {
            try {
                this.mBackupIPList = (List)IIpInfoManager.loadObject(this.getBackupServerFileName());
            }
            catch (Exception exception) {
                this.mBackupIPList = null;
            }
            if (this.mBackupIPList == null) {
                this.mBackupIPList = new ArrayList<ServerProfile>();
            }
        }
        if (this.mBackupIPList.isEmpty()) {
            ServerProfile[] cfr_ignored_0 = new ServerProfile[0];
            ServerProfile[] serverProfileArray = this.mIpInfo.getOnlineBackupIpList();
            for (int i2 = 0; i2 < serverProfileArray.length; ++i2) {
                this.mBackupIPList.add(serverProfileArray[i2]);
            }
        }
        return this.mBackupIPList;
    }

    public synchronized ConcurrentHashMap<String, OptimumServerData> getOptimumIpMap() {
        if (this.mOptimumIpMap == null) {
            try {
                this.mOptimumIpMap = (ConcurrentHashMap)IIpInfoManager.loadObject(this.getOptimumServerFileName());
            }
            catch (Exception exception) {
                this.mOptimumIpMap = null;
            }
            if (this.mOptimumIpMap == null) {
                this.mOptimumIpMap = new ConcurrentHashMap();
            }
        }
        return this.mOptimumIpMap;
    }

    public synchronized ConcurrentHashMap<String, RecentlyServerData> getRcentlyIpMap() {
        if (this.mRcentlyIpMap == null) {
            try {
                this.mRcentlyIpMap = (ConcurrentHashMap)IIpInfoManager.loadObject(this.getRecentlyServerFileName());
            }
            catch (Exception exception) {
                this.mRcentlyIpMap = null;
            }
            if (this.mRcentlyIpMap == null) {
                this.mRcentlyIpMap = new ConcurrentHashMap();
            }
        }
        return this.mRcentlyIpMap;
    }

    public synchronized ConcurrentHashMap<String, String> getApnIspMap() {
        if (this.mApnIspMap == null) {
            try {
                this.mApnIspMap = (ConcurrentHashMap)IIpInfoManager.loadObject(this.getApnIspFileName());
            }
            catch (Exception exception) {
                this.mApnIspMap = null;
            }
            if (this.mApnIspMap == null) {
                this.mApnIspMap = new ConcurrentHashMap();
            }
        }
        return this.mApnIspMap;
    }

    private synchronized boolean saveOptimumServerMap() {
        return IIpInfoManager.saveObject(this.mOptimumIpMap, this.getOptimumServerFileName());
    }

    private synchronized boolean saveBackupServerList() {
        return IIpInfoManager.saveObject(this.mBackupIPList, this.getBackupServerFileName());
    }

    private synchronized boolean saveRecentlyServerMap() {
        return IIpInfoManager.saveObject(this.mRcentlyIpMap, this.getRecentlyServerFileName());
    }

    private synchronized boolean saveApnIspMap() {
        return IIpInfoManager.saveObject(this.mApnIspMap, this.getApnIspFileName());
    }

    public static void loadCurrentApn() {
        sNetApnKey = "";
        ThreadHelper.NETWORK.submit(new Runnable(){

            @Override
            public final void run() {
                MiLinkLog.i(IIpInfoManager.TAG, "thread-pool: loadCurrentApn start");
                String string2 = null;
                MiLinkLog.d(IIpInfoManager.TAG, "start getCurrentApn ");
                if (NetworkDash.isMobile()) {
                    string2 = NetworkDash.getApnName();
                } else if (NetworkDash.isWifi()) {
                    string2 = WifiDash.getBSSID();
                } else if (NetworkDash.isEthernet()) {
                    string2 = "ethernet";
                } else {
                    MiLinkLog.i(IIpInfoManager.TAG, "Network(" + (Object)((Object)NetworkDash.getType()) + ") is unkown");
                }
                if ("00:00:00:00:00:00".equals(string2)) {
                    string2 = null;
                }
                MiLinkLog.d(IIpInfoManager.TAG, "end getCurrentApn key = ".concat(String.valueOf(string2)));
                sNetApnKey = string2;
                MiLinkLog.i(IIpInfoManager.TAG, "thread-pool: loadCurrentApn end");
            }
        });
    }

    public static String getCurrentApn() {
        if (!TextUtils.isEmpty((CharSequence)sNetApnKey)) {
            return sNetApnKey;
        }
        String string2 = null;
        MiLinkLog.d(TAG, "start getCurrentApn ");
        if (NetworkDash.isMobile()) {
            string2 = NetworkDash.getApnName();
        } else if (NetworkDash.isWifi()) {
            string2 = WifiDash.getBSSID();
        } else if (NetworkDash.isEthernet()) {
            string2 = "ethernet";
        } else {
            MiLinkLog.i(TAG, "Network(" + (Object)((Object)NetworkDash.getType()) + ") is unkown");
        }
        if ("00:00:00:00:00:00".equals(string2)) {
            string2 = null;
        }
        MiLinkLog.d(TAG, "end getCurrentApn key = ".concat(String.valueOf(string2)));
        sNetApnKey = string2;
        return string2;
    }

    public static boolean saveObject(Object object, String object2) {
        MiLinkLog.i(TAG, "save ".concat(String.valueOf(object2)));
        ObjectOutputStream objectOutputStream = null;
        Context context = Global.getApplicationContext();
        if (context == null) {
            MiLinkLog.e(TAG, "save object Global.getApplicationContext() == null");
            return false;
        }
        try {
            object2 = context.openFileOutput((String)object2, 0);
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream((OutputStream)object2));
            objectOutputStream.writeObject(object);
        }
        catch (Exception exception) {
            MiLinkLog.e(TAG, "writeObject Exception", exception);
        }
        try {
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
        }
        catch (Exception exception) {
            MiLinkLog.e(TAG, "closeObject Exception", exception);
        }
        return true;
    }

    public static Object loadObject(String string2) {
        Object object;
        MiLinkLog.i(TAG, "load ".concat(String.valueOf(string2)));
        ObjectInputStream objectInputStream = null;
        Context context = Global.getApplicationContext();
        if (context == null) {
            MiLinkLog.e(TAG, "load object Global.getApplicationContext() == null");
            return null;
        }
        try {
            object = context.openFileInput(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            MiLinkLog.e(TAG, "load object FileNotFoundException");
            return null;
        }
        try {
            objectInputStream = new ObjectInputStream((InputStream)object);
            object = objectInputStream.readObject();
        }
        catch (Exception exception) {
            MiLinkLog.e(TAG, "load readObject Exception", exception);
            context.deleteFile(string2);
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (Exception exception2) {
                MiLinkLog.e(TAG, "closeObject Exception", exception2);
            }
            return null;
        }
        try {
            objectInputStream.close();
        }
        catch (Exception exception) {
            MiLinkLog.e(TAG, "closeObject Exception", exception);
        }
        return object;
    }

    protected void init() {
        ServerProfile[] serverProfileArray;
        if (Global.getClientAppInfo(this.appId).getmIpConfig() != null) {
            Log.e((String)"TAG", (String)"custom ip config");
            this.mIpInfo = Global.getClientAppInfo(this.appId).getmIpConfig();
            return;
        }
        ServerProfile[] serverProfileArray2 = Global.getClientAppInfo(this.appId).getDomain();
        ServerProfile[] serverProfileArray3 = Global.getClientAppInfo(this.appId).getBackServer();
        if (!serverProfileArray2.isEmpty() && !serverProfileArray3.isEmpty()) {
            ServerProfile[] serverProfileArray4 = new ServerProfile[]{new ServerProfile((String)serverProfileArray3, 0, 1, 5)};
            serverProfileArray3 = new ServerProfile[]{new ServerProfile((String)serverProfileArray3, 0, 1, 5)};
            this.mIpInfo = new AppIpConfig((String)serverProfileArray2, serverProfileArray4, serverProfileArray3);
            return;
        }
        switch (this.appId) {
            case 10002: 
            case 10004: {
                serverProfileArray = "milink.chat.mi.com";
                serverProfileArray3 = new ServerProfile[]{new ServerProfile("58.83.160.100", 0, 1, 5), new ServerProfile("120.131.6.160", 0, 1, 5), new ServerProfile("123.59.39.164", 0, 1, 5)};
                serverProfileArray2 = new ServerProfile[]{new ServerProfile("111.206.200.91", 0, 1, 5)};
                this.mIpInfo = new AppIpConfig((String)serverProfileArray, serverProfileArray3, serverProfileArray2);
                break;
            }
            case 10001: {
                serverProfileArray = "link.g.mi.com";
                serverProfileArray3 = new ServerProfile[]{new ServerProfile("120.134.33.114", 0, 1, 5), new ServerProfile("42.62.94.188", 0, 1, 5)};
                serverProfileArray2 = new ServerProfile[]{new ServerProfile("42.62.94.226", 0, 1, 5)};
                this.mIpInfo = new AppIpConfig((String)serverProfileArray, serverProfileArray3, serverProfileArray2);
                break;
            }
            case 10011: {
                serverProfileArray = "link.zifei.com";
                serverProfileArray3 = new ServerProfile[]{new ServerProfile("120.134.33.114", 0, 1, 5), new ServerProfile("42.62.94.188", 0, 1, 5)};
                serverProfileArray2 = new ServerProfile[]{new ServerProfile("42.62.94.50", 0, 1, 5)};
                this.mIpInfo = new AppIpConfig((String)serverProfileArray, serverProfileArray3, serverProfileArray2);
                break;
            }
            case 10005: {
                serverProfileArray = new ServerProfile[]{new ServerProfile("120.134.33.152", 0, 1, 5)};
                serverProfileArray3 = new ServerProfile[]{new ServerProfile("42.62.94.226", 0, 1, 5)};
                this.mIpInfo = new AppIpConfig("ent.g.mi.com", serverProfileArray, serverProfileArray3);
                break;
            }
            case 20001: {
                serverProfileArray = "migc.g.mi.com";
                serverProfileArray3 = new ServerProfile[]{new ServerProfile("58.83.160.115", 0, 1, 5)};
                serverProfileArray2 = new ServerProfile[]{new ServerProfile("42.62.94.101", 0, 1, 5)};
                this.mIpInfo = new AppIpConfig((String)serverProfileArray, serverProfileArray3, serverProfileArray2);
                break;
            }
            case 30001: {
                serverProfileArray = new ServerProfile[]{new ServerProfile("58.83.160.115", 0, 1, 5), new ServerProfile("124.243.204.80", 0, 1, 5)};
                serverProfileArray3 = new ServerProfile[]{new ServerProfile("10.99.184.86", 0, 1, 5)};
                this.mIpInfo = new AppIpConfig("mipush.g.mi.com", serverProfileArray, serverProfileArray3);
                break;
            }
            case 10006: {
                serverProfileArray = "milink.misupport.mi.com";
                serverProfileArray3 = new ServerProfile[]{new ServerProfile("124.243.204.139", 0, 1, 5)};
                serverProfileArray2 = new ServerProfile[]{new ServerProfile("42.62.94.226", 0, 1, 5)};
                this.mIpInfo = new AppIpConfig((String)serverProfileArray, serverProfileArray3, serverProfileArray2);
                break;
            }
            case 10007: 
            case 10008: {
                serverProfileArray = Global.getClientAppInfo(this.appId).getReleaseChannel().equals("meng_1254_11_android") ? new ServerProfile[]{new ServerProfile("58.83.160.92", 0, 1, 5), new ServerProfile("120.92.24.134", 0, 1, 5)} : new ServerProfile[]{new ServerProfile("58.83.160.92", 0, 1, 5), new ServerProfile("120.92.24.134", 0, 1, 5)};
                serverProfileArray3 = new ServerProfile[]{new ServerProfile("111.206.200.91", 0, 1, 5)};
                this.mIpInfo = new AppIpConfig("milink.zb.mi.com", serverProfileArray, serverProfileArray3);
                break;
            }
            case 10014: {
                serverProfileArray = new ServerProfile[]{new ServerProfile("124.251.58.163", 0, 1, 5), new ServerProfile("120.92.24.139", 0, 1, 5)};
                serverProfileArray3 = new ServerProfile[]{new ServerProfile("42.62.94.50", 0, 1, 5)};
                this.mIpInfo = new AppIpConfig("milink.mtk.g.mi.com", serverProfileArray, serverProfileArray3);
                break;
            }
            case 20003: {
                serverProfileArray = new ServerProfile[]{new ServerProfile("120.92.24.145", 0, 1, 5), new ServerProfile("58.83.177.15", 0, 1, 5)};
                serverProfileArray3 = new ServerProfile[]{new ServerProfile("42.62.94.31", 0, 1, 5)};
                this.mIpInfo = new AppIpConfig("mishop.g.mi.com", serverProfileArray, serverProfileArray3);
                break;
            }
            case 10009: {
                serverProfileArray = new ServerProfile[]{new ServerProfile("42.62.94.50", 0, 1, 5)};
                serverProfileArray3 = new ServerProfile[]{new ServerProfile("42.62.94.50", 0, 1, 5)};
                this.mIpInfo = new AppIpConfig("milink.ac.mi.com", serverProfileArray, serverProfileArray3);
                break;
            }
            case 10010: {
                serverProfileArray = new ServerProfile[]{new ServerProfile("58.83.177.14", 0, 1, 5)};
                serverProfileArray3 = new ServerProfile[]{new ServerProfile("42.62.94.50", 0, 1, 5)};
                this.mIpInfo = new AppIpConfig("knights.g.mi.com", serverProfileArray, serverProfileArray3);
                break;
            }
            case 20002: {
                if (Global.getClientAppInfo().getReleaseChannel().equals("oversea")) {
                    serverProfileArray = new ServerProfile[]{new ServerProfile("47.74.174.24", 0, 1, 5)};
                    serverProfileArray3 = new ServerProfile[]{new ServerProfile("111.206.101.160", 0, 1, 5)};
                    this.mIpInfo = new AppIpConfig("gmsdk.inter.g.mi.com", serverProfileArray, serverProfileArray3);
                    break;
                }
                serverProfileArray = new ServerProfile[]{new ServerProfile("58.83.160.173", 0, 1, 5)};
                serverProfileArray3 = new ServerProfile[]{new ServerProfile("111.206.101.160", 0, 1, 5)};
                this.mIpInfo = new AppIpConfig("gmsdk.g.mi.com", serverProfileArray, serverProfileArray3);
                break;
            }
            case 10012: {
                serverProfileArray = new ServerProfile[]{new ServerProfile("120.92.24.145", 0, 1, 5), new ServerProfile("58.83.177.15", 0, 1, 5)};
                serverProfileArray3 = new ServerProfile[]{new ServerProfile("42.62.94.31", 0, 1, 5)};
                this.mIpInfo = new AppIpConfig("milink.go.g.mi.com", serverProfileArray, serverProfileArray3);
                break;
            }
            case 20005: {
                serverProfileArray = new ServerProfile[]{new ServerProfile("58.83.177.15", 0, 1, 5), new ServerProfile("120.92.158.18", 0, 1, 5)};
                serverProfileArray3 = new ServerProfile[]{new ServerProfile("123.125.103.178", 0, 1, 5)};
                this.mIpInfo = new AppIpConfig("milink.migc.g.mi.com", serverProfileArray, serverProfileArray3);
                break;
            }
            case 20006: {
                serverProfileArray = new ServerProfile[]{new ServerProfile("58.83.177.15", 0, 1, 5), new ServerProfile("120.92.24.145", 0, 1, 5)};
                serverProfileArray3 = new ServerProfile[]{new ServerProfile("111.206.200.91", 0, 1, 5)};
                this.mIpInfo = new AppIpConfig("milink.migc.g.mi.com", serverProfileArray, serverProfileArray3);
            }
        }
        if (this.appId >= 100001 && this.appId < 200000) {
            serverProfileArray = new ServerProfile[]{new ServerProfile("58.83.160.92", 0, 1, 5), new ServerProfile("120.92.24.134", 0, 1, 5)};
            serverProfileArray3 = new ServerProfile[]{new ServerProfile("10.105.44.12", 0, 1, 5)};
            this.mIpInfo = new AppIpConfig("milink.ac.mi.com", serverProfileArray, serverProfileArray3);
        }
    }

    public static class AppIpConfig {
        private String host;
        private ServerProfile[] onlineBackupIpList;
        private ServerProfile[] testBackupIpList;

        public AppIpConfig(String string2, ServerProfile[] serverProfileArray, ServerProfile[] serverProfileArray2) {
            this.host = string2;
            this.onlineBackupIpList = serverProfileArray;
            this.testBackupIpList = serverProfileArray2;
        }

        public String getHost() {
            return this.host;
        }

        public ServerProfile[] getOnlineBackupIpList() {
            return this.onlineBackupIpList;
        }

        public ServerProfile[] getTestBackupIpList() {
            return this.testBackupIpList;
        }
    }
}

