/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.connection;

import android.os.SystemClock;
import android.util.Log;
import android.util.SparseArray;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.base.os.Native;
import com.mi.milink.sdk.connection.IConnection;
import com.mi.milink.sdk.connection.IConnectionCallback;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.session.common.MsgProcessor;
import com.mi.milink.sdk.session.simplechannel.SessionForSimpleChannel;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ConnectionImpl
implements IConnection {
    private static final String CLASSTAG = "ConnectionImpl";
    private ConcurrentHashMap<Integer, Object> mMsgObjectMap = new ConcurrentHashMap();
    private AtomicInteger mReferenceNo = new AtomicInteger(1);
    private static volatile boolean sIsLoaded = false;
    private int mType = 0;
    private MsgProcessor mMsgProc = null;
    private IConnectionCallback mCallback = null;
    private long mNativeContext;
    private String TAG;
    private int mCreatorSessionNO;
    private static final int MSG_ID_ON_START = 0;
    private static final int MSG_ID_ON_CONNECT = 1;
    private static final int MSG_ID_ON_DISCONNECT = 2;
    private static final int MSG_ID_ON_ERROR = 3;
    private static final int MSG_ID_ON_TIMEOUT = 4;
    private static final int MSG_ID_ON_RECV = 5;
    private static final int MSG_ID_ON_SENDBEGIN = 6;
    private static final int MSG_ID_ON_SENDEND = 7;
    private static final int MSG_ID_ON_MSGPROC = 8;
    private static SparseArray<String> sMsgMap;
    private static List<ConnectPrintLogCallback> sLogCallbackList;

    public static boolean isLibLoaded() {
        return sIsLoaded;
    }

    public ConnectionImpl(int n2, int n3) {
        long l2 = SystemClock.elapsedRealtime();
        if (!sIsLoaded) {
            return;
        }
        this.mCreatorSessionNO = n2;
        this.TAG = String.format("[No:%d]%s", n2, CLASSTAG);
        this.mType = n3;
        try {
            this.native_setup(new WeakReference<ConnectionImpl>(this), this.mType, 1);
        }
        catch (Throwable throwable) {
            MiLinkLog.e(this.TAG, "native_setup failed", throwable);
        }
        long l3 = SystemClock.elapsedRealtime();
        Log.e((String)SessionForSimpleChannel.class.getName(), (String)("session open init 1-1-1 : " + (l3 - l2)));
    }

    protected void finalize() {
        MiLinkLog.w(this.TAG, "finalize connection");
        try {
            this.native_finalize();
        }
        catch (Exception exception) {
            MiLinkLog.e(this.TAG, "finalize failed", exception);
        }
        try {
            if (this.mMsgProc != null) {
                this.mMsgProc.onMsgProc(4, null, 0);
            }
            return;
        }
        catch (Exception exception) {
            MiLinkLog.e(this.TAG, "finalize failed", exception);
            return;
        }
    }

    private static final native void native_init();

    private final native void native_setup(Object var1, int var2, int var3);

    private final native void native_finalize();

    @Override
    public boolean postMessage(int n2, Object object, int n3, MsgProcessor object2) {
        if (!sIsLoaded) {
            MiLinkLog.e(this.TAG, "postMessage failed:lib is unloaded");
            return false;
        }
        this.mMsgProc = object2;
        object2 = 0;
        if (object != null) {
            object2 = this.mReferenceNo.getAndIncrement();
            this.mMsgObjectMap.put((Integer)object2, object);
        }
        try {
            return this.postMessage(n2, (Integer)object2, n3);
        }
        catch (Exception exception) {
            MiLinkLog.e(this.TAG, "postMessage failed", exception);
            return false;
        }
    }

    @Override
    public void setCallback(IConnectionCallback iConnectionCallback) {
        this.mCallback = iConnectionCallback;
    }

    @Override
    public String getServerIP() {
        return null;
    }

    @Override
    public int getServerPort() {
        return 0;
    }

    @Override
    public int getConnectionType() {
        return this.mType;
    }

    @Override
    public native boolean start();

    @Override
    public native boolean stop();

    @Override
    public native void wakeUp();

    public native boolean postMessage(int var1, int var2, int var3);

    @Override
    public native boolean connect(String var1, int var2, String var3, int var4, int var5, int var6);

    @Override
    public native boolean disconnect();

    @Override
    public native boolean sendData(byte[] var1, int var2, int var3);

    @Override
    public native void removeSendData(int var1);

    @Override
    public native void removeAllSendData();

    @Override
    public native boolean isSendDone(int var1);

    @Override
    public native boolean isRunning();

    private static void postEventFromNative(Object object, int n2, int n3, int n4, Object object2) {
        try {
            object = (ConnectionImpl)((WeakReference)object).get();
            if (object == null) {
                return;
            }
            MiLinkLog.v(CLASSTAG, "postEventFromNative msg:" + (String)sMsgMap.get(n2) + ", arg1=" + n3 + ", arg2=" + n4 + " to SessionNo:" + ((ConnectionImpl)object).mCreatorSessionNO);
            switch (n2) {
                case 0: {
                    ((ConnectionImpl)object).onStart();
                    return;
                }
                case 1: {
                    ((ConnectionImpl)object).onConnect(n3 != 0, n4);
                    return;
                }
                case 2: {
                    ((ConnectionImpl)object).onDisconnect();
                    return;
                }
                case 3: {
                    ((ConnectionImpl)object).onError(n3);
                    return;
                }
                case 4: {
                    ((ConnectionImpl)object).onTimeOut(n3, n4);
                    return;
                }
                case 5: {
                    ((ConnectionImpl)object).onRecv((byte[])object2);
                    return;
                }
                case 6: {
                    ((ConnectionImpl)object).onSendBegin(n3);
                    return;
                }
                case 7: {
                    ((ConnectionImpl)object).onSendEnd(n3);
                    return;
                }
                case 8: {
                    ((ConnectionImpl)object).onMsgProc(n3, object2, n4);
                    return;
                }
            }
            Log.e((String)CLASSTAG, (String)"Unknown message type ".concat(String.valueOf(n2)));
            return;
        }
        catch (Exception exception) {
            MiLinkLog.e(CLASSTAG, "postEventFromNative Exception", exception);
            return;
        }
    }

    public static final void printLog(int n2, String string2) {
        String string3 = Thread.currentThread().getName();
        if (string3.startsWith("Thread-")) {
            string3 = string3.substring(7, string3.length());
            Thread.currentThread().setName("Milink-Socket-".concat(String.valueOf(string3)));
        }
        if (n2 >= 6) {
            MiLinkLog.e("native", string2);
        } else if (n2 >= 5) {
            MiLinkLog.w("native", string2);
        } else if (n2 >= 4) {
            MiLinkLog.i("native", string2);
        } else {
            MiLinkLog.d("native", string2);
        }
        ConnectionImpl.notifyConnectPrintLogCallback(n2, string2);
    }

    public static synchronized void addConnectPrintLogCallback(ConnectPrintLogCallback connectPrintLogCallback) {
        if (connectPrintLogCallback != null) {
            sLogCallbackList.add(connectPrintLogCallback);
        }
    }

    public static synchronized void removeConnectPrintLogCallback(ConnectPrintLogCallback connectPrintLogCallback) {
        if (connectPrintLogCallback != null) {
            sLogCallbackList.remove(connectPrintLogCallback);
        }
    }

    private static synchronized void notifyConnectPrintLogCallback(int n2, String string2) {
        for (int i2 = 0; i2 < sLogCallbackList.size(); ++i2) {
            sLogCallbackList.get(i2).printLogCallback(n2, string2);
        }
    }

    public boolean onStart() {
        if (this.mCallback == null) {
            return false;
        }
        return this.mCallback.onStart();
    }

    public boolean onConnect(boolean bl2, int n2) {
        if (this.mCallback == null) {
            return false;
        }
        return this.mCallback.onConnect(bl2, n2);
    }

    public boolean onDisconnect() {
        if (this.mCallback == null) {
            return false;
        }
        return this.mCallback.onDisconnect();
    }

    public boolean onError(int n2) {
        if (this.mCallback == null) {
            return false;
        }
        return this.mCallback.onError(n2);
    }

    public boolean onTimeOut(int n2, int n3) {
        if (this.mCallback == null) {
            return false;
        }
        return this.mCallback.onTimeOut(n2, n3);
    }

    public boolean onRecv(byte[] byArray) {
        if (this.mCallback == null) {
            return false;
        }
        return this.mCallback.onRecv(byArray);
    }

    public boolean onSendBegin(int n2) {
        if (this.mCallback == null) {
            return false;
        }
        return this.mCallback.onSendBegin(n2);
    }

    public boolean onSendEnd(int n2) {
        if (this.mCallback == null) {
            return false;
        }
        return this.mCallback.onSendEnd(n2);
    }

    public boolean onMsgProc(int n2, Object object, int n3) {
        if (this.mMsgProc == null) {
            return false;
        }
        object = this.mMsgObjectMap.remove(object);
        this.mMsgProc.onMsgProc(n2, object, n3);
        return true;
    }

    static {
        try {
            String string2 = "connectionbase";
            String string3 = "milinkconnection";
            boolean bl2 = Native.loadLibrary(string2);
            boolean bl3 = Native.loadLibrary(string3);
            if (!bl2 && bl3) {
                bl2 = Native.loadLibrary(string2);
            }
            sIsLoaded = bl2 && bl3;
            ConnectionImpl.native_init();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            MiLinkLog.e(CLASSTAG, "System.loadLibrary failed", unsatisfiedLinkError);
            sIsLoaded = false;
        }
        catch (Exception exception) {
            MiLinkLog.e(CLASSTAG, "System.loadLibrary failed", exception);
            sIsLoaded = false;
        }
        if (Global.getClientAppInfo().getAppId() == 20003) {
            sIsLoaded = true;
        }
        MiLinkLog.i(CLASSTAG, "loadLibrary return " + sIsLoaded);
        sMsgMap = new SparseArray();
        sMsgMap.put(0, (Object)"onStart");
        sMsgMap.put(1, (Object)"onConnect");
        sMsgMap.put(2, (Object)"onDisconnect");
        sMsgMap.put(3, (Object)"onError");
        sMsgMap.put(4, (Object)"onTimeout");
        sMsgMap.put(5, (Object)"onRecv");
        sMsgMap.put(6, (Object)"onSendBegin");
        sMsgMap.put(7, (Object)"onSendEnd");
        sMsgMap.put(8, (Object)"onMsgProc");
        sLogCallbackList = new ArrayList<ConnectPrintLogCallback>();
    }

    public static interface ConnectPrintLogCallback {
        public void printLogCallback(int var1, String var2);
    }
}

