/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.connection;

import android.annotation.SuppressLint;
import android.os.SystemClock;
import com.mi.milink.sdk.base.os.info.AccessPoint;
import com.mi.milink.sdk.base.os.info.DnsDash;
import com.mi.milink.sdk.base.os.info.NetworkDash;
import com.mi.milink.sdk.base.os.info.WifiDash;
import com.mi.milink.sdk.config.ConfigManager;
import com.mi.milink.sdk.debug.InternalDataMonitor;
import com.mi.milink.sdk.debug.MiLinkLog;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public class DomainManager {
    public static final int RET_CODE_DNS_SUCCESS = 0;
    public static final int RET_CODE_DNS_UNKNOWN_HOST = 10000;
    public static final int RET_CODE_DNS_TIME_OUT = 10001;
    public static final int RET_CODE_DNS_LOCAL_EXCEPTION = 10002;
    private static final String TAG = "DomainManager";
    private static final int SLEEP_INTERVAL = 10;
    private static final int THREAD_MAX_COUNT = 5;
    private static DomainManager sInstanse = null;
    private String mKey = AccessPoint.NONE.getName();
    private ConcurrentHashMap<String, String> mDomainMap = new ConcurrentHashMap();
    private HashMap<String, String> mApnDomainMap = new HashMap();
    private ResolveThread[] mDefaultHostThreads = new ResolveThread[5];
    private boolean dnsTimeoutReport = false;

    private DomainManager() {
    }

    public static synchronized DomainManager getInstance() {
        if (sInstanse == null) {
            sInstanse = new DomainManager();
        }
        return sInstanse;
    }

    public void startResolve(String string2) {
        if (!NetworkDash.isAvailable()) {
            MiLinkLog.i(TAG, "startResolve, but network is unavailable");
            return;
        }
        MiLinkLog.i(TAG, "startResolve");
        if (this.isNeedResolve()) {
            this.mDomainMap.clear();
            this.startDnsThread(string2);
            return;
        }
        if (this.mApnDomainMap.containsKey(this.mKey) && this.mDomainMap.contains(string2) && !this.mDomainMap.get(string2).equals(this.mApnDomainMap.get(this.mKey))) {
            this.mDomainMap.put(string2, this.mApnDomainMap.get(this.mKey));
        }
    }

    private boolean isNeedResolve() {
        String string2 = this.getKey();
        if (string2 == null) {
            this.mKey = null;
            return true;
        }
        if (this.mApnDomainMap.containsKey(string2)) {
            this.mKey = string2;
            return false;
        }
        if (!string2.equalsIgnoreCase(this.mKey)) {
            this.mKey = string2;
            return true;
        }
        return false;
    }

    private synchronized ResolveThread startDnsThread(String string2) {
        int n2;
        for (n2 = 0; n2 < 5; ++n2) {
            if (this.mDefaultHostThreads[n2] != null && this.mDefaultHostThreads[n2].isAlive()) {
                if (this.mDefaultHostThreads[n2].getKey() != this.mKey) {
                    this.mDefaultHostThreads[n2].setExpired(true);
                    continue;
                }
                if (this.mKey != null) {
                    return this.mDefaultHostThreads[n2];
                }
                this.mDefaultHostThreads[n2].setExpired(true);
                continue;
            }
            MiLinkLog.i(TAG, "startDefaultHostThread");
            this.mDefaultHostThreads[n2] = new ResolveThread(string2, this.mKey);
            this.mDefaultHostThreads[n2].setDaemon(true);
            this.mDefaultHostThreads[n2].start();
            return this.mDefaultHostThreads[n2];
        }
        if (n2 == 5) {
            MiLinkLog.e(TAG, "startDefaultHostThread running thread is more than 5");
        }
        return null;
    }

    private String getKey() {
        String string2 = null;
        if (NetworkDash.isMobile()) {
            string2 = NetworkDash.getApnName();
        } else if (NetworkDash.isWifi()) {
            string2 = WifiDash.getBSSID();
        } else {
            MiLinkLog.e(TAG, "getKey Network(" + (Object)((Object)NetworkDash.getType()) + ") is unkown");
        }
        if ("00:00:00:00:00:00".equals(string2)) {
            MiLinkLog.e(TAG, "getKey Network(" + (Object)((Object)NetworkDash.getType()) + ") is 00:00:00:00:00:00");
            string2 = null;
        }
        return string2;
    }

    public String queryDomainIP(String string2) {
        String string3 = this.mDomainMap.get(string2);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    @SuppressLint(value={"DefaultLocale"})
    public String getDomainIP(String string2) {
        String string3;
        Long l2;
        block7: {
            this.dnsTimeoutReport = false;
            l2 = SystemClock.elapsedRealtime();
            string3 = this.mDomainMap.get(string2);
            if (string3 == null) {
                long l3 = ConfigManager.getInstance().getDnsTimeout();
                long l4 = 0L;
                long l5 = SystemClock.elapsedRealtime();
                ResolveThread resolveThread = this.startDnsThread(string2);
                if (resolveThread == null) {
                    return null;
                }
                while ((string3 = this.mDomainMap.get(string2)) == null) {
                    if (l4 > l3 || resolveThread.isCompleted()) {
                        string3 = this.mDomainMap.get(string2);
                        if (l4 > l3 && string3 == null) {
                            this.dnsTimeoutReport = true;
                            this.statistic(l5, string2, string3, 10001);
                            MiLinkLog.d(TAG, "DNS\u4e0a\u62a5 \u8d85\u65f6\u4e0a\u62a5");
                        }
                        break block7;
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        MiLinkLog.e(TAG, "getDomainIP InterruptedException", interruptedException);
                        return null;
                    }
                    l4 += 10L;
                }
                return string3;
            }
        }
        MiLinkLog.e(TAG, String.format("milink dns %s cosumed time %d", string2, SystemClock.elapsedRealtime() - l2));
        return string3;
    }

    private void statistic(long l2, String string2, String string3, int n2) {
        String string4 = "domain [domain = " + string2 + ",ip = " + string3 + ",client localDNS = " + DnsDash.updateLocalDns() + ", errCode=" + n2;
        long l3 = SystemClock.elapsedRealtime();
        MiLinkLog.w(TAG, string4 + ",timecost = " + (l3 - l2) + "ms]");
        MiLinkLog.d(TAG, "DNS\u4e0a\u62a5\uff1a beginTime==" + l2 + " domian==" + string2 + " ip==" + string3 + " errorCode==" + n2);
        InternalDataMonitor.getInstance().trace(string2, 0, "milink.dns", n2, l2, l3, 0, 0, 0);
    }

    private void setDomainIP(String string2, String string3) {
        if (this.mKey != null) {
            this.mApnDomainMap.put(this.mKey, string3);
        }
        this.mDomainMap.put(string2, string3);
    }

    private class ResolveThread
    extends Thread {
        private String mDomain = null;
        private volatile boolean mIsExpired = false;
        private volatile String mKey = null;
        private volatile boolean mIsCompleted = false;

        public ResolveThread(String string2, String string3) {
            this.mDomain = string2;
            this.mKey = string3;
        }

        public void setExpired(boolean bl2) {
            this.mIsExpired = bl2;
        }

        public String getKey() {
            return this.mKey;
        }

        public boolean isCompleted() {
            return this.mIsCompleted;
        }

        @Override
        public void run() {
            String string2 = null;
            this.mIsCompleted = false;
            int n2 = 0;
            long l2 = SystemClock.elapsedRealtime();
            try {
                string2 = InetAddress.getByName(this.mDomain).getHostAddress();
                if (string2 != null && !this.mIsExpired) {
                    DomainManager.this.setDomainIP(this.mDomain, string2);
                }
            }
            catch (UnknownHostException unknownHostException) {
                MiLinkLog.e(DomainManager.TAG, "Inet Address Analyze fail exception : ", unknownHostException);
                n2 = 10000;
            }
            catch (Exception exception) {
                MiLinkLog.e(DomainManager.TAG, "Inet Address Analyze fail exception : ", exception);
                n2 = 10002;
            }
            catch (Error error) {
                MiLinkLog.e(DomainManager.TAG, "Inet Address Analyze fail exception : ", error);
                n2 = 10002;
            }
            this.mIsCompleted = true;
            MiLinkLog.d(DomainManager.TAG, "DNS\u4e0a\u62a5 \u8d85\u65f6\u540e \u53c8\u6709\u7ed3\u679c");
            if (!DomainManager.this.dnsTimeoutReport) {
                DomainManager.this.statistic(l2, this.mDomain, string2, n2);
            }
        }
    }
}

