/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.base.data.Convert;
import com.mi.milink.sdk.config.IIpInfoManager;
import com.mi.milink.sdk.session.common.ServerProfile;
import java.util.ArrayList;

public class ClientAppInfo
implements Parcelable {
    public static final int VTALK_APP_ID = 10001;
    public static final int MILIAO_APP_ID_TEMP = 10002;
    public static final int MILIAO_APP_ID = 10004;
    public static final int ON_APP_ID = 10011;
    public static final int FORUM_APP_ID = 10005;
    public static final int SUPPORT_APP_ID = 10006;
    public static final int GAME_CENTER_APP_ID = 20001;
    public static final int XIAOMI_PUSH_APP_ID = 30001;
    public static final int LIVE_APP_ID = 10007;
    public static final int LIVE_SDK_APP_ID = 10008;
    public static final int MILIAO_2 = 10014;
    public static final int CARTOON_APP_ID = 10009;
    public static final int KNIGHTS_APP_ID = 10010;
    public static final int GAME_LOGIN_PAY_SDK = 20002;
    public static final int MI_SHOP_APP_ID = 20003;
    public static final int MI_NEW_GAME_CENTER_APP_ID = 20005;
    public static final int YI_MI_BUY = 10012;
    public static final int LIVE_PUSH_SDK_BOTTOM = 100001;
    public static final int LIVE_PUSH_SDK_UP = 200000;
    public static final int MI_GAME_CHIJI_APP_ID = 20006;
    public static final int MODE_LONG_CONNECTION = 0;
    public static final int MODE_MEDIUM_CONNECTION = 1;
    private static final String DEFAULT_LANGUAGE_CODE = "zh_CN";
    private int appId = 0;
    private String platformName = "and";
    private String appName = "N/A";
    private String versionName = "N/A";
    private int versionCode = 0;
    public String releaseChannel = "N/A";
    private String packageName = "N/A";
    private int mMode = 0;
    private String languageCode = "zh_CN";
    private String logPath = "";
    private String mipushAppId = "";
    private String mipushAppKey = "";
    private String gv = "";
    private String serviceProcessName = "";
    private boolean isIpModle;
    private String domain = "";
    private String backServer = "";
    private boolean isHeartBeatEnable = true;
    private String customTag = "";
    public IIpInfoManager.AppIpConfig mIpConfig = null;
    private String oneTrackAppId = null;
    private int maxLog = 0x500000;
    public static final Parcelable.Creator<ClientAppInfo> CREATOR = new Parcelable.Creator<ClientAppInfo>(){

        public final ClientAppInfo createFromParcel(Parcel parcel) {
            ClientAppInfo clientAppInfo = new ClientAppInfo("");
            clientAppInfo.readFromParcel(parcel);
            return clientAppInfo;
        }

        public final ClientAppInfo[] newArray(int n2) {
            return new ClientAppInfo[n2];
        }
    };

    public IIpInfoManager.AppIpConfig getmIpConfig() {
        return this.mIpConfig;
    }

    public void setmIpConfig(IIpInfoManager.AppIpConfig appIpConfig) {
        this.mIpConfig = appIpConfig;
    }

    public ClientAppInfo(String string2) {
        this.fromString(string2);
    }

    private ClientAppInfo(Builder builder) {
        this.appId = builder.appId;
        this.platformName = builder.platformName;
        this.versionCode = builder.versionCode;
        this.versionName = builder.versionName;
        this.appName = builder.appName;
        this.releaseChannel = builder.releaseChannel;
        this.packageName = builder.packageName;
        this.serviceProcessName = builder.serviceProcessName;
        this.languageCode = builder.languageCode;
        this.logPath = builder.logPath;
        this.mipushAppId = builder.mipushAppId;
        this.mipushAppKey = builder.mipushAppKey;
        this.gv = builder.gv;
        this.mMode = builder.mMode;
        this.domain = builder.domain;
        this.backServer = builder.backServer;
        this.isIpModle = builder.isIpModle();
        this.mIpConfig = builder.mConfig;
        if (this.appId == 0) {
            throw new IllegalArgumentException("appid can not be 0, error!");
        }
        if (this.versionCode == 0) {
            throw new IllegalArgumentException("versionCode can not be 0, error!");
        }
        if ("N/A".equals(this.versionName)) {
            throw new IllegalArgumentException("versionName is not correct, error!");
        }
        if ("N/A".equals(this.appName)) {
            throw new IllegalArgumentException("appName is not correct, error!");
        }
        if ("N/A".equals(this.releaseChannel)) {
            throw new IllegalArgumentException("releaseChannel is not correct, error!");
        }
        if ("N/A".equals(this.packageName)) {
            throw new IllegalArgumentException("packageName is not correct, error!");
        }
    }

    public boolean isMediumConnection() {
        return this.mMode == 1;
    }

    private void setLinkMode(int n2) {
        this.mMode = n2;
    }

    public int getLinkMode() {
        return this.mMode;
    }

    public String getGv() {
        return this.gv;
    }

    private void setGv(String string2) {
        this.gv = string2;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public int getAppId() {
        return this.appId;
    }

    @Deprecated
    public String getMiPushAppId() {
        return this.mipushAppId;
    }

    private void setMiPushAppId(String string2) {
        this.mipushAppId = string2;
    }

    private void setMiPushAppKey(String string2) {
        this.mipushAppKey = string2;
    }

    @Deprecated
    public String getMiPushAppKey() {
        return this.mipushAppKey;
    }

    private void setAppId(int n2) {
        this.appId = n2;
    }

    public int getVersionCode() {
        return this.versionCode;
    }

    public String getAppName() {
        return this.appName;
    }

    private void setVersionCode(int n2) {
        this.versionCode = n2;
    }

    public String getVersionName() {
        return this.versionName;
    }

    private void setVersionName(String string2) {
        this.versionName = string2;
    }

    public String getReleaseChannel() {
        return this.releaseChannel;
    }

    public String getOneTrackAppId() {
        return this.oneTrackAppId;
    }

    public void setReleaseChannel(String string2) {
        this.releaseChannel = string2;
    }

    public boolean isIpModle() {
        return this.isIpModle;
    }

    public void setIpModle(boolean bl2) {
        this.isIpModle = bl2;
    }

    private void setAppName(String string2) {
        this.appName = string2;
    }

    public String getPackageName() {
        return this.packageName;
    }

    private void setPackageName(String string2) {
        this.packageName = string2;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getBackServer() {
        return this.backServer;
    }

    public void setDomain(String string2) {
        this.domain = string2;
    }

    public void setBackServer(String string2) {
        this.backServer = string2;
    }

    public boolean isHeartBeatEnable() {
        return this.isHeartBeatEnable;
    }

    public void setHeartBeatEnable(boolean bl2) {
        this.isHeartBeatEnable = bl2;
    }

    public String getCustomTag() {
        return this.customTag;
    }

    public void setCustomTag(String string2) {
        this.customTag = string2;
    }

    public boolean isHasSetAccServerDomain() {
        return !Global.getClientAppInfo().getDomain().isEmpty() && !Global.getClientAppInfo().getBackServer().isEmpty();
    }

    public void setLanguageCode(String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.languageCode = string2;
            return;
        }
        this.languageCode = DEFAULT_LANGUAGE_CODE;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public void setLogPath(String string2) {
        this.logPath = string2;
    }

    public String toString() {
        return this.appId + ";" + this.versionCode + ";" + this.versionName + ";" + this.releaseChannel + ";" + this.appName + ";" + this.packageName + ";" + this.languageCode + ";" + this.logPath + ";" + this.platformName + ";";
    }

    private void fromString(String stringArray) {
        if (!TextUtils.isEmpty((CharSequence)stringArray)) {
            stringArray = stringArray.split(";");
            this.setAppId(Convert.strToInt(stringArray[0], 0));
            this.setVersionCode(Convert.strToInt(stringArray[1], 1));
            this.setVersionName(stringArray[2]);
            this.setReleaseChannel(stringArray[3]);
            if (stringArray.length > 4) {
                this.setAppName(stringArray[4]);
            }
            if (stringArray.length > 5) {
                this.setPackageName(stringArray[5]);
            }
            if (stringArray.length > 6) {
                this.setLanguageCode(stringArray[6]);
            }
            if (stringArray.length > 7) {
                this.setLogPath(stringArray[7]);
            }
            if (stringArray.length > 8) {
                this.setServiceProcessName(stringArray[8]);
            }
            if (stringArray.length > 9) {
                this.setMiPushAppId(stringArray[9]);
            }
            if (stringArray.length > 10) {
                this.setMiPushAppKey(stringArray[10]);
            }
            if (stringArray.length > 11) {
                this.setGv(stringArray[11]);
            }
            if (stringArray.length > 12) {
                this.setLinkMode(Convert.strToInt(stringArray[12], 12));
            }
            if (stringArray.length > 13) {
                this.setPlatformName(stringArray[13]);
            }
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        int n3;
        parcel.writeInt(this.getAppId());
        parcel.writeInt(this.getVersionCode());
        parcel.writeString(this.getVersionName());
        parcel.writeString(this.getReleaseChannel());
        parcel.writeString(this.getAppName());
        parcel.writeString(this.getPackageName());
        parcel.writeString(this.getLanguageCode());
        parcel.writeString(this.getLogPath());
        parcel.writeString(this.getServiceProcessName());
        parcel.writeString(this.getMiPushAppId());
        parcel.writeString(this.getMiPushAppKey());
        parcel.writeString(this.getGv());
        parcel.writeInt(this.getLinkMode());
        parcel.writeString(this.getPlatformName());
        parcel.writeString(this.mIpConfig.getHost());
        String string2 = null;
        String string3 = null;
        for (n3 = 0; n3 < this.mIpConfig.getOnlineBackupIpList().length; ++n3) {
            string2 = TextUtils.isEmpty(string2) ? String.format("%s", this.mIpConfig.getOnlineBackupIpList()[n3].toString()) : String.format("%s;%s", string2, this.mIpConfig.getOnlineBackupIpList()[n3].toString());
        }
        for (n3 = 0; n3 < this.mIpConfig.getTestBackupIpList().length; ++n3) {
            string3 = TextUtils.isEmpty(string3) ? String.format("%s", this.mIpConfig.getTestBackupIpList()[n3].toString()) : String.format("%s;%s", string3, this.mIpConfig.getTestBackupIpList()[n3].toString());
        }
        parcel.writeString(string2);
        parcel.writeString(string3);
    }

    public void readFromParcel(Parcel object) {
        this.setAppId(object.readInt());
        this.setVersionCode(object.readInt());
        this.setVersionName(object.readString());
        this.setReleaseChannel(object.readString());
        this.setAppName(object.readString());
        this.setPackageName(object.readString());
        this.setLanguageCode(object.readString());
        this.setLogPath(object.readString());
        this.setServiceProcessName(object.readString());
        this.setMiPushAppId(object.readString());
        this.setMiPushAppKey(object.readString());
        this.setGv(object.readString());
        this.setLinkMode(object.readInt());
        this.setPlatformName(object.readString());
        String string2 = object.readString();
        ArrayList<ServerProfile> arrayList = new ArrayList<ServerProfile>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        Object[] objectArray = object.readString();
        if (!objectArray.isEmpty()) {
            objectArray = objectArray.split(";");
            int n2 = objectArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object2 = objectArray[i2];
                ServerProfile object3 = new ServerProfile();
                object3.parseFromString((String)object2);
                arrayList.add(object3);
            }
        }
        if (!(objectArray = object.readString()).isEmpty()) {
            for (String string3 : objectArray.split(";")) {
                object = new ServerProfile();
                ((ServerProfile)object).parseFromString(string3);
                arrayList2.add(object);
            }
        }
        objectArray = new ServerProfile[arrayList.size()];
        ServerProfile[] serverProfileArray = new ServerProfile[arrayList2.size()];
        arrayList.toArray(objectArray);
        arrayList2.toArray(serverProfileArray);
        IIpInfoManager.AppIpConfig appIpConfig = new IIpInfoManager.AppIpConfig(string2, (ServerProfile[])objectArray, serverProfileArray);
        this.setmIpConfig(appIpConfig);
    }

    private void setPlatformName(String string2) {
        this.platformName = string2;
    }

    public static boolean isTestChannel() {
        return Global.getClientAppInfo().getReleaseChannel().contains("test") || Global.getClientAppInfo().getReleaseChannel().contains("TEST");
    }

    public static boolean isTestChannel(int n2) {
        return Global.getClientAppInfo(n2).getReleaseChannel().contains("test") || Global.getClientAppInfo(n2).getReleaseChannel().contains("TEST");
    }

    public static boolean isMiliaoApp() {
        return Global.getClientAppInfo().getAppId() == 10002 || Global.getClientAppInfo().getAppId() == 10004;
    }

    public static boolean isForumApp() {
        return Global.getClientAppInfo().getAppId() == 10005;
    }

    public static boolean isVtalkApp() {
        return Global.getClientAppInfo().getAppId() == 10001;
    }

    public static boolean isOnApp() {
        return Global.getClientAppInfo().getAppId() == 10011;
    }

    public static boolean isGameCenterApp() {
        return Global.getClientAppInfo().getAppId() == 20001;
    }

    public static boolean isXiaoMiPushApp() {
        return Global.getClientAppInfo().getAppId() == 30001;
    }

    public static boolean isSupportApp() {
        return Global.getClientAppInfo().getAppId() == 10006;
    }

    public static boolean isLiveApp() {
        return Global.getClientAppInfo().getAppId() == 10007;
    }

    @Deprecated
    public static boolean isSupportMiPush() {
        String string2 = Global.getClientAppInfo().getMiPushAppId();
        String string3 = Global.getClientAppInfo().getMiPushAppKey();
        return !TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3);
    }

    public static int isHigherVersion(ClientAppInfo clientAppInfo, ClientAppInfo clientAppInfo2) {
        if (clientAppInfo == null || clientAppInfo2 == null) {
            return 0;
        }
        return clientAppInfo.getVersionCode() - clientAppInfo2.getVersionCode();
    }

    public String getServiceProcessName() {
        return this.serviceProcessName;
    }

    private void setServiceProcessName(String string2) {
        this.serviceProcessName = string2;
    }

    public void setMaxLog(int n2) {
        this.maxLog = n2;
    }

    public final int getMaxLog() {
        return this.maxLog;
    }

    public static class Builder {
        private int appId = 0;
        private String platformName = "and";
        private int versionCode = 0;
        private String appName = "N/A";
        private String versionName = "N/A";
        private String releaseChannel = "N/A";
        private String packageName = "N/A";
        private String serviceProcessName = "";
        private String languageCode = "zh_CN";
        private String logPath = "";
        private String mipushAppId = "";
        private String mipushAppKey = "";
        private String gv = "";
        private int mMode = 0;
        private boolean isIpModle;
        private String domain = "";
        private String backServer = "";
        private IIpInfoManager.AppIpConfig mConfig = null;
        private boolean heartBeat = true;
        private String customTag = "";
        private int maxLog = 0x500000;

        public Builder(int n2) {
            this.appId = n2;
        }

        public boolean isIpModle() {
            return this.isIpModle;
        }

        public void setIpModle(boolean bl2) {
            this.isIpModle = bl2;
        }

        public Builder setVersionCode(int n2) {
            this.versionCode = n2;
            return this;
        }

        public Builder setVersionName(String string2) {
            this.versionName = string2;
            return this;
        }

        public Builder setReleaseChannel(String string2) {
            this.releaseChannel = string2;
            return this;
        }

        public Builder setIPConfig(IIpInfoManager.AppIpConfig appIpConfig) {
            this.mConfig = appIpConfig;
            return this;
        }

        public Builder setAppName(String string2) {
            this.appName = string2;
            return this;
        }

        public Builder setPackageName(String string2) {
            this.packageName = string2;
            return this;
        }

        public Builder setServiceProcessName(String string2) {
            this.serviceProcessName = string2;
            return this;
        }

        public Builder setLanguageCode(String string2) {
            this.languageCode = string2;
            return this;
        }

        public Builder setLogPath(String string2) {
            this.logPath = string2;
            return this;
        }

        public Builder setMipushAppKey(String string2) {
            this.mipushAppKey = string2;
            return this;
        }

        public Builder setMipushAppId(String string2) {
            this.mipushAppId = string2;
            return this;
        }

        public Builder setPlatformName(String string2) {
            this.platformName = string2;
            return this;
        }

        public Builder setGv(String string2) {
            this.gv = string2;
            return this;
        }

        public Builder setLinkMode(int n2) {
            this.mMode = n2;
            return this;
        }

        public Builder setDomain(String string2) {
            this.domain = string2;
            return this;
        }

        public Builder setBackServer(String string2) {
            this.backServer = string2;
            return this;
        }

        public Builder setHeartBeat(boolean bl2) {
            this.heartBeat = bl2;
            return this;
        }

        public String getCustomTag() {
            return this.customTag;
        }

        public void setCustomTag(String string2) {
            this.customTag = string2;
        }

        public void setMaxLog(int n2) {
            this.maxLog = n2;
        }

        public ClientAppInfo build() {
            return new ClientAppInfo(this);
        }
    }
}

