/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.debug;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Message;
import android.os.PowerManager;
import com.mi.milink.sdk.account.manager.MiAccountManager;
import com.mi.milink.sdk.base.CustomHandlerThread;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.event.BaseMilinkEvent;
import com.mi.milink.sdk.monitor.ServiceQualityBean;
import com.xiaomi.onetrack.Configuration;
import com.xiaomi.onetrack.OneTrack;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.greenrobot.eventbus.EventBus;

public abstract class BaseDataMonitor
extends CustomHandlerThread {
    public static final int RET_CODE_OK = 0;
    public static final int RET_CODE_TIME_OUT = 1;
    public static final int RET_CODE_TOKEN_EXPIRED = 2;
    public static final int RET_CODE_PING_TIME_OUT = 3;
    public static final int RET_CODE_ABANDONED_SESSION_NOT_READY = 4;
    public static final int MESSAGE_UPLOAD_DATA = 10;
    private static final String TAG = "BaseDataMonitor";
    protected final ConcurrentHashMap<String, List<MonitorItem>> mMonitorItemMap = new ConcurrentHashMap();
    protected long mUploadInterval = 0L;
    protected boolean mSamplingStatisticsSwitch = false;
    protected boolean mLoopPost = true;
    protected boolean mSwitch = true;
    protected String stasticServerHost;
    protected String stasticServerAddIp;
    protected String stasticServerAdd;
    boolean mStarted = false;
    private long mLastUploadTs;
    public OneTrack mMilinkOneTrack;
    private Random random = new Random();

    protected BaseDataMonitor(String string2) {
        super(string2);
        this.initOneTrack();
    }

    protected void initOneTrack() {
        Object object = Global.getClientAppInfo().getOneTrackAppId();
        MiLinkLog.d(TAG, "\u6536\u5230\u7684oneTrackAppId: ".concat(String.valueOf(object)));
        if (this.mMilinkOneTrack == null) {
            object = new Configuration.Builder().setAppId("31000000147").setChannel(Global.getClientAppInfo().getReleaseChannel()).setMode(OneTrack.Mode.SDK).setExceptionCatcherEnable(true).setUseCustomPrivacyPolicy(true).build();
            this.mMilinkOneTrack = OneTrack.createInstance(Global.getContext(), (Configuration)object);
            this.mMilinkOneTrack.setCustomPrivacyPolicyAccepted(true);
        }
    }

    public void trace(String string2, int n2, String string3, int n3, long l2, long l3, int n4, int n5, int n6) {
        this.trace("milink_cmd", string2, n2, string3, n3, l2, l3, n4, n5, n6, MiAccountManager.getInstance().getUserId());
    }

    public void trace(final String string2, final String string3, final int n2, final String string4, final int n3, final long l2, final long l3, final int n4, final int n5, final int n6, final String string5) {
        if (this.mHandler == null) {
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                BaseDataMonitor.this.traceToServer(string2, string3, n2, string4, n3, l2, l3, n4, n5, n6, string5, Global.getClientIp(), Global.getClientIsp());
            }
        });
    }

    protected void traceToServer(String object, String string2, int n2, String string3, int n3, long l2, long l3, int n4, int n5, int n6, String string4, String string5, String string6) {
        this.updateServiceQuality((String)object, string2, n2, string3, n3, l2, l3, n4, n5, n6, string4, string5, string6);
        object = new MonitorItem();
        new MonitorItem().cmd = string3;
        ((MonitorItem)object).waste = l3 - l2;
        ((MonitorItem)object).isSuccess = n3 == 0;
        ((MonitorItem)object).errorCode = n3;
        ((MonitorItem)object).requestTime = l2;
        ((MonitorItem)object).responseTime = l3;
        ((MonitorItem)object).ipPort = string2 + ":" + n2;
        if ("milink.firstheartbeat".equals(((MonitorItem)object).cmd) || "milink.handshake".equals(((MonitorItem)object).cmd)) {
            this.addMonitorItem((MonitorItem)object);
            return;
        }
        this.addMonitorItem((MonitorItem)object);
    }

    private void updateServiceQuality(String object, String string2, int n2, String string3, int n3, long l2, long l3, int n4, int n5, int n6, String string4, String string5, String string6) {
        MiLinkLog.d(TAG, "\u670d\u52a1\u8d28\u91cf\u4e0a\u62a5\uff1a " + string2 + " " + n2 + " " + string3 + " " + n3);
        object = new ServiceQualityBean();
        ((ServiceQualityBean)object).setAccIp(string2);
        ((ServiceQualityBean)object).setAccPort(n2);
        ((ServiceQualityBean)object).setCmd(string3);
        ((ServiceQualityBean)object).setRetCode(n3);
        ((ServiceQualityBean)object).setRequestTime(l2);
        ((ServiceQualityBean)object).setResponseTime(l3);
        EventBus.getDefault().post(new BaseMilinkEvent.ServiceQualityEvent((ServiceQualityBean)object));
    }

    public void addMonitorItem(MonitorItem monitorItem) {
        if (monitorItem != null && this.mSwitch) {
            List<Object> list;
            String string2 = monitorItem.cmd;
            if (this.mMonitorItemMap.containsKey(string2)) {
                list = this.mMonitorItemMap.get(string2);
                if (list == null) {
                    return;
                }
            } else {
                list = new ArrayList();
                this.mMonitorItemMap.put(string2, list);
            }
            if (list.size() < 100) {
                list.add(monitorItem);
                if (!this.mStarted) {
                    BaseDataMonitor baseDataMonitor = this;
                    baseDataMonitor.startUpload(baseDataMonitor.mUploadInterval);
                    return;
                }
            } else if (System.currentTimeMillis() - this.mLastUploadTs > this.mUploadInterval) {
                this.startUpload(0L);
            }
        }
    }

    protected void startUpload(long l2) {
        this.mStarted = true;
        this.removeMessage(10);
        Message message = this.obtainMessage();
        this.obtainMessage().what = 10;
        this.sendMessageDelayed(message, l2);
    }

    public void trace(String string2, int n2, String string3, int n3, long l2, long l3, int n4, int n5, int n6, String string4, String string5) {
        this.trace("milink_cmd", string2, n2, string3, n3, l2, l3, n4, n5, n6, MiAccountManager.getInstance().getUserId(), string4, string5);
    }

    public void trace(final String string2, final String string3, final int n2, final String string4, final int n3, final long l2, final long l3, final int n4, final int n5, final int n6, final String string5, final String string6, final String string7) {
        if (this.mHandler == null) {
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                BaseDataMonitor.this.traceToServer(string2, string3, n2, string4, n3, l2, l3, n4, n5, n6, string5, string6, string7);
            }
        });
    }

    @Override
    protected void processMessage(Message message) {
        switch (message.what) {
            case 10: {
                this.mLastUploadTs = System.currentTimeMillis();
                message = (PowerManager)Global.getApplicationContext().getSystemService("power");
                boolean bl2 = Build.VERSION.SDK_INT >= 20 ? message.isInteractive() : message.isScreenOn();
                boolean bl3 = true;
                NetworkInfo networkInfo = ((ConnectivityManager)Global.getApplicationContext().getSystemService("connectivity")).getActiveNetworkInfo();
                if (networkInfo != null && networkInfo.getType() == 1) {
                    bl3 = false;
                }
                boolean bl4 = false;
                if (bl3) {
                    MiLinkLog.w(TAG, "is Mobile");
                    if (!bl2) {
                        MiLinkLog.w(TAG, "Screen if off");
                    } else {
                        bl4 = this.doPostData();
                    }
                } else {
                    bl4 = this.doPostData();
                }
                if (bl4) {
                    this.mHandler.removeCallbacksAndMessages((Object)10);
                    if (!this.mLoopPost) break;
                    Message message2 = this.obtainMessage();
                    this.obtainMessage().what = 10;
                    this.sendMessageDelayed(message2, this.mUploadInterval);
                    return;
                }
                MiLinkLog.d(TAG, "no more data");
                this.mStarted = false;
            }
        }
    }

    protected abstract boolean doPostData();

    protected abstract String toJson(ConcurrentHashMap<String, List<MonitorItem>> var1);

    public static class MonitorItem
    implements Serializable {
        private static final long serialVersionUID = -5333015815983866181L;
        public String cmd;
        public boolean isSuccess = false;
        public int errorCode = 0;
        public long waste = 0L;
        public long requestTime = 0L;
        public long responseTime = 0L;
        public String ipPort = null;
    }
}

