/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.debug;

import android.text.TextUtils;
import com.mi.milink.sdk.account.manager.MiAccountManager;
import com.mi.milink.sdk.account.manager.MiChannelAccountManager;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.base.os.info.NetworkDash;
import com.mi.milink.sdk.data.ClientAppInfo;
import com.mi.milink.sdk.debug.BaseDataMonitor;
import com.mi.milink.sdk.debug.MiLinkLog;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class InternalDataMonitor
extends BaseDataMonitor {
    private static String TAG_PRE = "InternalDataMonitor";
    private String TAG = "InternalDataMonitor";
    private static InternalDataMonitor sInstance = new InternalDataMonitor();
    private static ConcurrentHashMap<Integer, InternalDataMonitor> monitorMap = new ConcurrentHashMap();
    private int appId;
    private byte alarmArriveTimes = 0;

    public static InternalDataMonitor getInstance(int n2) {
        InternalDataMonitor internalDataMonitor = monitorMap.get(n2);
        if (internalDataMonitor == null) {
            internalDataMonitor = new InternalDataMonitor();
            new InternalDataMonitor().appId = n2;
            monitorMap.put(n2, internalDataMonitor);
        }
        return internalDataMonitor;
    }

    private InternalDataMonitor(int n2) {
        super(TAG_PRE);
        this.appId = n2;
        if (n2 == 20002) {
            this.mSamplingStatisticsSwitch = false;
            return;
        }
        this.mSamplingStatisticsSwitch = true;
    }

    private InternalDataMonitor() {
        super(TAG_PRE);
        this.appId = Global.getClientAppInfo().getAppId();
        this.TAG = this.TAG + this.appId;
        if (this.appId == 20002) {
            this.mSamplingStatisticsSwitch = false;
            return;
        }
        this.mSamplingStatisticsSwitch = true;
    }

    public void doPostDataAtOnce() {
        MiLinkLog.w(this.TAG, "doPostDataAtOnce()");
        this.startUpload(0L);
    }

    public synchronized void onAlarmArrive() {
        this.mLoopPost = false;
        this.alarmArriveTimes = (byte)(this.alarmArriveTimes + 1);
        if (this.alarmArriveTimes >= 2) {
            this.doPostDataAtOnce();
            this.alarmArriveTimes = 0;
        }
    }

    @Override
    protected boolean doPostData() {
        if (this.mMonitorItemMap.isEmpty()) {
            MiLinkLog.v(this.TAG, "dopost but map is empty!");
            MiLinkLog.w(this.TAG, "mMonitorItemMap em()");
            return false;
        }
        if (!NetworkDash.isAvailable()) {
            MiLinkLog.v(this.TAG, "dopost but network is available");
            return false;
        }
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        concurrentHashMap.putAll(this.mMonitorItemMap);
        this.mMonitorItemMap.clear();
        if (!(TextUtils.isEmpty((CharSequence)MiAccountManager.getInstance().getUserId()) && !MiChannelAccountManager.hasInit || ClientAppInfo.isTestChannel())) {
            for (Object object : concurrentHashMap.keySet()) {
                for (BaseDataMonitor.MonitorItem monitorItem : (List)concurrentHashMap.get(object)) {
                    if (this.mMilinkOneTrack == null) continue;
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("mappid", this.appId);
                    hashMap.put("cversion", Global.getClientAppInfo(this.appId).getVersionName());
                    hashMap.put("mversion", Global.getMiLinkVersion());
                    hashMap.put("cmd", monitorItem.cmd);
                    hashMap.put("waste_time", monitorItem.waste);
                    hashMap.put("error_code", monitorItem.errorCode);
                    hashMap.put("req_ts", monitorItem.requestTime);
                    hashMap.put("res_ts", monitorItem.responseTime);
                    hashMap.put("info", "");
                    hashMap.put("server_ip_port", monitorItem.ipPort);
                    this.mMilinkOneTrack.track("milink", hashMap);
                    MiLinkLog.d(this.TAG, "\u6570\u636e\u4e0a\u62a5 InternalDataMonitor:  ".concat(String.valueOf(hashMap)));
                }
            }
        }
        return false;
    }

    @Override
    protected String toJson(ConcurrentHashMap<String, List<BaseDataMonitor.MonitorItem>> concurrentHashMap) {
        String string2 = "";
        if (concurrentHashMap != null) {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("ac", (Object)"milink_cmd");
                jSONObject.put("appid", (Object)String.valueOf(this.appId));
                jSONObject.put("cversion", (Object)String.valueOf(Global.getClientAppInfo(this.appId).getVersionCode()));
                jSONObject.put("mversion", (Object)String.valueOf(Global.getMiLinkVersion()));
                JSONArray jSONArray = new JSONArray();
                for (String string3 : concurrentHashMap.keySet()) {
                    Object object = concurrentHashMap.get(string3);
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("cmd", (Object)string3);
                    int n2 = 0;
                    int n3 = 0;
                    JSONArray jSONArray2 = new JSONArray();
                    JSONArray jSONArray3 = new JSONArray();
                    JSONArray jSONArray4 = new JSONArray();
                    JSONArray jSONArray5 = new JSONArray();
                    object = object.iterator();
                    while (object.hasNext()) {
                        BaseDataMonitor.MonitorItem monitorItem = (BaseDataMonitor.MonitorItem)object.next();
                        if (monitorItem.isSuccess) {
                            ++n2;
                            if (monitorItem.waste < 0L) continue;
                            jSONArray2.put(monitorItem.waste);
                            jSONArray4.put((Object)(monitorItem.requestTime + "###" + monitorItem.responseTime));
                            continue;
                        }
                        ++n3;
                        JSONObject jSONObject3 = new JSONObject();
                        jSONObject3.put("errCode", monitorItem.errorCode);
                        jSONObject3.put("waste", monitorItem.waste);
                        jSONArray3.put((Object)jSONObject3);
                        jSONArray5.put((Object)(monitorItem.requestTime + "###" + monitorItem.responseTime));
                    }
                    jSONObject2.put("successTimes", n2);
                    if (jSONArray2.length() > 0) {
                        jSONObject2.put("successWasteArray", (Object)jSONArray2);
                        jSONObject2.put("successTimestamps", (Object)jSONArray4);
                    }
                    jSONObject2.put("failedTimes", n3);
                    jSONObject2.put("failedInfo", (Object)jSONArray3);
                    jSONObject2.put("failedTimestamps", (Object)jSONArray5);
                    jSONArray.put((Object)jSONObject2);
                }
                if (jSONArray.length() > 0) {
                    jSONObject.put("data", (Object)jSONArray);
                    string2 = jSONObject.toString();
                }
            }
            catch (JSONException jSONException) {
                MiLinkLog.e(this.TAG, "toJson", jSONException);
            }
        }
        return string2;
    }

    public static InternalDataMonitor getInstance() {
        return sInstance;
    }
}

