/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.debug;

import android.text.TextUtils;
import com.mi.milink.sdk.account.manager.MiAccountManager;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.base.os.info.NetworkDash;
import com.mi.milink.sdk.client.ipc.ClientLog;
import com.mi.milink.sdk.data.ClientAppInfo;
import com.mi.milink.sdk.debug.BaseDataMonitor;
import com.mi.milink.sdk.debug.MiLinkLog;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MiLinkMonitor
extends BaseDataMonitor {
    private static String TAG_PRE = "MiLinkMonitor_";
    private String TAG = "MiLinkMonitor_";
    private static MiLinkMonitor sInstance = new MiLinkMonitor();
    private static ConcurrentHashMap<Integer, MiLinkMonitor> monitorMap = new ConcurrentHashMap();
    private int appId;
    private boolean mEnable = false;

    public static MiLinkMonitor getInstance(int n2) {
        MiLinkMonitor miLinkMonitor = monitorMap.get(n2);
        if (miLinkMonitor == null) {
            miLinkMonitor = new MiLinkMonitor();
            new MiLinkMonitor().appId = n2;
            monitorMap.put(n2, miLinkMonitor);
        }
        return miLinkMonitor;
    }

    private MiLinkMonitor(int n2) {
        super(TAG_PRE);
        this.appId = n2;
        this.mSamplingStatisticsSwitch = false;
        this.mLoopPost = true;
        MiLinkMonitor miLinkMonitor = this;
        miLinkMonitor.startUpload(miLinkMonitor.mUploadInterval);
    }

    private MiLinkMonitor() {
        super(TAG_PRE);
        this.appId = Global.getClientAppInfo().getAppId();
        this.TAG = this.TAG + this.appId;
        this.mSamplingStatisticsSwitch = false;
        this.mLoopPost = true;
        MiLinkMonitor miLinkMonitor = this;
        miLinkMonitor.startUpload(miLinkMonitor.mUploadInterval);
    }

    public void doPostDataAtOnce() {
        ClientLog.w(this.TAG, "doPostDataAtOnce()");
        this.startUpload(0L);
    }

    public void setEnableWithLogoutStatus(boolean bl2) {
        this.mEnable = bl2;
    }

    @Override
    protected boolean doPostData() {
        if (NetworkDash.isAvailable() && this.mMonitorItemMap.size() > 0) {
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
            concurrentHashMap.putAll(this.mMonitorItemMap);
            this.mMonitorItemMap.clear();
            if (!(!this.mEnable && TextUtils.isEmpty((CharSequence)MiAccountManager.getInstance().getUserId()) || ClientAppInfo.isTestChannel())) {
                for (Object object : concurrentHashMap.keySet()) {
                    for (BaseDataMonitor.MonitorItem monitorItem : (List)concurrentHashMap.get(object)) {
                        if (this.mMilinkOneTrack == null) continue;
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        hashMap.put("mappid", Global.getClientAppInfo(this.appId).getAppId());
                        hashMap.put("cversion", Global.getClientAppInfo(this.appId).getVersionName());
                        hashMap.put("mversion", Global.getMiLinkVersion());
                        hashMap.put("cmd", monitorItem.cmd);
                        hashMap.put("waste_time", monitorItem.waste);
                        hashMap.put("error_code", monitorItem.errorCode);
                        hashMap.put("req_ts", monitorItem.requestTime);
                        hashMap.put("res_ts", monitorItem.responseTime);
                        hashMap.put("info", "");
                        hashMap.put("server_ip_port", monitorItem.ipPort);
                        this.mMilinkOneTrack.track("milink", hashMap);
                        MiLinkLog.d(this.TAG, "\u6570\u636e\u4e0a\u62a5 InternalDataMonitor:  ".concat(String.valueOf(hashMap)));
                    }
                }
            }
        }
        return false;
    }

    @Override
    protected String toJson(ConcurrentHashMap<String, List<BaseDataMonitor.MonitorItem>> concurrentHashMap) {
        String string2 = "";
        if (concurrentHashMap != null) {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("ac", (Object)"milink_cmd");
                JSONArray jSONArray = new JSONArray();
                for (String string3 : concurrentHashMap.keySet()) {
                    Object object = concurrentHashMap.get(string3);
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("cmd", (Object)string3);
                    int n2 = 0;
                    int n3 = 0;
                    JSONArray jSONArray2 = new JSONArray();
                    JSONArray jSONArray3 = new JSONArray();
                    object = object.iterator();
                    while (object.hasNext()) {
                        BaseDataMonitor.MonitorItem monitorItem = (BaseDataMonitor.MonitorItem)object.next();
                        if (monitorItem.isSuccess) {
                            ++n2;
                            if (monitorItem.waste < 0L) continue;
                            jSONArray2.put(monitorItem.waste);
                            continue;
                        }
                        ++n3;
                        JSONObject jSONObject3 = new JSONObject();
                        jSONObject3.put("errCode", monitorItem.errorCode);
                        jSONObject3.put("waste", monitorItem.waste);
                        jSONArray3.put((Object)jSONObject3);
                    }
                    jSONObject2.put("successTimes", n2);
                    if (jSONArray2.length() > 0) {
                        jSONObject2.put("successWasteArray", (Object)jSONArray2);
                    }
                    jSONObject2.put("failedTimes", n3);
                    jSONObject2.put("failedInfo", (Object)jSONArray3);
                    jSONArray.put((Object)jSONObject2);
                }
                if (jSONArray.length() > 0) {
                    jSONObject.put("data", (Object)jSONArray);
                    string2 = jSONObject.toString();
                }
            }
            catch (JSONException jSONException) {
                ClientLog.e(this.TAG, "toJson", jSONException);
            }
        }
        return string2;
    }

    public static MiLinkMonitor getInstance() {
        return sInstance;
    }
}

